/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.resultset.order;

import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenFieldSharable;
import com.espertech.esper.common.internal.bytecodemodel.util.CodegenFieldSharableComparator;
import com.espertech.esper.common.internal.compile.stage1.spec.OrderByItem;
import com.espertech.esper.common.internal.compile.stage1.spec.RowLimitSpec;
import com.espertech.esper.common.internal.compile.stage2.SelectClauseExprCompiledSpec;
import com.espertech.esper.common.internal.epl.expression.agg.base.ExprAggregateNode;
import com.espertech.esper.common.internal.epl.expression.agg.base.ExprAggregateNodeUtil;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityCompare;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityQuery;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.resultset.order.OrderByElementForge;
import com.espertech.esper.common.internal.epl.resultset.order.OrderByProcessorFactoryForge;
import com.espertech.esper.common.internal.epl.resultset.order.OrderByProcessorForgeImpl;
import com.espertech.esper.common.internal.epl.resultset.order.OrderByProcessorOrderedLimitForge;
import com.espertech.esper.common.internal.epl.resultset.order.OrderByProcessorRowLimitOnlyForge;
import com.espertech.esper.common.internal.epl.resultset.order.RowLimitProcessorFactoryForge;
import com.espertech.esper.common.internal.epl.variable.compiletime.VariableCompileTimeResolver;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderByProcessorFactoryFactory {
    private static final Logger log = LoggerFactory.getLogger(OrderByProcessorFactoryFactory.class);

    public static OrderByProcessorFactoryForge getProcessor(List<SelectClauseExprCompiledSpec> selectionList, List<OrderByItem> orderByList, RowLimitSpec rowLimitSpec, VariableCompileTimeResolver variableCompileTimeResolver, boolean isSortUsingCollator, String optionalContextName, OrderByElementForge[][] orderByRollup) throws ExprValidationException {
        ArrayList<ExprNode> orderByNodes = new ArrayList<ExprNode>();
        for (OrderByItem orderByItem : orderByList) {
            orderByNodes.add(orderByItem.getExprNode());
        }
        if (orderByList.isEmpty()) {
            log.debug(".getProcessor Using no OrderByProcessor");
            if (rowLimitSpec != null) {
                RowLimitProcessorFactoryForge rowLimitProcessorFactory = new RowLimitProcessorFactoryForge(rowLimitSpec, variableCompileTimeResolver, optionalContextName);
                return new OrderByProcessorRowLimitOnlyForge(rowLimitProcessorFactory);
            }
            return null;
        }
        LinkedList<ExprAggregateNode> selectAggNodes = new LinkedList<ExprAggregateNode>();
        for (SelectClauseExprCompiledSpec selectClauseExprCompiledSpec : selectionList) {
            ExprAggregateNodeUtil.getAggregatesBottomUp(selectClauseExprCompiledSpec.getSelectExpression(), selectAggNodes);
        }
        LinkedList<ExprAggregateNode> linkedList = new LinkedList<ExprAggregateNode>();
        for (ExprNode orderByNode : orderByNodes) {
            ExprAggregateNodeUtil.getAggregatesBottomUp(orderByNode, linkedList);
        }
        OrderByProcessorFactoryFactory.validateOrderByAggregates(selectAggNodes, linkedList);
        boolean bl = !selectionList.isEmpty() && !linkedList.isEmpty();
        log.debug(".getProcessor Using OrderByProcessorImpl");
        OrderByElementForge[] elements = OrderByProcessorFactoryFactory.toElementArray(orderByList);
        CodegenFieldSharable comparator = OrderByProcessorFactoryFactory.getComparator(elements, isSortUsingCollator);
        OrderByProcessorForgeImpl orderByProcessorForge = new OrderByProcessorForgeImpl(elements, bl, orderByRollup, comparator);
        if (rowLimitSpec == null) {
            return orderByProcessorForge;
        }
        RowLimitProcessorFactoryForge rowLimitProcessorFactory = new RowLimitProcessorFactoryForge(rowLimitSpec, variableCompileTimeResolver, optionalContextName);
        return new OrderByProcessorOrderedLimitForge(orderByProcessorForge, rowLimitProcessorFactory);
    }

    private static void validateOrderByAggregates(List<ExprAggregateNode> selectAggNodes, List<ExprAggregateNode> orderAggNodes) throws ExprValidationException {
        for (ExprAggregateNode orderAgg : orderAggNodes) {
            boolean inSelect = false;
            for (ExprAggregateNode selectAgg : selectAggNodes) {
                if (!ExprNodeUtilityCompare.deepEquals(selectAgg, orderAgg, false)) continue;
                inSelect = true;
                break;
            }
            if (inSelect) continue;
            throw new ExprValidationException("Aggregate functions in the order-by clause must also occur in the select expression");
        }
    }

    private static CodegenFieldSharable getComparator(OrderByElementForge[] orderBy, boolean isSortUsingCollator) {
        ExprNode[] nodes = new ExprNode[orderBy.length];
        boolean[] descending = new boolean[orderBy.length];
        for (int i = 0; i < orderBy.length; ++i) {
            nodes[i] = orderBy[i].getExprNode();
            descending[i] = orderBy[i].isDescending();
        }
        EPType[] types = ExprNodeUtilityQuery.getExprResultTypes(nodes);
        return new CodegenFieldSharableComparator(CodegenFieldSharableComparator.CodegenSharableSerdeName.COMPARATORHASHABLEMULTIKEYS, types, isSortUsingCollator, descending);
    }

    private static OrderByElementForge[] toElementArray(List<OrderByItem> orderByList) {
        OrderByElementForge[] elements = new OrderByElementForge[orderByList.size()];
        int count = 0;
        for (OrderByItem item : orderByList) {
            elements[count++] = new OrderByElementForge(item.getExprNode(), item.isDescending());
        }
        return elements;
    }
}

