/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.resultset.rowpergroup;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.epl.agg.core.AggregationService;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.resultset.rowpergroup.ResultSetProcessorRowPerGroup;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class ResultSetProcessorRowPerGroupIterator
implements Iterator<EventBean> {
    public static final EPTypeClass EPTYPE = new EPTypeClass(ResultSetProcessorRowPerGroupIterator.class);
    private final Iterator<EventBean> sourceIterator;
    private final ResultSetProcessorRowPerGroup resultSetProcessor;
    private final AggregationService aggregationService;
    private EventBean nextResult;
    private final EventBean[] eventsPerStream;
    private final Set<Object> priorSeenGroups;
    private final ExprEvaluatorContext exprEvaluatorContext;

    public ResultSetProcessorRowPerGroupIterator(Iterator<EventBean> sourceIterator, ResultSetProcessorRowPerGroup resultSetProcessor, AggregationService aggregationService, ExprEvaluatorContext exprEvaluatorContext) {
        this.sourceIterator = sourceIterator;
        this.resultSetProcessor = resultSetProcessor;
        this.aggregationService = aggregationService;
        this.eventsPerStream = new EventBean[1];
        this.priorSeenGroups = new HashSet<Object>();
        this.exprEvaluatorContext = exprEvaluatorContext;
    }

    @Override
    public boolean hasNext() {
        if (this.nextResult != null) {
            return true;
        }
        this.findNext();
        return this.nextResult != null;
    }

    @Override
    public EventBean next() {
        if (this.nextResult != null) {
            EventBean result = this.nextResult;
            this.nextResult = null;
            return result;
        }
        this.findNext();
        if (this.nextResult != null) {
            EventBean result = this.nextResult;
            this.nextResult = null;
            return result;
        }
        throw new NoSuchElementException();
    }

    private void findNext() {
        while (this.sourceIterator.hasNext()) {
            boolean pass;
            EventBean candidate;
            this.eventsPerStream[0] = candidate = this.sourceIterator.next();
            Object groupKey = this.resultSetProcessor.generateGroupKeySingle(this.eventsPerStream, true);
            this.aggregationService.setCurrentAccess(groupKey, this.exprEvaluatorContext.getAgentInstanceId(), null);
            if (this.resultSetProcessor.hasHavingClause() && !(pass = this.resultSetProcessor.evaluateHavingClause(this.eventsPerStream, true, this.exprEvaluatorContext)) || this.priorSeenGroups.contains(groupKey)) continue;
            this.priorSeenGroups.add(groupKey);
            this.nextResult = this.resultSetProcessor.getSelectExprProcessor().process(this.eventsPerStream, true, true, this.exprEvaluatorContext);
            break;
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

