/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.resultset.rowpergrouprollup;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.collection.MultiKeyArrayOfKeys;
import com.espertech.esper.common.internal.collection.UniformPair;
import com.espertech.esper.common.internal.epl.agg.core.AggregationGroupByRollupLevel;
import com.espertech.esper.common.internal.epl.resultset.rowpergrouprollup.ResultSetProcessorRowPerGroupRollup;
import com.espertech.esper.common.internal.epl.resultset.rowpergrouprollup.ResultSetProcessorRowPerGroupRollupOutputAllHelper;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class ResultSetProcessorRowPerGroupRollupOutputAllHelperImpl
implements ResultSetProcessorRowPerGroupRollupOutputAllHelper {
    private final ResultSetProcessorRowPerGroupRollup processor;
    private final Map<Object, EventBean[]>[] outputLimitGroupRepsPerLevel;
    private final Map<Object, EventBean>[] groupRepsOutputLastUnordRStream;
    private boolean first;

    public ResultSetProcessorRowPerGroupRollupOutputAllHelperImpl(ResultSetProcessorRowPerGroupRollup processor, int levelCount) {
        int i;
        this.processor = processor;
        this.outputLimitGroupRepsPerLevel = new LinkedHashMap[levelCount];
        for (i = 0; i < levelCount; ++i) {
            this.outputLimitGroupRepsPerLevel[i] = new LinkedHashMap<Object, EventBean[]>();
        }
        if (processor.isSelectRStream()) {
            this.groupRepsOutputLastUnordRStream = new LinkedHashMap[levelCount];
            for (i = 0; i < levelCount; ++i) {
                this.groupRepsOutputLastUnordRStream[i] = new LinkedHashMap<Object, EventBean>();
            }
        } else {
            this.groupRepsOutputLastUnordRStream = null;
        }
    }

    @Override
    public void processView(EventBean[] newData, EventBean[] oldData, boolean isGenerateSynthetic) {
        Object groupKey;
        Object groupKeyComplete;
        EventBean[] eventsPerStream;
        this.generateRemoveStreamJustOnce(isGenerateSynthetic, false);
        Object[] groupKeysPerLevel = new Object[this.processor.getGroupByRollupDesc().getLevels().length];
        if (newData != null) {
            for (EventBean aNewData : newData) {
                eventsPerStream = new EventBean[]{aNewData};
                groupKeyComplete = this.processor.generateGroupKeySingle(eventsPerStream, true);
                for (AggregationGroupByRollupLevel level : this.processor.getGroupByRollupDesc().getLevels()) {
                    groupKeysPerLevel[level.getLevelNumber()] = groupKey = level.computeSubkey(groupKeyComplete);
                    if (this.outputLimitGroupRepsPerLevel[level.getLevelNumber()].put(groupKey, eventsPerStream) != null || !this.processor.isSelectRStream()) continue;
                    this.processor.generateOutputBatchedMapUnsorted(false, groupKey, level, eventsPerStream, true, isGenerateSynthetic, this.groupRepsOutputLastUnordRStream[level.getLevelNumber()]);
                }
                this.processor.getAggregationService().applyEnter(eventsPerStream, groupKeysPerLevel, this.processor.getExprEvaluatorContext());
            }
        }
        if (oldData != null) {
            for (EventBean anOldData : oldData) {
                eventsPerStream = new EventBean[]{anOldData};
                groupKeyComplete = this.processor.generateGroupKeySingle(eventsPerStream, false);
                for (AggregationGroupByRollupLevel level : this.processor.getGroupByRollupDesc().getLevels()) {
                    groupKeysPerLevel[level.getLevelNumber()] = groupKey = level.computeSubkey(groupKeyComplete);
                    if (this.outputLimitGroupRepsPerLevel[level.getLevelNumber()].put(groupKey, eventsPerStream) != null || !this.processor.isSelectRStream()) continue;
                    this.processor.generateOutputBatchedMapUnsorted(true, groupKey, level, eventsPerStream, false, isGenerateSynthetic, this.groupRepsOutputLastUnordRStream[level.getLevelNumber()]);
                }
                this.processor.getAggregationService().applyLeave(eventsPerStream, groupKeysPerLevel, this.processor.getExprEvaluatorContext());
            }
        }
    }

    @Override
    public void processJoin(Set<MultiKeyArrayOfKeys<EventBean>> newEvents, Set<MultiKeyArrayOfKeys<EventBean>> oldEvents, boolean isGenerateSynthetic) {
        Object groupKey;
        Object groupKeyComplete;
        this.generateRemoveStreamJustOnce(isGenerateSynthetic, true);
        Object[] groupKeysPerLevel = new Object[this.processor.getGroupByRollupDesc().getLevels().length];
        if (newEvents != null) {
            for (MultiKeyArrayOfKeys<EventBean> newEvent : newEvents) {
                EventBean[] aNewData = newEvent.getArray();
                groupKeyComplete = this.processor.generateGroupKeySingle(aNewData, true);
                for (AggregationGroupByRollupLevel level : this.processor.getGroupByRollupDesc().getLevels()) {
                    groupKeysPerLevel[level.getLevelNumber()] = groupKey = level.computeSubkey(groupKeyComplete);
                    if (this.outputLimitGroupRepsPerLevel[level.getLevelNumber()].put(groupKey, aNewData) != null || !this.processor.isSelectRStream()) continue;
                    this.processor.generateOutputBatchedMapUnsorted(false, groupKey, level, aNewData, true, isGenerateSynthetic, this.groupRepsOutputLastUnordRStream[level.getLevelNumber()]);
                }
                this.processor.getAggregationService().applyEnter(aNewData, groupKeysPerLevel, this.processor.getExprEvaluatorContext());
            }
        }
        if (oldEvents != null) {
            for (MultiKeyArrayOfKeys<EventBean> oldEvent : oldEvents) {
                EventBean[] aOldData = oldEvent.getArray();
                groupKeyComplete = this.processor.generateGroupKeySingle(aOldData, false);
                for (AggregationGroupByRollupLevel level : this.processor.getGroupByRollupDesc().getLevels()) {
                    groupKeysPerLevel[level.getLevelNumber()] = groupKey = level.computeSubkey(groupKeyComplete);
                    if (this.outputLimitGroupRepsPerLevel[level.getLevelNumber()].put(groupKey, aOldData) != null || !this.processor.isSelectRStream()) continue;
                    this.processor.generateOutputBatchedMapUnsorted(true, groupKey, level, aOldData, false, isGenerateSynthetic, this.groupRepsOutputLastUnordRStream[level.getLevelNumber()]);
                }
                this.processor.getAggregationService().applyLeave(aOldData, groupKeysPerLevel, this.processor.getExprEvaluatorContext());
            }
        }
    }

    @Override
    public UniformPair<EventBean[]> outputView(boolean isSynthesize) {
        this.generateRemoveStreamJustOnce(isSynthesize, false);
        return this.output(isSynthesize, false);
    }

    @Override
    public UniformPair<EventBean[]> outputJoin(boolean isSynthesize) {
        this.generateRemoveStreamJustOnce(isSynthesize, true);
        return this.output(isSynthesize, true);
    }

    @Override
    public void destroy() {
    }

    private UniformPair<EventBean[]> output(boolean isSynthesize, boolean isJoin) {
        ArrayList<EventBean> newEvents = new ArrayList<EventBean>(4);
        for (AggregationGroupByRollupLevel level : this.processor.getGroupByRollupDesc().getLevels()) {
            Map<Object, EventBean[]> groupGenerators = this.outputLimitGroupRepsPerLevel[level.getLevelNumber()];
            for (Map.Entry<Object, EventBean[]> entry : groupGenerators.entrySet()) {
                this.processor.generateOutputBatched(entry.getKey(), level, entry.getValue(), true, isSynthesize, newEvents, null);
            }
        }
        EventBean[] newEventsArr = newEvents.isEmpty() ? null : newEvents.toArray(new EventBean[newEvents.size()]);
        EventBean[] oldEventsArr = null;
        if (this.processor.isSelectRStream()) {
            ArrayList<EventBean> oldEventList = new ArrayList<EventBean>(4);
            for (Map<Object, EventBean> map : this.groupRepsOutputLastUnordRStream) {
                oldEventList.addAll(map.values());
                map.clear();
            }
            if (!oldEventList.isEmpty()) {
                oldEventsArr = oldEventList.toArray(new EventBean[oldEventList.size()]);
            }
        }
        this.first = true;
        if (newEventsArr == null && oldEventsArr == null) {
            return null;
        }
        return new UniformPair<Object>(newEventsArr, oldEventsArr);
    }

    private void generateRemoveStreamJustOnce(boolean isSynthesize, boolean join) {
        if (this.first && this.processor.isSelectRStream()) {
            for (AggregationGroupByRollupLevel level : this.processor.getGroupByRollupDesc().getLevels()) {
                for (Map.Entry<Object, EventBean[]> groupRep : this.outputLimitGroupRepsPerLevel[level.getLevelNumber()].entrySet()) {
                    Object groupKeyPartial = this.processor.generateGroupKeySingle(groupRep.getValue(), false);
                    Object groupKey = level.computeSubkey(groupKeyPartial);
                    this.processor.generateOutputBatchedMapUnsorted(join, groupKey, level, groupRep.getValue(), false, isSynthesize, this.groupRepsOutputLastUnordRStream[level.getLevelNumber()]);
                }
            }
        }
        this.first = false;
    }
}

