/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.resultset.rowpergrouprollup;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.util.StateMgmtSetting;
import com.espertech.esper.common.internal.epl.agg.core.AggregationGroupByRollupDesc;
import com.espertech.esper.common.internal.epl.agg.core.AggregationGroupByRollupLevel;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.output.polled.OutputConditionPolledFactory;
import com.espertech.esper.common.internal.epl.resultset.core.ResultSetProcessorHelperFactory;
import com.espertech.esper.common.internal.epl.resultset.grouped.ResultSetProcessorGroupedOutputFirstHelper;
import com.espertech.esper.common.internal.epl.resultset.order.OrderByProcessor;
import com.espertech.esper.common.internal.epl.resultset.rowpergrouprollup.EventArrayAndSortKeyArray;
import com.espertech.esper.common.internal.epl.resultset.rowpergrouprollup.EventsAndSortKeysPair;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ResultSetProcessorRowPerGroupRollupUtil {
    static final String METHOD_MAKEGROUPREPSPERLEVELBUF = "makeGroupRepsPerLevelBuf";
    static final String METHOD_MAKERSTREAMSORTEDARRAYBUF = "makeRStreamSortedArrayBuf";
    static final String METHOD_GETOLDEVENTSSORTKEYS = "getOldEventsSortKeys";

    public static EventsAndSortKeysPair getOldEventsSortKeys(int oldEventCount, EventArrayAndSortKeyArray rstreamEventSortArrayBuf, OrderByProcessor orderByProcessor, AggregationGroupByRollupDesc rollupDesc) {
        EventBean[] oldEventsArr = new EventBean[oldEventCount];
        Object[] oldEventsSortKeys = null;
        if (orderByProcessor != null) {
            oldEventsSortKeys = new Object[oldEventCount];
        }
        int countEvents = 0;
        int countSortKeys = 0;
        for (AggregationGroupByRollupLevel level : rollupDesc.getLevels()) {
            List<EventBean> events = rstreamEventSortArrayBuf.getEventsPerLevel()[level.getLevelNumber()];
            for (EventBean event : events) {
                oldEventsArr[countEvents++] = event;
            }
            if (orderByProcessor == null) continue;
            List<Object> sortKeys = rstreamEventSortArrayBuf.getSortKeyPerLevel()[level.getLevelNumber()];
            for (Object sortKey : sortKeys) {
                oldEventsSortKeys[countSortKeys++] = sortKey;
            }
        }
        return new EventsAndSortKeysPair(oldEventsArr, oldEventsSortKeys);
    }

    public static EventArrayAndSortKeyArray makeRStreamSortedArrayBuf(int length, boolean isSorting) {
        List[] eventsPerLevel = new List[length];
        List[] sortKeyPerLevel = null;
        if (isSorting) {
            sortKeyPerLevel = new List[length];
        }
        for (int i = 0; i < length; ++i) {
            eventsPerLevel[i] = new ArrayList();
            if (!isSorting) continue;
            sortKeyPerLevel[i] = new ArrayList();
        }
        return new EventArrayAndSortKeyArray(eventsPerLevel, sortKeyPerLevel);
    }

    public static Map<Object, EventBean[]>[] makeGroupRepsPerLevelBuf(int levelCount) {
        LinkedHashMap[] groupRepsPerLevelBuf = new LinkedHashMap[levelCount];
        for (int i = 0; i < levelCount; ++i) {
            groupRepsPerLevelBuf[i] = new LinkedHashMap();
        }
        return groupRepsPerLevelBuf;
    }

    public static ResultSetProcessorGroupedOutputFirstHelper[] initializeOutputFirstHelpers(ResultSetProcessorHelperFactory resultSetProcessorHelperFactory, ExprEvaluatorContext exprEvaluatorContext, EPType[] groupKeyTypes, AggregationGroupByRollupDesc groupByRollupDesc, OutputConditionPolledFactory outputConditionPolledFactory, StateMgmtSetting outputLimitHelperSettings) {
        ResultSetProcessorGroupedOutputFirstHelper[] outputFirstHelpers = new ResultSetProcessorGroupedOutputFirstHelper[groupByRollupDesc.getLevels().length];
        for (int i = 0; i < groupByRollupDesc.getLevels().length; ++i) {
            outputFirstHelpers[i] = resultSetProcessorHelperFactory.makeRSGroupedOutputFirst(exprEvaluatorContext, groupKeyTypes, outputConditionPolledFactory, groupByRollupDesc, i, null, outputLimitHelperSettings);
        }
        return outputFirstHelpers;
    }
}

