/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.resultset.select.eval;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionField;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityPrint;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.resultset.select.core.SelectExprForgeContext;
import com.espertech.esper.common.internal.epl.resultset.select.core.SelectExprProcessorCodegenSymbol;
import com.espertech.esper.common.internal.epl.resultset.select.core.SelectExprProcessorForge;
import com.espertech.esper.common.internal.event.arr.ObjectArrayEventType;
import com.espertech.esper.common.internal.event.core.BaseNestableEventUtil;
import com.espertech.esper.common.internal.event.core.EventBeanManufactureException;
import com.espertech.esper.common.internal.event.core.EventBeanManufacturer;
import com.espertech.esper.common.internal.event.core.EventBeanManufacturerForge;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import com.espertech.esper.common.internal.event.core.ObjectArrayBackedEventBean;
import com.espertech.esper.common.internal.event.core.WriteablePropertyDescriptor;
import com.espertech.esper.common.internal.settings.ClasspathImportServiceCompileTime;
import com.espertech.esper.common.internal.util.TypeWidenerException;
import com.espertech.esper.common.internal.util.TypeWidenerFactory;
import com.espertech.esper.common.internal.util.TypeWidenerSPI;
import java.util.ArrayList;
import java.util.Set;

public class SelectEvalStreamWUndRecastObjectArrayFactory {
    public static SelectExprProcessorForge make(EventType[] eventTypes, SelectExprForgeContext selectExprForgeContext, int streamNumber, EventType targetType, ExprNode[] exprNodes, ClasspathImportServiceCompileTime classpathImportService, String statementName) throws ExprValidationException {
        EventBeanManufacturerForge manufacturer;
        ObjectArrayEventType oaResultType = (ObjectArrayEventType)targetType;
        ObjectArrayEventType oaStreamType = (ObjectArrayEventType)eventTypes[streamNumber];
        if (oaResultType.isDeepEqualsConsiderOrder(oaStreamType) && selectExprForgeContext.getExprForges().length == 0) {
            return new OAInsertProcessorSimpleRepackage(selectExprForgeContext, streamNumber, targetType);
        }
        Set<WriteablePropertyDescriptor> writables = EventTypeUtility.getWriteableProperties(oaResultType, true, false);
        ArrayList<Item> items = new ArrayList<Item>();
        ArrayList<WriteablePropertyDescriptor> written = new ArrayList<WriteablePropertyDescriptor>();
        for (WriteablePropertyDescriptor writeable : writables) {
            Object setTwoType;
            boolean setOneTypeFound;
            String propertyName = writeable.getPropertyName();
            Integer indexSource = oaStreamType.getPropertiesIndexes().get(propertyName);
            Integer indexTarget = oaResultType.getPropertiesIndexes().get(propertyName);
            if (indexSource == null) continue;
            Object setOneType = oaResultType.getTypes().get(propertyName);
            ExprValidationException message = BaseNestableEventUtil.comparePropType(propertyName, setOneType, setOneTypeFound = oaResultType.getTypes().containsKey(propertyName), setTwoType = oaStreamType.getTypes().get(propertyName), oaResultType.getName());
            if (message != null) {
                throw new ExprValidationException(message.getMessage(), message);
            }
            items.add(new Item(indexTarget, indexSource, null, null));
            written.add(writeable);
        }
        int count = written.size();
        for (int i = 0; i < selectExprForgeContext.getExprForges().length; ++i) {
            TypeWidenerSPI widener;
            String columnName = selectExprForgeContext.getColumnNames()[i];
            ExprForge forge = selectExprForgeContext.getExprForges()[i];
            ExprNode exprNode = exprNodes[i];
            WriteablePropertyDescriptor writable = SelectEvalStreamWUndRecastObjectArrayFactory.findWritable(columnName, writables);
            if (writable == null) {
                throw new ExprValidationException("Failed to find column '" + columnName + "' in target type '" + oaResultType.getName() + "'");
            }
            try {
                widener = TypeWidenerFactory.getCheckPropertyAssignType(ExprNodeUtilityPrint.toExpressionStringMinPrecedenceSafe(exprNode), exprNode.getForge().getEvaluationType(), writable.getType(), columnName, false, null, statementName);
            }
            catch (TypeWidenerException ex) {
                throw new ExprValidationException(ex.getMessage(), ex);
            }
            items.add(new Item(count, -1, forge, widener));
            written.add(writable);
            ++count;
        }
        Item[] itemsArr = items.toArray(new Item[items.size()]);
        try {
            manufacturer = EventTypeUtility.getManufacturer(oaResultType, written.toArray(new WriteablePropertyDescriptor[written.size()]), classpathImportService, true, selectExprForgeContext.getEventTypeAvroHandler());
        }
        catch (EventBeanManufactureException e) {
            throw new ExprValidationException("Failed to write to type: " + e.getMessage(), e);
        }
        return new OAInsertProcessorAllocate(streamNumber, itemsArr, manufacturer, targetType);
    }

    private static WriteablePropertyDescriptor findWritable(String columnName, Set<WriteablePropertyDescriptor> writables) {
        for (WriteablePropertyDescriptor writable : writables) {
            if (!writable.getPropertyName().equals(columnName)) continue;
            return writable;
        }
        return null;
    }

    private static class Item {
        private final int toIndex;
        private final int optionalFromIndex;
        private final ExprForge forge;
        private final TypeWidenerSPI optionalWidener;
        private ExprEvaluator evaluatorAssigned;

        private Item(int toIndex, int optionalFromIndex, ExprForge forge, TypeWidenerSPI optionalWidener) {
            this.toIndex = toIndex;
            this.optionalFromIndex = optionalFromIndex;
            this.forge = forge;
            this.optionalWidener = optionalWidener;
        }

        public int getToIndex() {
            return this.toIndex;
        }

        public int getOptionalFromIndex() {
            return this.optionalFromIndex;
        }

        public ExprForge getForge() {
            return this.forge;
        }

        public TypeWidenerSPI getOptionalWidener() {
            return this.optionalWidener;
        }

        public ExprEvaluator getEvaluatorAssigned() {
            return this.evaluatorAssigned;
        }

        public void setEvaluatorAssigned(ExprEvaluator evaluatorAssigned) {
            this.evaluatorAssigned = evaluatorAssigned;
        }
    }

    private static class OAInsertProcessorAllocate
    implements SelectExprProcessorForge {
        private final int underlyingStreamNumber;
        private final Item[] items;
        private final EventBeanManufacturerForge manufacturer;
        private final EventType resultType;

        private OAInsertProcessorAllocate(int underlyingStreamNumber, Item[] items, EventBeanManufacturerForge manufacturer, EventType resultType) {
            this.underlyingStreamNumber = underlyingStreamNumber;
            this.items = items;
            this.manufacturer = manufacturer;
            this.resultType = resultType;
        }

        @Override
        public EventType getResultEventType() {
            return this.resultType;
        }

        @Override
        public CodegenMethod processCodegen(CodegenExpression resultEventType, CodegenExpression eventBeanFactory, CodegenMethodScope codegenMethodScope, SelectExprProcessorCodegenSymbol selectSymbol, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            CodegenExpressionField manufacturerField = codegenClassScope.addFieldUnshared(true, EventBeanManufacturer.EPTYPE, this.manufacturer.make(codegenMethodScope, codegenClassScope));
            CodegenMethod methodNode = codegenMethodScope.makeChild(EventBean.EPTYPE, this.getClass(), (CodegenScope)codegenClassScope);
            CodegenExpressionRef refEPS = exprSymbol.getAddEPS(methodNode);
            CodegenBlock block = methodNode.getBlock().declareVar(ObjectArrayBackedEventBean.EPTYPE, "theEvent", CodegenExpressionBuilder.cast(ObjectArrayBackedEventBean.EPTYPE, CodegenExpressionBuilder.arrayAtIndex(refEPS, CodegenExpressionBuilder.constant(this.underlyingStreamNumber)))).declareVar(EPTypePremade.OBJECTARRAY.getEPType(), "props", CodegenExpressionBuilder.newArrayByLength(EPTypePremade.OBJECT.getEPType(), CodegenExpressionBuilder.constant(this.items.length)));
            for (Item item : this.items) {
                CodegenExpression value;
                if (item.getOptionalFromIndex() != -1) {
                    block.assignArrayElement("props", CodegenExpressionBuilder.constant(item.getToIndex()), CodegenExpressionBuilder.arrayAtIndex(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("theEvent"), "getProperties", new CodegenExpression[0]), CodegenExpressionBuilder.constant(item.getOptionalFromIndex())));
                    continue;
                }
                if (item.getOptionalWidener() != null) {
                    value = item.forge.evaluateCodegen((EPTypeClass)item.forge.getEvaluationType(), methodNode, exprSymbol, codegenClassScope);
                    value = item.getOptionalWidener().widenCodegen(value, methodNode, codegenClassScope);
                } else {
                    value = item.forge.evaluateCodegen(EPTypePremade.OBJECT.getEPType(), methodNode, exprSymbol, codegenClassScope);
                }
                block.assignArrayElement("props", CodegenExpressionBuilder.constant(item.getToIndex()), value);
            }
            block.methodReturn(CodegenExpressionBuilder.exprDotMethod(manufacturerField, "make", CodegenExpressionBuilder.ref("props")));
            return methodNode;
        }
    }

    private static class OAInsertProcessorSimpleRepackage
    implements SelectExprProcessorForge {
        private final SelectExprForgeContext selectExprForgeContext;
        private final int underlyingStreamNumber;
        private final EventType resultType;

        private OAInsertProcessorSimpleRepackage(SelectExprForgeContext selectExprForgeContext, int underlyingStreamNumber, EventType resultType) {
            this.selectExprForgeContext = selectExprForgeContext;
            this.underlyingStreamNumber = underlyingStreamNumber;
            this.resultType = resultType;
        }

        @Override
        public EventType getResultEventType() {
            return this.resultType;
        }

        @Override
        public CodegenMethod processCodegen(CodegenExpression resultEventType, CodegenExpression eventBeanFactory, CodegenMethodScope codegenMethodScope, SelectExprProcessorCodegenSymbol selectSymbol, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            CodegenMethod methodNode = codegenMethodScope.makeChild(EventBean.EPTYPE, this.getClass(), (CodegenScope)codegenClassScope);
            CodegenExpressionRef refEPS = exprSymbol.getAddEPS(methodNode);
            CodegenExpression value = CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.cast(ObjectArrayBackedEventBean.EPTYPE, CodegenExpressionBuilder.arrayAtIndex(refEPS, CodegenExpressionBuilder.constant(this.underlyingStreamNumber))), "getProperties", new CodegenExpression[0]);
            methodNode.getBlock().methodReturn(CodegenExpressionBuilder.exprDotMethod(eventBeanFactory, "adapterForTypedObjectArray", value, resultEventType));
            return methodNode;
        }
    }
}

