/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.rowrecog.core;

import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.rowrecog.core.RowRecogNFAStrand;
import com.espertech.esper.common.internal.epl.rowrecog.core.RowRecogNFAStrandResult;
import com.espertech.esper.common.internal.epl.rowrecog.core.RowRecogNFATypeEnum;
import com.espertech.esper.common.internal.epl.rowrecog.core.RowRecogNFAViewService;
import com.espertech.esper.common.internal.epl.rowrecog.expr.RowRecogExprNode;
import com.espertech.esper.common.internal.epl.rowrecog.expr.RowRecogExprNodeAlteration;
import com.espertech.esper.common.internal.epl.rowrecog.expr.RowRecogExprNodeAtom;
import com.espertech.esper.common.internal.epl.rowrecog.expr.RowRecogExprNodeConcatenation;
import com.espertech.esper.common.internal.epl.rowrecog.expr.RowRecogExprNodeNested;
import com.espertech.esper.common.internal.epl.rowrecog.nfa.RowRecogNFAStateAnyOneForge;
import com.espertech.esper.common.internal.epl.rowrecog.nfa.RowRecogNFAStateEndForge;
import com.espertech.esper.common.internal.epl.rowrecog.nfa.RowRecogNFAStateEntry;
import com.espertech.esper.common.internal.epl.rowrecog.nfa.RowRecogNFAStateFilterForge;
import com.espertech.esper.common.internal.epl.rowrecog.nfa.RowRecogNFAStateForge;
import com.espertech.esper.common.internal.epl.rowrecog.nfa.RowRecogNFAStateForgeBase;
import com.espertech.esper.common.internal.epl.rowrecog.nfa.RowRecogNFAStateOneOptionalForge;
import com.espertech.esper.common.internal.epl.rowrecog.nfa.RowRecogNFAStateOneToManyForge;
import com.espertech.esper.common.internal.epl.rowrecog.nfa.RowRecogNFAStateZeroToManyForge;
import com.espertech.esper.common.internal.view.core.Viewable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class RowRecogHelper {
    protected static final Comparator<RowRecogNFAStateEntry> END_STATE_COMPARATOR = new Comparator<RowRecogNFAStateEntry>(){

        @Override
        public int compare(RowRecogNFAStateEntry o1, RowRecogNFAStateEntry o2) {
            if (o1.getMatchEndEventSeqNo() > o2.getMatchEndEventSeqNo()) {
                return -1;
            }
            if (o1.getMatchEndEventSeqNo() < o2.getMatchEndEventSeqNo()) {
                return 1;
            }
            return 0;
        }
    };

    public static RowRecogNFAViewService recursiveFindRegexService(Viewable top) {
        if (top == null) {
            return null;
        }
        if (top instanceof RowRecogNFAViewService) {
            return (RowRecogNFAViewService)((Object)top);
        }
        return RowRecogHelper.recursiveFindRegexService(top.getChild());
    }

    public static void recursiveInspectVariables(RowRecogExprNode parent, boolean isMultiple, Set<String> variablesSingle, Set<String> variablesMultiple) {
        if (parent instanceof RowRecogExprNodeNested) {
            RowRecogExprNodeNested nested = (RowRecogExprNodeNested)parent;
            for (RowRecogExprNode child : parent.getChildNodes()) {
                RowRecogHelper.recursiveInspectVariables(child, nested.getType().isMultipleMatches() || isMultiple, variablesSingle, variablesMultiple);
            }
        } else if (parent instanceof RowRecogExprNodeAlteration) {
            for (RowRecogExprNode childAlteration : parent.getChildNodes()) {
                LinkedHashSet<String> singles = new LinkedHashSet<String>();
                LinkedHashSet<String> multiples = new LinkedHashSet<String>();
                RowRecogHelper.recursiveInspectVariables(childAlteration, isMultiple, singles, multiples);
                variablesMultiple.addAll(multiples);
                variablesSingle.addAll(singles);
            }
            variablesSingle.removeAll(variablesMultiple);
        } else if (parent instanceof RowRecogExprNodeAtom) {
            RowRecogExprNodeAtom atom = (RowRecogExprNodeAtom)parent;
            String name = atom.getTag();
            if (variablesMultiple.contains(name)) {
                return;
            }
            if (variablesSingle.contains(name)) {
                variablesSingle.remove(name);
                variablesMultiple.add(name);
                return;
            }
            if (atom.getType().isMultipleMatches()) {
                variablesMultiple.add(name);
                return;
            }
            if (isMultiple) {
                variablesMultiple.add(name);
            } else {
                variablesSingle.add(name);
            }
        } else {
            for (RowRecogExprNode child : parent.getChildNodes()) {
                RowRecogHelper.recursiveInspectVariables(child, isMultiple, variablesSingle, variablesMultiple);
            }
        }
    }

    protected static RowRecogNFAStrandResult buildStartStates(RowRecogExprNode parent, Map<String, ExprNode> variableDefinitions, Map<String, Pair<Integer, Boolean>> variableStreams, boolean[] exprRequiresMultimatchState) {
        Stack<Integer> nodeNumStack = new Stack<Integer>();
        RowRecogNFAStrand strand = RowRecogHelper.recursiveBuildStatesInternal(parent, variableDefinitions, variableStreams, nodeNumStack, exprRequiresMultimatchState);
        RowRecogNFAStateEndForge end = new RowRecogNFAStateEndForge();
        end.setNodeNumFlat(-1);
        for (RowRecogNFAStateForgeBase endStates : strand.getEndStates()) {
            endStates.addState(end);
        }
        int nodeNumberFlat = 0;
        for (RowRecogNFAStateForgeBase theBase : strand.getAllStates()) {
            theBase.setNodeNumFlat(nodeNumberFlat++);
        }
        return new RowRecogNFAStrandResult(new ArrayList<RowRecogNFAStateForge>(strand.getStartStates()), strand.getAllStates());
    }

    private static RowRecogNFAStrand recursiveBuildStatesInternal(RowRecogExprNode node, Map<String, ExprNode> variableDefinitions, Map<String, Pair<Integer, Boolean>> variableStreams, Stack<Integer> nodeNumStack, boolean[] exprRequiresMultimatchState) {
        if (node instanceof RowRecogExprNodeAlteration) {
            int nodeNum = 0;
            ArrayList<RowRecogNFAStateForgeBase> cumulativeStartStates = new ArrayList<RowRecogNFAStateForgeBase>();
            ArrayList<RowRecogNFAStateForgeBase> cumulativeStates = new ArrayList<RowRecogNFAStateForgeBase>();
            ArrayList<RowRecogNFAStateForgeBase> cumulativeEndStates = new ArrayList<RowRecogNFAStateForgeBase>();
            boolean isPassthrough = false;
            for (RowRecogExprNode child : node.getChildNodes()) {
                nodeNumStack.push(nodeNum);
                RowRecogNFAStrand strand = RowRecogHelper.recursiveBuildStatesInternal(child, variableDefinitions, variableStreams, nodeNumStack, exprRequiresMultimatchState);
                nodeNumStack.pop();
                cumulativeStartStates.addAll(strand.getStartStates());
                cumulativeStates.addAll(strand.getAllStates());
                cumulativeEndStates.addAll(strand.getEndStates());
                if (strand.isPassthrough()) {
                    isPassthrough = true;
                }
                ++nodeNum;
            }
            return new RowRecogNFAStrand(cumulativeStartStates, cumulativeEndStates, cumulativeStates, isPassthrough);
        }
        if (node instanceof RowRecogExprNodeConcatenation) {
            int i;
            int nodeNum = 0;
            boolean isPassthrough = true;
            ArrayList<RowRecogNFAStateForgeBase> cumulativeStates = new ArrayList<RowRecogNFAStateForgeBase>();
            RowRecogNFAStrand[] strands = new RowRecogNFAStrand[node.getChildNodes().size()];
            for (RowRecogExprNode child : node.getChildNodes()) {
                nodeNumStack.push(nodeNum);
                strands[nodeNum] = RowRecogHelper.recursiveBuildStatesInternal(child, variableDefinitions, variableStreams, nodeNumStack, exprRequiresMultimatchState);
                nodeNumStack.pop();
                cumulativeStates.addAll(strands[nodeNum].getAllStates());
                if (!strands[nodeNum].isPassthrough()) {
                    isPassthrough = false;
                }
                ++nodeNum;
            }
            ArrayList<RowRecogNFAStateForgeBase> startStates = new ArrayList<RowRecogNFAStateForgeBase>();
            for (int i2 = 0; i2 < strands.length; ++i2) {
                startStates.addAll(strands[i2].getStartStates());
                if (!strands[i2].isPassthrough()) break;
            }
            ArrayList<RowRecogNFAStateForgeBase> endStates = new ArrayList<RowRecogNFAStateForgeBase>();
            for (i = strands.length - 1; i >= 0; --i) {
                endStates.addAll(strands[i].getEndStates());
                if (!strands[i].isPassthrough()) break;
            }
            block4: for (i = strands.length - 1; i >= 1; --i) {
                RowRecogNFAStrand current = strands[i];
                for (int j = i - 1; j >= 0; --j) {
                    RowRecogNFAStrand prior = strands[j];
                    for (RowRecogNFAStateForgeBase endState : prior.getEndStates()) {
                        for (RowRecogNFAStateForgeBase startState : current.getStartStates()) {
                            endState.addState(startState);
                        }
                    }
                    if (!prior.isPassthrough()) continue block4;
                }
            }
            return new RowRecogNFAStrand(startStates, endStates, cumulativeStates, isPassthrough);
        }
        if (node instanceof RowRecogExprNodeNested) {
            boolean isPassthrough;
            RowRecogExprNodeNested nested = (RowRecogExprNodeNested)node;
            nodeNumStack.push(0);
            RowRecogNFAStrand strand = RowRecogHelper.recursiveBuildStatesInternal(node.getChildNodes().get(0), variableDefinitions, variableStreams, nodeNumStack, exprRequiresMultimatchState);
            nodeNumStack.pop();
            boolean bl = isPassthrough = strand.isPassthrough() || nested.getType().isOptional();
            if (nested.getType().isMultipleMatches()) {
                for (RowRecogNFAStateForgeBase endstate : strand.getEndStates()) {
                    for (RowRecogNFAStateForgeBase startstate : strand.getStartStates()) {
                        if (endstate.getNextStates().contains(startstate)) continue;
                        endstate.getNextStates().add(startstate);
                    }
                }
            }
            return new RowRecogNFAStrand(strand.getStartStates(), strand.getEndStates(), strand.getAllStates(), isPassthrough);
        }
        RowRecogExprNodeAtom atom = (RowRecogExprNodeAtom)node;
        int streamNum = variableStreams.get(atom.getTag()).getFirst();
        boolean multiple = variableStreams.get(atom.getTag()).getSecond();
        ExprNode expression = variableDefinitions.get(atom.getTag());
        boolean exprRequiresMultimatch = exprRequiresMultimatchState[streamNum];
        RowRecogNFAStateForgeBase nextState = atom.getType() == RowRecogNFATypeEnum.ZERO_TO_MANY || atom.getType() == RowRecogNFATypeEnum.ZERO_TO_MANY_RELUCTANT ? new RowRecogNFAStateZeroToManyForge(RowRecogHelper.toString(nodeNumStack), atom.getTag(), streamNum, multiple, atom.getType().isGreedy(), exprRequiresMultimatch, expression) : (atom.getType() == RowRecogNFATypeEnum.ONE_TO_MANY || atom.getType() == RowRecogNFATypeEnum.ONE_TO_MANY_RELUCTANT ? new RowRecogNFAStateOneToManyForge(RowRecogHelper.toString(nodeNumStack), atom.getTag(), streamNum, multiple, atom.getType().isGreedy(), exprRequiresMultimatch, expression) : (atom.getType() == RowRecogNFATypeEnum.ONE_OPTIONAL || atom.getType() == RowRecogNFATypeEnum.ONE_OPTIONAL_RELUCTANT ? new RowRecogNFAStateOneOptionalForge(RowRecogHelper.toString(nodeNumStack), atom.getTag(), streamNum, multiple, atom.getType().isGreedy(), exprRequiresMultimatch, expression) : (expression == null ? new RowRecogNFAStateAnyOneForge(RowRecogHelper.toString(nodeNumStack), atom.getTag(), streamNum, multiple) : new RowRecogNFAStateFilterForge(RowRecogHelper.toString(nodeNumStack), atom.getTag(), streamNum, multiple, exprRequiresMultimatch, expression))));
        return new RowRecogNFAStrand(Collections.singletonList(nextState), Collections.singletonList(nextState), Collections.singletonList(nextState), atom.getType().isOptional());
    }

    private static String toString(Stack<Integer> nodeNumStack) {
        StringBuilder builder = new StringBuilder();
        String delimiter = "";
        for (Integer atom : nodeNumStack) {
            builder.append(delimiter);
            builder.append(Integer.toString(atom));
            delimiter = ".";
        }
        return builder.toString();
    }

    public static Map<String, Set<String>> determineVisibility(RowRecogExprNode pattern) {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        ArrayDeque<RowRecogExprNode> path = new ArrayDeque<RowRecogExprNode>();
        RowRecogHelper.recursiveFindPatternAtoms(pattern, path, map);
        return map;
    }

    private static void recursiveFindPatternAtoms(RowRecogExprNode parent, ArrayDeque<RowRecogExprNode> path, Map<String, Set<String>> map) {
        path.add(parent);
        for (RowRecogExprNode child : parent.getChildNodes()) {
            if (child instanceof RowRecogExprNodeAtom) {
                RowRecogHelper.handleAtom((RowRecogExprNodeAtom)child, path, map);
                continue;
            }
            RowRecogHelper.recursiveFindPatternAtoms(child, path, map);
        }
        path.removeLast();
    }

    private static void handleAtom(RowRecogExprNodeAtom atom, ArrayDeque<RowRecogExprNode> path, Map<String, Set<String>> map) {
        RowRecogExprNode[] patharr = path.toArray(new RowRecogExprNode[path.size()]);
        HashSet<String> identifiers = null;
        for (int i = 0; i < patharr.length; ++i) {
            RowRecogExprNode parent = patharr[i];
            if (!(parent instanceof RowRecogExprNodeConcatenation)) continue;
            RowRecogExprNodeConcatenation concat = (RowRecogExprNodeConcatenation)parent;
            int indexWithinConcat = i == patharr.length - 1 ? parent.getChildNodes().indexOf(atom) : parent.getChildNodes().indexOf(patharr[i + 1]);
            if (identifiers == null && indexWithinConcat > 0) {
                identifiers = new HashSet<String>();
            }
            for (int j = 0; j < indexWithinConcat; ++j) {
                RowRecogExprNode concatChildNode = concat.getChildNodes().get(j);
                RowRecogHelper.recursiveCollectAtomsWExclude(concatChildNode, identifiers, atom.getTag());
            }
        }
        if (identifiers == null) {
            return;
        }
        Set<String> existingVisibility = map.get(atom.getTag());
        if (existingVisibility == null) {
            map.put(atom.getTag(), identifiers);
        } else {
            existingVisibility.addAll(identifiers);
        }
    }

    private static void recursiveCollectAtomsWExclude(RowRecogExprNode node, Set<String> identifiers, String excludedTag) {
        RowRecogExprNodeAtom atom;
        if (node instanceof RowRecogExprNodeAtom && !excludedTag.equals((atom = (RowRecogExprNodeAtom)node).getTag())) {
            identifiers.add(atom.getTag());
        }
        for (RowRecogExprNode child : node.getChildNodes()) {
            RowRecogHelper.recursiveCollectAtomsWExclude(child, identifiers, excludedTag);
        }
    }
}

