/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.rowrecog.core;

import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.EPStatementHandleCallbackSchedule;
import com.espertech.esper.common.internal.epl.rowrecog.core.RowRecogNFAViewScheduleCallback;
import com.espertech.esper.common.internal.epl.rowrecog.core.RowRecogNFAViewScheduler;
import com.espertech.esper.common.internal.schedule.ScheduleHandleCallback;
import com.espertech.esper.common.internal.schedule.ScheduleObjectType;

public class RowRecogNFAViewSchedulerImpl
implements RowRecogNFAViewScheduler {
    public static final String NAME_AUDITPROVIDER_SCHEDULE = "interval";
    private AgentInstanceContext agentInstanceContext;
    private long scheduleSlot;
    private EPStatementHandleCallbackSchedule handle;

    @Override
    public void setScheduleCallback(final AgentInstanceContext agentInstanceContext, final RowRecogNFAViewScheduleCallback scheduleCallback) {
        this.agentInstanceContext = agentInstanceContext;
        this.scheduleSlot = agentInstanceContext.getStatementContext().getScheduleBucket().allocateSlot();
        ScheduleHandleCallback callback = new ScheduleHandleCallback(){

            @Override
            public void scheduledTrigger() {
                agentInstanceContext.getAuditProvider().scheduleFire(agentInstanceContext, ScheduleObjectType.matchrecognize, RowRecogNFAViewSchedulerImpl.NAME_AUDITPROVIDER_SCHEDULE);
                agentInstanceContext.getInstrumentationProvider().qRegExScheduledEval();
                scheduleCallback.triggered();
                agentInstanceContext.getInstrumentationProvider().aRegExScheduledEval();
            }
        };
        this.handle = new EPStatementHandleCallbackSchedule(agentInstanceContext.getEpStatementAgentInstanceHandle(), callback);
    }

    @Override
    public void addSchedule(long timeDelta) {
        this.agentInstanceContext.getAuditProvider().scheduleAdd(timeDelta, this.agentInstanceContext, this.handle, ScheduleObjectType.matchrecognize, NAME_AUDITPROVIDER_SCHEDULE);
        this.agentInstanceContext.getStatementContext().getSchedulingService().add(timeDelta, this.handle, this.scheduleSlot);
    }

    @Override
    public void changeSchedule(long timeDelta) {
        this.agentInstanceContext.getAuditProvider().scheduleRemove(this.agentInstanceContext, this.handle, ScheduleObjectType.matchrecognize, NAME_AUDITPROVIDER_SCHEDULE);
        this.agentInstanceContext.getStatementContext().getSchedulingService().remove(this.handle, this.scheduleSlot);
        this.agentInstanceContext.getAuditProvider().scheduleAdd(timeDelta, this.agentInstanceContext, this.handle, ScheduleObjectType.matchrecognize, NAME_AUDITPROVIDER_SCHEDULE);
        this.agentInstanceContext.getStatementContext().getSchedulingService().add(timeDelta, this.handle, this.scheduleSlot);
    }

    @Override
    public void removeSchedule() {
        this.agentInstanceContext.getAuditProvider().scheduleRemove(this.agentInstanceContext, this.handle, ScheduleObjectType.matchrecognize, NAME_AUDITPROVIDER_SCHEDULE);
        this.agentInstanceContext.getStatementContext().getSchedulingService().remove(this.handle, this.scheduleSlot);
    }
}

