/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.rowrecog.state;

import com.espertech.esper.common.internal.epl.rowrecog.core.RowRecogPartitionTerminationStateComparator;
import com.espertech.esper.common.internal.epl.rowrecog.nfa.RowRecogNFAStateEntry;
import com.espertech.esper.common.internal.epl.rowrecog.state.RowRecogPartitionStateRepoScheduleState;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;

public class RowRecogPartitionStateRepoScheduleStateImpl
implements RowRecogPartitionStateRepoScheduleState {
    private final RowRecogPartitionTerminationStateComparator terminationStateCompare;
    private final TreeMap<Long, Object> schedule = new TreeMap();

    public RowRecogPartitionStateRepoScheduleStateImpl(RowRecogPartitionTerminationStateComparator terminationStateCompare) {
        this.terminationStateCompare = terminationStateCompare;
    }

    @Override
    public boolean isEmpty() {
        return this.schedule.isEmpty();
    }

    @Override
    public boolean putOrAdd(long matchBeginTime, RowRecogNFAStateEntry state) {
        Object value = this.schedule.get(matchBeginTime);
        if (value == null) {
            this.schedule.put(matchBeginTime, state);
            return true;
        }
        if (value instanceof RowRecogNFAStateEntry) {
            RowRecogNFAStateEntry valueEntry = (RowRecogNFAStateEntry)value;
            ArrayList<RowRecogNFAStateEntry> list = new ArrayList<RowRecogNFAStateEntry>();
            list.add(valueEntry);
            list.add(state);
            this.schedule.put(matchBeginTime, list);
        } else {
            List list = (List)value;
            list.add(state);
        }
        return false;
    }

    public Object get(long matchBeginTime) {
        return this.schedule.get(matchBeginTime);
    }

    @Override
    public long firstKey() {
        return this.schedule.firstKey();
    }

    @Override
    public void removeAddRemoved(long matchBeginTime, List<RowRecogNFAStateEntry> foundStates) {
        Object found = this.schedule.remove(matchBeginTime);
        if (found == null) {
            return;
        }
        if (found instanceof RowRecogNFAStateEntry) {
            foundStates.add((RowRecogNFAStateEntry)found);
        } else {
            foundStates.addAll((List)found);
        }
    }

    @Override
    public boolean containsKey(long matchBeginTime) {
        return this.schedule.containsKey(matchBeginTime);
    }

    @Override
    public boolean findRemoveAddToList(long matchBeginTime, RowRecogNFAStateEntry state, List<RowRecogNFAStateEntry> foundStates) {
        Object entry = this.schedule.get(matchBeginTime);
        if (entry == null) {
            return false;
        }
        if (entry instanceof RowRecogNFAStateEntry) {
            RowRecogNFAStateEntry single = (RowRecogNFAStateEntry)entry;
            if (this.terminationStateCompare.compareTerminationStateToEndState(state, single)) {
                this.schedule.remove(matchBeginTime);
                foundStates.add(single);
                return true;
            }
            return false;
        }
        List entries = (List)entry;
        Iterator it = entries.iterator();
        boolean removed = false;
        while (it.hasNext()) {
            RowRecogNFAStateEntry endState = (RowRecogNFAStateEntry)it.next();
            if (!this.terminationStateCompare.compareTerminationStateToEndState(state, endState)) continue;
            it.remove();
            foundStates.add(endState);
            removed = true;
        }
        if (entries.isEmpty()) {
            this.schedule.remove(matchBeginTime);
        }
        return removed;
    }
}

