/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.rowrecog.state;

import com.espertech.esper.common.client.hook.condition.BaseCondition;
import com.espertech.esper.common.client.hook.condition.ConditionMatchRecognizeStatesMax;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.epl.rowrecog.state.RowRecogStatePoolStmtHandler;
import com.espertech.esper.common.internal.util.DeploymentIdNamePair;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public class RowRecogStatePoolRuntimeSvc {
    private volatile long maxPoolCountConfigured;
    private final boolean preventStart;
    private final AtomicLong poolCount;
    private final Set<StatementEntry> matchRecognizeContexts;

    public RowRecogStatePoolRuntimeSvc(long maxPoolCountConfigured, boolean preventStart) {
        this.maxPoolCountConfigured = maxPoolCountConfigured;
        this.preventStart = preventStart;
        this.poolCount = new AtomicLong();
        this.matchRecognizeContexts = Collections.synchronizedSet(new HashSet());
    }

    public void setMatchRecognizeMaxStates(Long maxStates) {
        this.maxPoolCountConfigured = maxStates == null ? -1L : maxStates;
    }

    public void addPatternContext(DeploymentIdNamePair statement, RowRecogStatePoolStmtHandler stmtCounts) {
        this.matchRecognizeContexts.add(new StatementEntry(statement, stmtCounts));
    }

    public void removeStatement(DeploymentIdNamePair statement) {
        HashSet<StatementEntry> removed = new HashSet<StatementEntry>();
        for (StatementEntry context : this.matchRecognizeContexts) {
            if (!context.getStatement().equals(statement)) continue;
            removed.add(context);
        }
        this.matchRecognizeContexts.removeAll(removed);
    }

    public boolean tryIncreaseCount(AgentInstanceContext agentInstanceContext) {
        long newMax = this.poolCount.incrementAndGet();
        if (newMax > this.maxPoolCountConfigured && this.maxPoolCountConfigured >= 0L) {
            Map<DeploymentIdNamePair, Long> counts = this.getCounts();
            agentInstanceContext.getStatementContext().getExceptionHandlingService().handleCondition((BaseCondition)new ConditionMatchRecognizeStatesMax(this.maxPoolCountConfigured, counts), agentInstanceContext.getStatementContext());
            if (this.preventStart) {
                this.poolCount.decrementAndGet();
                return false;
            }
            return true;
        }
        return true;
    }

    public void decreaseCount(AgentInstanceContext agentInstanceContext) {
        this.decreaseCount(agentInstanceContext, 1);
    }

    public void decreaseCount(AgentInstanceContext agentInstanceContext, int numRemoved) {
        long newMax = this.poolCount.addAndGet(-1 * numRemoved);
        if (newMax < 0L) {
            this.poolCount.set(0L);
        }
        this.logDecrease(agentInstanceContext, newMax);
    }

    private void logDecrease(AgentInstanceContext agentInstanceContext, long newMax) {
    }

    private Map<DeploymentIdNamePair, Long> getCounts() {
        HashMap<DeploymentIdNamePair, Long> counts = new HashMap<DeploymentIdNamePair, Long>();
        for (StatementEntry context : this.matchRecognizeContexts) {
            Long count = (Long)counts.get(context.getStatement());
            if (count == null) {
                count = 0L;
            }
            count = count + (long)context.getStmtCounts().getCount();
            counts.put(context.getStatement(), count);
        }
        return counts;
    }

    public static class StatementEntry {
        private final DeploymentIdNamePair statement;
        private final RowRecogStatePoolStmtHandler stmtCounts;

        public StatementEntry(DeploymentIdNamePair statement, RowRecogStatePoolStmtHandler stmtCounts) {
            this.statement = statement;
            this.stmtCounts = stmtCounts;
        }

        public DeploymentIdNamePair getStatement() {
            return this.statement;
        }

        public RowRecogStatePoolStmtHandler getStmtCounts() {
            return this.stmtCounts;
        }
    }
}

