/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.script.mvel;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.script.core.ScriptEvaluatorBase;
import com.espertech.esper.common.internal.epl.script.mvel.MVELInvoker;
import com.espertech.esper.common.internal.util.SimpleNumberCoercer;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptEvaluatorMVEL
extends ScriptEvaluatorBase {
    private static final Logger log = LoggerFactory.getLogger(ScriptEvaluatorMVEL.class);
    private final Object executable;

    public ScriptEvaluatorMVEL(String scriptName, String[] parameterNames, ExprEvaluator[] parameters, SimpleNumberCoercer coercer, Object executable) {
        super(scriptName, parameterNames, parameters, coercer);
        this.executable = executable;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        Map<String, Object> paramsList = ScriptEvaluatorMVEL.getMVELScriptParamsList(context);
        for (int i = 0; i < this.parameterNames.length; ++i) {
            paramsList.put(this.parameterNames[i], this.parameters[i].evaluate(eventsPerStream, isNewData, context));
        }
        return this.evaluateInternal(paramsList, context);
    }

    @Override
    public Object evaluate(Object lookupValues, ExprEvaluatorContext context) {
        Map<String, Object> paramsList = ScriptEvaluatorMVEL.getMVELScriptParamsList(context);
        if (this.parameterNames.length == 1) {
            paramsList.put(this.parameterNames[0], lookupValues);
        } else if (this.parameterNames.length > 1) {
            Object[] mk = (Object[])lookupValues;
            for (int i = 0; i < this.parameterNames.length; ++i) {
                paramsList.put(this.parameterNames[i], mk[i]);
            }
        }
        return this.evaluateInternal(paramsList, context);
    }

    private static Map<String, Object> getMVELScriptParamsList(ExprEvaluatorContext context) {
        HashMap<String, Object> paramsList = new HashMap<String, Object>();
        paramsList.put("epl", context.getAllocateAgentInstanceScriptContext());
        return paramsList;
    }

    private Object evaluateInternal(Map<String, Object> paramsList, ExprEvaluatorContext context) {
        try {
            Object result = MVELInvoker.executeExpression(this.executable, paramsList);
            if (this.coercer != null) {
                return this.coercer.coerceBoxed((Number)result);
            }
            return result;
        }
        catch (InvocationTargetException ex) {
            Throwable mvelException = ex.getCause();
            String message = "Unexpected exception executing script '" + this.scriptName + "' for statement '" + context.getStatementName() + "' : " + mvelException.getMessage();
            log.error(message, mvelException);
            throw new EPException(message, ex);
        }
    }
}

