/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.spatial.quadtree.mxciffilterindex;

import com.espertech.esper.common.internal.epl.spatial.quadtree.core.QuadrantAppliesEnum;
import com.espertech.esper.common.internal.epl.spatial.quadtree.mxcif.MXCIFQuadTree;
import com.espertech.esper.common.internal.epl.spatial.quadtree.mxcif.MXCIFQuadTreeNode;
import com.espertech.esper.common.internal.epl.spatial.quadtree.mxcif.MXCIFQuadTreeNodeBranch;
import com.espertech.esper.common.internal.epl.spatial.quadtree.mxcif.MXCIFQuadTreeNodeLeaf;
import com.espertech.esper.common.internal.epl.spatial.quadtree.mxciffilterindex.XYWHRectangleWValue;
import com.espertech.esper.common.internal.epl.spatial.quadtree.mxcifrowindex.MXCIFQuadTreeFilterIndexCheckBB;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public class MXCIFQuadTreeFilterIndexDelete {
    public static void delete(double x, double y, double width, double height, MXCIFQuadTree<Object> tree) {
        MXCIFQuadTreeNode<Object> root = tree.getRoot();
        MXCIFQuadTreeFilterIndexCheckBB.checkBB(root.getBb(), x, y, width, height);
        MXCIFQuadTreeNode<Object> replacement = MXCIFQuadTreeFilterIndexDelete.deleteFromNode(x, y, width, height, root, tree);
        tree.setRoot(replacement);
    }

    private static <L> MXCIFQuadTreeNode<Object> deleteFromNode(double x, double y, double width, double height, MXCIFQuadTreeNode<Object> node, MXCIFQuadTree<Object> tree) {
        boolean removed;
        if (node instanceof MXCIFQuadTreeNodeLeaf) {
            MXCIFQuadTreeNodeLeaf leaf = (MXCIFQuadTreeNodeLeaf)node;
            boolean removed2 = MXCIFQuadTreeFilterIndexDelete.deleteFromData(x, y, width, height, leaf.getData());
            if (removed2) {
                leaf.decCount();
                if (leaf.getCount() == 0) {
                    leaf.setData(null);
                }
            }
            return leaf;
        }
        MXCIFQuadTreeNodeBranch branch = (MXCIFQuadTreeNodeBranch)node;
        QuadrantAppliesEnum quadrant = node.getBb().getQuadrantApplies(x, y, width, height);
        if (quadrant == QuadrantAppliesEnum.NW) {
            branch.setNw(MXCIFQuadTreeFilterIndexDelete.deleteFromNode(x, y, width, height, branch.getNw(), tree));
        } else if (quadrant == QuadrantAppliesEnum.NE) {
            branch.setNe(MXCIFQuadTreeFilterIndexDelete.deleteFromNode(x, y, width, height, branch.getNe(), tree));
        } else if (quadrant == QuadrantAppliesEnum.SW) {
            branch.setSw(MXCIFQuadTreeFilterIndexDelete.deleteFromNode(x, y, width, height, branch.getSw(), tree));
        } else if (quadrant == QuadrantAppliesEnum.SE) {
            branch.setSe(MXCIFQuadTreeFilterIndexDelete.deleteFromNode(x, y, width, height, branch.getSe(), tree));
        } else if (quadrant == QuadrantAppliesEnum.SOME && (removed = MXCIFQuadTreeFilterIndexDelete.deleteFromData(x, y, width, height, branch.getData()))) {
            branch.decCount();
            if (branch.getCount() == 0) {
                branch.setData(null);
            }
        }
        if (!(branch.getNw() instanceof MXCIFQuadTreeNodeLeaf && branch.getNe() instanceof MXCIFQuadTreeNodeLeaf && branch.getSw() instanceof MXCIFQuadTreeNodeLeaf && branch.getSe() instanceof MXCIFQuadTreeNodeLeaf)) {
            return branch;
        }
        MXCIFQuadTreeNodeLeaf nwLeaf = (MXCIFQuadTreeNodeLeaf)branch.getNw();
        MXCIFQuadTreeNodeLeaf neLeaf = (MXCIFQuadTreeNodeLeaf)branch.getNe();
        MXCIFQuadTreeNodeLeaf swLeaf = (MXCIFQuadTreeNodeLeaf)branch.getSw();
        MXCIFQuadTreeNodeLeaf seLeaf = (MXCIFQuadTreeNodeLeaf)branch.getSe();
        int total = nwLeaf.getCount() + neLeaf.getCount() + swLeaf.getCount() + seLeaf.getCount() + branch.getCount();
        if (total >= tree.getLeafCapacity()) {
            return branch;
        }
        LinkedList<XYWHRectangleWValue<L>> collection = new LinkedList<XYWHRectangleWValue<L>>();
        int count = MXCIFQuadTreeFilterIndexDelete.mergeChildNodes(collection, branch.getData());
        count += MXCIFQuadTreeFilterIndexDelete.mergeChildNodes(collection, nwLeaf.getData());
        count += MXCIFQuadTreeFilterIndexDelete.mergeChildNodes(collection, neLeaf.getData());
        count += MXCIFQuadTreeFilterIndexDelete.mergeChildNodes(collection, swLeaf.getData());
        return new MXCIFQuadTreeNodeLeaf<Object>(branch.getBb(), branch.getLevel(), collection, count += MXCIFQuadTreeFilterIndexDelete.mergeChildNodes(collection, seLeaf.getData()));
    }

    private static <L> boolean deleteFromData(double x, double y, double width, double height, Object data) {
        if (data == null) {
            return false;
        }
        if (!(data instanceof Collection)) {
            XYWHRectangleWValue rectangle = (XYWHRectangleWValue)data;
            return rectangle.coordinateEquals(x, y, width, height);
        }
        Collection collection = (Collection)data;
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            XYWHRectangleWValue rectangles = (XYWHRectangleWValue)it.next();
            if (!rectangles.coordinateEquals(x, y, width, height)) continue;
            it.remove();
            return true;
        }
        return false;
    }

    private static <L> int mergeChildNodes(Collection<XYWHRectangleWValue<L>> target, Object data) {
        if (data == null) {
            return 0;
        }
        if (data instanceof XYWHRectangleWValue) {
            XYWHRectangleWValue p = (XYWHRectangleWValue)data;
            target.add(p);
            return 1;
        }
        Collection coll = (Collection)data;
        target.addAll(coll);
        return coll.size();
    }
}

