/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.spatial.quadtree.mxcifrowindex;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.internal.epl.index.hash.PropertyHashedEventTableUnique;
import com.espertech.esper.common.internal.epl.spatial.quadtree.core.BoundingBox;
import com.espertech.esper.common.internal.epl.spatial.quadtree.core.QuadrantAppliesEnum;
import com.espertech.esper.common.internal.epl.spatial.quadtree.mxcif.MXCIFQuadTree;
import com.espertech.esper.common.internal.epl.spatial.quadtree.mxcif.MXCIFQuadTreeNode;
import com.espertech.esper.common.internal.epl.spatial.quadtree.mxcif.MXCIFQuadTreeNodeBranch;
import com.espertech.esper.common.internal.epl.spatial.quadtree.mxcif.MXCIFQuadTreeNodeLeaf;
import com.espertech.esper.common.internal.epl.spatial.quadtree.mxcifrowindex.XYWHRectangleMultiType;
import java.util.Collection;
import java.util.LinkedList;

public class MXCIFQuadTreeRowIndexAdd {
    public static boolean add(double x, double y, double width, double height, Object value, MXCIFQuadTree<Object> tree, boolean unique, String indexName) {
        MXCIFQuadTreeNode<Object> root = tree.getRoot();
        if (!root.getBb().intersectsBoxIncludingEnd(x, y, width, height)) {
            return false;
        }
        MXCIFQuadTreeNode<Object> replacement = MXCIFQuadTreeRowIndexAdd.addToNode(x, y, width, height, value, root, tree, unique, indexName);
        tree.setRoot(replacement);
        return true;
    }

    private static MXCIFQuadTreeNode<Object> addToNode(double x, double y, double width, double height, Object value, MXCIFQuadTreeNode<Object> node, MXCIFQuadTree<Object> tree, boolean unique, String indexName) {
        if (node instanceof MXCIFQuadTreeNodeLeaf) {
            MXCIFQuadTreeNodeLeaf leaf = (MXCIFQuadTreeNodeLeaf)node;
            if (leaf.getCount() < tree.getLeafCapacity() || node.getLevel() >= tree.getMaxTreeHeight()) {
                int numAdded = MXCIFQuadTreeRowIndexAdd.addToData(leaf, x, y, width, height, value, unique, indexName);
                leaf.incCount(numAdded);
                if (leaf.getCount() <= tree.getLeafCapacity() || node.getLevel() >= tree.getMaxTreeHeight()) {
                    return leaf;
                }
            }
            node = MXCIFQuadTreeRowIndexAdd.subdivide(leaf, tree, unique, indexName);
        }
        MXCIFQuadTreeNodeBranch branch = (MXCIFQuadTreeNodeBranch)node;
        MXCIFQuadTreeRowIndexAdd.addToBranch(branch, x, y, width, height, value, tree, unique, indexName);
        return node;
    }

    private static void addToBranch(MXCIFQuadTreeNodeBranch<Object> branch, double x, double y, double width, double height, Object value, MXCIFQuadTree<Object> tree, boolean unique, String indexName) {
        QuadrantAppliesEnum quadrant = branch.getBb().getQuadrantApplies(x, y, width, height);
        if (quadrant == QuadrantAppliesEnum.NW) {
            branch.setNw(MXCIFQuadTreeRowIndexAdd.addToNode(x, y, width, height, value, branch.getNw(), tree, unique, indexName));
        } else if (quadrant == QuadrantAppliesEnum.NE) {
            branch.setNe(MXCIFQuadTreeRowIndexAdd.addToNode(x, y, width, height, value, branch.getNe(), tree, unique, indexName));
        } else if (quadrant == QuadrantAppliesEnum.SW) {
            branch.setSw(MXCIFQuadTreeRowIndexAdd.addToNode(x, y, width, height, value, branch.getSw(), tree, unique, indexName));
        } else if (quadrant == QuadrantAppliesEnum.SE) {
            branch.setSe(MXCIFQuadTreeRowIndexAdd.addToNode(x, y, width, height, value, branch.getSe(), tree, unique, indexName));
        } else if (quadrant == QuadrantAppliesEnum.SOME) {
            int numAdded = MXCIFQuadTreeRowIndexAdd.addToData(branch, x, y, width, height, value, unique, indexName);
            branch.incCount(numAdded);
        } else {
            throw new IllegalStateException("Applies to none");
        }
    }

    private static MXCIFQuadTreeNode<Object> subdivide(MXCIFQuadTreeNodeLeaf<Object> leaf, MXCIFQuadTree<Object> tree, boolean unique, String indexName) {
        double w = (leaf.getBb().getMaxX() - leaf.getBb().getMinX()) / 2.0;
        double h = (leaf.getBb().getMaxY() - leaf.getBb().getMinY()) / 2.0;
        double minx = leaf.getBb().getMinX();
        double miny = leaf.getBb().getMinY();
        BoundingBox bbNW = new BoundingBox(minx, miny, minx + w, miny + h);
        BoundingBox bbNE = new BoundingBox(minx + w, miny, leaf.getBb().getMaxX(), miny + h);
        BoundingBox bbSW = new BoundingBox(minx, miny + h, minx + w, leaf.getBb().getMaxY());
        BoundingBox bbSE = new BoundingBox(minx + w, miny + h, leaf.getBb().getMaxX(), leaf.getBb().getMaxY());
        MXCIFQuadTreeNodeLeaf<Object> nw = new MXCIFQuadTreeNodeLeaf<Object>(bbNW, leaf.getLevel() + 1, null, 0);
        MXCIFQuadTreeNodeLeaf<Object> ne = new MXCIFQuadTreeNodeLeaf<Object>(bbNE, leaf.getLevel() + 1, null, 0);
        MXCIFQuadTreeNodeLeaf<Object> sw = new MXCIFQuadTreeNodeLeaf<Object>(bbSW, leaf.getLevel() + 1, null, 0);
        MXCIFQuadTreeNodeLeaf<Object> se = new MXCIFQuadTreeNodeLeaf<Object>(bbSE, leaf.getLevel() + 1, null, 0);
        MXCIFQuadTreeNodeBranch<Object> branch = new MXCIFQuadTreeNodeBranch<Object>(leaf.getBb(), leaf.getLevel(), null, 0, nw, ne, sw, se);
        Object data = leaf.getData();
        if (data instanceof XYWHRectangleMultiType) {
            XYWHRectangleMultiType rectangle = (XYWHRectangleMultiType)data;
            MXCIFQuadTreeRowIndexAdd.subdivide(rectangle, branch, tree, unique, indexName);
        } else {
            Collection collection = (Collection)data;
            for (XYWHRectangleMultiType rectangle : collection) {
                MXCIFQuadTreeRowIndexAdd.subdivide(rectangle, branch, tree, unique, indexName);
            }
        }
        return branch;
    }

    private static void subdivide(XYWHRectangleMultiType rectangle, MXCIFQuadTreeNodeBranch<Object> branch, MXCIFQuadTree<Object> tree, boolean unique, String indexName) {
        double x = rectangle.getX();
        double y = rectangle.getY();
        double w = rectangle.getW();
        double h = rectangle.getH();
        QuadrantAppliesEnum quadrant = branch.getBb().getQuadrantApplies(x, y, w, h);
        if (quadrant == QuadrantAppliesEnum.NW) {
            branch.setNw(MXCIFQuadTreeRowIndexAdd.addToNode(x, y, w, h, rectangle, branch.getNw(), tree, unique, indexName));
        } else if (quadrant == QuadrantAppliesEnum.NE) {
            branch.setNe(MXCIFQuadTreeRowIndexAdd.addToNode(x, y, w, h, rectangle, branch.getNe(), tree, unique, indexName));
        } else if (quadrant == QuadrantAppliesEnum.SW) {
            branch.setSw(MXCIFQuadTreeRowIndexAdd.addToNode(x, y, w, h, rectangle, branch.getSw(), tree, unique, indexName));
        } else if (quadrant == QuadrantAppliesEnum.SE) {
            branch.setSe(MXCIFQuadTreeRowIndexAdd.addToNode(x, y, w, h, rectangle, branch.getSe(), tree, unique, indexName));
        } else if (quadrant == QuadrantAppliesEnum.SOME) {
            int numAdded = MXCIFQuadTreeRowIndexAdd.addToData(branch, x, y, w, h, rectangle, unique, indexName);
            branch.incCount(numAdded);
        } else {
            throw new IllegalStateException("No intersection");
        }
    }

    public static int addToData(MXCIFQuadTreeNode<Object> node, double x, double y, double width, double height, Object value, boolean unique, String indexName) {
        Object currentValue = node.getData();
        if (value instanceof XYWHRectangleMultiType) {
            XYWHRectangleMultiType rectangle = (XYWHRectangleMultiType)value;
            if (!rectangle.coordinateEquals(x, y, width, height)) {
                throw new IllegalStateException();
            }
            if (currentValue == null) {
                node.setData(rectangle);
                return rectangle.count();
            }
            if (currentValue instanceof XYWHRectangleMultiType) {
                XYWHRectangleMultiType other = (XYWHRectangleMultiType)currentValue;
                if (other.coordinateEquals(x, y, width, height)) {
                    if (unique) {
                        throw MXCIFQuadTreeRowIndexAdd.handleUniqueViolation(indexName, other);
                    }
                    other.addMultiType(rectangle);
                    return rectangle.count();
                }
                LinkedList<XYWHRectangleMultiType> collection = new LinkedList<XYWHRectangleMultiType>();
                collection.add(other);
                collection.add(rectangle);
                node.setData(collection);
                return rectangle.count();
            }
            Collection collection = (Collection)currentValue;
            for (XYWHRectangleMultiType other : collection) {
                if (!other.coordinateEquals(x, y, width, height)) continue;
                if (unique) {
                    throw MXCIFQuadTreeRowIndexAdd.handleUniqueViolation(indexName, other);
                }
                other.addMultiType(rectangle);
                return rectangle.count();
            }
            collection.add(rectangle);
            return rectangle.count();
        }
        if (currentValue == null) {
            XYWHRectangleMultiType point = new XYWHRectangleMultiType(x, y, width, height, value);
            node.setData(point);
            return 1;
        }
        if (currentValue instanceof XYWHRectangleMultiType) {
            XYWHRectangleMultiType other = (XYWHRectangleMultiType)currentValue;
            if (other.coordinateEquals(x, y, width, height)) {
                if (unique) {
                    throw MXCIFQuadTreeRowIndexAdd.handleUniqueViolation(indexName, other);
                }
                other.addSingleValue(value);
                return 1;
            }
            LinkedList<XYWHRectangleMultiType> collection = new LinkedList<XYWHRectangleMultiType>();
            collection.add(other);
            collection.add(new XYWHRectangleMultiType(x, y, width, height, value));
            node.setData(collection);
            return 1;
        }
        Collection collection = (Collection)currentValue;
        for (XYWHRectangleMultiType other : collection) {
            if (!other.coordinateEquals(x, y, width, height)) continue;
            if (unique) {
                throw MXCIFQuadTreeRowIndexAdd.handleUniqueViolation(indexName, other);
            }
            other.addSingleValue(value);
            return 1;
        }
        collection.add(new XYWHRectangleMultiType(x, y, width, height, value));
        return 1;
    }

    private static EPException handleUniqueViolation(String indexName, XYWHRectangleMultiType other) {
        return PropertyHashedEventTableUnique.handleUniqueIndexViolation(indexName, "(" + other.getX() + "," + other.getY() + "," + other.getW() + "," + other.getH() + ")");
    }
}

