/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.spatial.quadtree.prqdfilterindex;

import com.espertech.esper.common.internal.epl.spatial.quadtree.core.QuadrantEnum;
import com.espertech.esper.common.internal.epl.spatial.quadtree.pointregion.PointRegionQuadTree;
import com.espertech.esper.common.internal.epl.spatial.quadtree.pointregion.PointRegionQuadTreeNode;
import com.espertech.esper.common.internal.epl.spatial.quadtree.pointregion.PointRegionQuadTreeNodeBranch;
import com.espertech.esper.common.internal.epl.spatial.quadtree.pointregion.PointRegionQuadTreeNodeLeaf;
import com.espertech.esper.common.internal.epl.spatial.quadtree.prqdfilterindex.PointRegionQuadTreeFilterIndexCheckBB;
import com.espertech.esper.common.internal.epl.spatial.quadtree.prqdfilterindex.XYPointWValue;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public class PointRegionQuadTreeFilterIndexDelete {
    public static void delete(double x, double y, PointRegionQuadTree<Object> tree) {
        PointRegionQuadTreeNode<Object> root = tree.getRoot();
        PointRegionQuadTreeFilterIndexCheckBB.checkBB(root.getBb(), x, y);
        PointRegionQuadTreeNode<Object> replacement = PointRegionQuadTreeFilterIndexDelete.deleteFromNode(x, y, root, tree);
        tree.setRoot(replacement);
    }

    private static <L> PointRegionQuadTreeNode<Object> deleteFromNode(double x, double y, PointRegionQuadTreeNode<Object> node, PointRegionQuadTree<Object> tree) {
        if (node instanceof PointRegionQuadTreeNodeLeaf) {
            PointRegionQuadTreeNodeLeaf leaf = (PointRegionQuadTreeNodeLeaf)node;
            boolean removed = PointRegionQuadTreeFilterIndexDelete.deleteFromPoints(x, y, leaf.getPoints());
            if (removed) {
                leaf.decCount();
                if (leaf.getCount() == 0) {
                    leaf.setPoints(null);
                }
            }
            return leaf;
        }
        PointRegionQuadTreeNodeBranch branch = (PointRegionQuadTreeNodeBranch)node;
        QuadrantEnum quadrant = node.getBb().getQuadrant(x, y);
        if (quadrant == QuadrantEnum.NW) {
            branch.setNw(PointRegionQuadTreeFilterIndexDelete.deleteFromNode(x, y, branch.getNw(), tree));
        } else if (quadrant == QuadrantEnum.NE) {
            branch.setNe(PointRegionQuadTreeFilterIndexDelete.deleteFromNode(x, y, branch.getNe(), tree));
        } else if (quadrant == QuadrantEnum.SW) {
            branch.setSw(PointRegionQuadTreeFilterIndexDelete.deleteFromNode(x, y, branch.getSw(), tree));
        } else {
            branch.setSe(PointRegionQuadTreeFilterIndexDelete.deleteFromNode(x, y, branch.getSe(), tree));
        }
        if (!(branch.getNw() instanceof PointRegionQuadTreeNodeLeaf && branch.getNe() instanceof PointRegionQuadTreeNodeLeaf && branch.getSw() instanceof PointRegionQuadTreeNodeLeaf && branch.getSe() instanceof PointRegionQuadTreeNodeLeaf)) {
            return branch;
        }
        PointRegionQuadTreeNodeLeaf nwLeaf = (PointRegionQuadTreeNodeLeaf)branch.getNw();
        PointRegionQuadTreeNodeLeaf neLeaf = (PointRegionQuadTreeNodeLeaf)branch.getNe();
        PointRegionQuadTreeNodeLeaf swLeaf = (PointRegionQuadTreeNodeLeaf)branch.getSw();
        PointRegionQuadTreeNodeLeaf seLeaf = (PointRegionQuadTreeNodeLeaf)branch.getSe();
        int total = nwLeaf.getCount() + neLeaf.getCount() + swLeaf.getCount() + seLeaf.getCount();
        if (total >= tree.getLeafCapacity()) {
            return branch;
        }
        LinkedList<XYPointWValue<L>> collection = new LinkedList<XYPointWValue<L>>();
        int count = PointRegionQuadTreeFilterIndexDelete.mergeChildNodes(collection, nwLeaf.getPoints());
        count += PointRegionQuadTreeFilterIndexDelete.mergeChildNodes(collection, neLeaf.getPoints());
        count += PointRegionQuadTreeFilterIndexDelete.mergeChildNodes(collection, swLeaf.getPoints());
        return new PointRegionQuadTreeNodeLeaf<Object>(branch.getBb(), branch.getLevel(), collection, count += PointRegionQuadTreeFilterIndexDelete.mergeChildNodes(collection, seLeaf.getPoints()));
    }

    private static <L> boolean deleteFromPoints(double x, double y, Object points) {
        if (points == null) {
            return false;
        }
        if (!(points instanceof Collection)) {
            XYPointWValue point = (XYPointWValue)points;
            return point.getX() == x && point.getY() == y;
        }
        Collection collection = (Collection)points;
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            XYPointWValue point = (XYPointWValue)it.next();
            if (point.getX() != x || point.getY() != y) continue;
            it.remove();
            return true;
        }
        return false;
    }

    private static <L> int mergeChildNodes(Collection<XYPointWValue<L>> target, Object points) {
        if (points == null) {
            return 0;
        }
        if (points instanceof XYPointWValue) {
            XYPointWValue p = (XYPointWValue)points;
            target.add(p);
            return 1;
        }
        Collection coll = (Collection)points;
        for (XYPointWValue p : coll) {
            target.add(p);
        }
        return coll.size();
    }
}

