/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.spatial.quadtree.prqdfilterindex;

import com.espertech.esper.common.internal.epl.spatial.quadtree.pointregion.PointRegionQuadTree;
import com.espertech.esper.common.internal.epl.spatial.quadtree.pointregion.PointRegionQuadTreeNode;
import com.espertech.esper.common.internal.epl.spatial.quadtree.pointregion.PointRegionQuadTreeNodeBranch;
import com.espertech.esper.common.internal.epl.spatial.quadtree.pointregion.PointRegionQuadTreeNodeLeaf;
import com.espertech.esper.common.internal.epl.spatial.quadtree.prqdfilterindex.XYPointWValue;
import com.espertech.esper.common.internal.epl.spatial.quadtree.prqdrowindex.XYPointMultiType;
import java.util.Collection;
import java.util.function.Consumer;

public class PointRegionQuadTreeFilterIndexTraverse {
    public static void traverse(PointRegionQuadTree<Object> quadtree, Consumer<Object> consumer) {
        PointRegionQuadTreeFilterIndexTraverse.traverse(quadtree.getRoot(), consumer);
    }

    public static void traverse(PointRegionQuadTreeNode<Object> node, Consumer<Object> consumer) {
        if (node instanceof PointRegionQuadTreeNodeLeaf) {
            PointRegionQuadTreeNodeLeaf leaf = (PointRegionQuadTreeNodeLeaf)node;
            PointRegionQuadTreeFilterIndexTraverse.traverseData(leaf.getPoints(), consumer);
            return;
        }
        PointRegionQuadTreeNodeBranch branch = (PointRegionQuadTreeNodeBranch)node;
        PointRegionQuadTreeFilterIndexTraverse.traverse(branch.getNw(), consumer);
        PointRegionQuadTreeFilterIndexTraverse.traverse(branch.getNe(), consumer);
        PointRegionQuadTreeFilterIndexTraverse.traverse(branch.getSw(), consumer);
        PointRegionQuadTreeFilterIndexTraverse.traverse(branch.getSe(), consumer);
    }

    private static void traverseData(Object data, Consumer<Object> consumer) {
        if (data == null) {
            return;
        }
        if (!(data instanceof Collection)) {
            PointRegionQuadTreeFilterIndexTraverse.visit(data, consumer);
            return;
        }
        Collection collection = (Collection)data;
        for (Object datapoint : collection) {
            PointRegionQuadTreeFilterIndexTraverse.visit(datapoint, consumer);
        }
    }

    private static void visit(Object data, Consumer<Object> consumer) {
        XYPointMultiType multiType;
        if (data instanceof XYPointWValue) {
            consumer.accept(((XYPointWValue)data).getValue());
        } else if (data instanceof XYPointMultiType && (multiType = (XYPointMultiType)data).getMultityped() instanceof Collection) {
            Collection collection = (Collection)multiType.getMultityped();
            for (Object datapoint : collection) {
                PointRegionQuadTreeFilterIndexTraverse.visit(datapoint, consumer);
            }
        }
    }
}

