/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.spatial.quadtree.prqdrowindex;

import com.espertech.esper.common.internal.epl.spatial.quadtree.core.BoundingBox;
import com.espertech.esper.common.internal.epl.spatial.quadtree.pointregion.PointRegionQuadTree;
import com.espertech.esper.common.internal.epl.spatial.quadtree.pointregion.PointRegionQuadTreeNode;
import com.espertech.esper.common.internal.epl.spatial.quadtree.pointregion.PointRegionQuadTreeNodeBranch;
import com.espertech.esper.common.internal.epl.spatial.quadtree.pointregion.PointRegionQuadTreeNodeLeaf;
import com.espertech.esper.common.internal.epl.spatial.quadtree.prqdrowindex.XYPointMultiType;
import java.util.ArrayDeque;
import java.util.Collection;

public class PointRegionQuadTreeRowIndexQuery {
    public static Collection<Object> queryRange(PointRegionQuadTree<Object> quadTree, double x, double y, double width, double height) {
        return PointRegionQuadTreeRowIndexQuery.queryNode(quadTree.getRoot(), x, y, width, height, null);
    }

    private static Collection<Object> queryNode(PointRegionQuadTreeNode<Object> node, double x, double y, double width, double height, Collection<Object> result) {
        if (!node.getBb().intersectsBoxIncludingEnd(x, y, width, height)) {
            return result;
        }
        if (node instanceof PointRegionQuadTreeNodeLeaf) {
            PointRegionQuadTreeNodeLeaf leaf = (PointRegionQuadTreeNodeLeaf)node;
            return PointRegionQuadTreeRowIndexQuery.visit(leaf, x, y, width, height, result);
        }
        PointRegionQuadTreeNodeBranch branch = (PointRegionQuadTreeNodeBranch)node;
        result = PointRegionQuadTreeRowIndexQuery.queryNode(branch.getNw(), x, y, width, height, result);
        result = PointRegionQuadTreeRowIndexQuery.queryNode(branch.getNe(), x, y, width, height, result);
        result = PointRegionQuadTreeRowIndexQuery.queryNode(branch.getSw(), x, y, width, height, result);
        result = PointRegionQuadTreeRowIndexQuery.queryNode(branch.getSe(), x, y, width, height, result);
        return result;
    }

    private static Collection<Object> visit(PointRegionQuadTreeNodeLeaf node, double x, double y, double width, double height, Collection<Object> result) {
        Object points = node.getPoints();
        if (points == null) {
            return result;
        }
        if (points instanceof XYPointMultiType) {
            XYPointMultiType point = (XYPointMultiType)points;
            return PointRegionQuadTreeRowIndexQuery.visit(point, x, y, width, height, result);
        }
        Collection collection = (Collection)points;
        for (XYPointMultiType point : collection) {
            result = PointRegionQuadTreeRowIndexQuery.visit(point, x, y, width, height, result);
        }
        return result;
    }

    private static Collection<Object> visit(XYPointMultiType point, double x, double y, double width, double height, Collection<Object> result) {
        if (!BoundingBox.containsPoint(x, y, width, height, point.getX(), point.getY())) {
            return result;
        }
        if (result == null) {
            result = new ArrayDeque<Object>(4);
        }
        point.collectInto(result);
        return result;
    }
}

