/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.table.core;

import com.espertech.esper.common.internal.context.module.EPStatementInitServices;
import com.espertech.esper.common.internal.epl.table.compiletime.TableMetaData;
import com.espertech.esper.common.internal.epl.table.core.Table;
import com.espertech.esper.common.internal.epl.table.core.TableDeployment;
import com.espertech.esper.common.internal.epl.table.core.TableExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.table.core.TableManagementService;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;

public abstract class TableManagementServiceBase
implements TableManagementService {
    private final TableExprEvaluatorContext tableExprEvaluatorContext;
    private final Map<String, TableDeployment> deployments = new HashMap<String, TableDeployment>();

    public TableManagementServiceBase(TableExprEvaluatorContext tableExprEvaluatorContext) {
        this.tableExprEvaluatorContext = tableExprEvaluatorContext;
    }

    @Override
    public TableExprEvaluatorContext getTableExprEvaluatorContext() {
        return this.tableExprEvaluatorContext;
    }

    @Override
    public void addTable(String tableName, TableMetaData tableMetaData, EPStatementInitServices services) {
        TableDeployment deployment = this.deployments.get(services.getDeploymentId());
        if (deployment == null) {
            deployment = new TableDeployment();
            this.deployments.put(services.getDeploymentId(), deployment);
        }
        deployment.add(tableName, tableMetaData, services);
    }

    @Override
    public Table getTable(String deploymentId, String tableName) {
        TableDeployment deployment = this.deployments.get(deploymentId);
        return deployment == null ? null : deployment.getTable(tableName);
    }

    @Override
    public void destroyTable(String deploymentId, String tableName) {
        TableDeployment deployment = this.deployments.get(deploymentId);
        if (deployment == null) {
            return;
        }
        deployment.remove(tableName);
        if (deployment.isEmpty()) {
            this.deployments.remove(deploymentId);
        }
    }

    @Override
    public int getDeploymentCount() {
        return this.deployments.size();
    }

    @Override
    public void traverseTables(BiConsumer<String, Table> consumer) {
        for (Map.Entry<String, TableDeployment> entry : this.deployments.entrySet()) {
            for (Map.Entry<String, Table> table : entry.getValue().getTables().entrySet()) {
                consumer.accept(entry.getKey(), table.getValue());
            }
        }
    }
}

