/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.table.update;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.join.lookup.IndexMultiKey;
import com.espertech.esper.common.internal.epl.join.lookup.IndexedPropDesc;
import com.espertech.esper.common.internal.epl.lookupplansubord.EventTableIndexMetadataEntry;
import com.espertech.esper.common.internal.epl.table.compiletime.TableMetaData;
import com.espertech.esper.common.internal.epl.table.update.TableUpdateStrategy;
import com.espertech.esper.common.internal.epl.table.update.TableUpdateStrategyIndexNonUnique;
import com.espertech.esper.common.internal.epl.table.update.TableUpdateStrategyNonIndex;
import com.espertech.esper.common.internal.epl.table.update.TableUpdateStrategyWUniqueConstraint;
import com.espertech.esper.common.internal.epl.updatehelper.EventBeanUpdateHelperNoCopy;
import com.espertech.esper.common.internal.type.NameAndModule;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class TableUpdateStrategyFactory {
    public static void validateNewUniqueIndex(String[] tableUpdatedProperties, IndexedPropDesc[] hashIndexedProps) {
        for (IndexedPropDesc prop : hashIndexedProps) {
            for (String col : tableUpdatedProperties) {
                if (!prop.getIndexPropName().equals(col)) continue;
                throw new EPException("Create-index adds a unique key on columns that are updated by one or more on-merge statements");
            }
        }
    }

    public static void validateTableUpdateOnMerge(TableMetaData tableMetadata, String[] updatedProperties) throws ExprValidationException {
        IndexUpdateDesc desc = TableUpdateStrategyFactory.getAffectedIndexes(tableMetadata, updatedProperties);
        if (desc.affectedIndexNames != null && desc.uniqueIndexUpdated) {
            throw new ExprValidationException("On-merge statements may not update unique keys of tables");
        }
    }

    public static TableUpdateStrategy validateGetTableUpdateStrategy(TableMetaData tableMetadata, EventBeanUpdateHelperNoCopy updateHelper, boolean isOnMerge) throws ExprValidationException {
        IndexUpdateDesc desc = TableUpdateStrategyFactory.getAffectedIndexes(tableMetadata, updateHelper.getUpdatedProperties());
        if (desc.affectedIndexNames != null && desc.uniqueIndexUpdated) {
            if (isOnMerge) {
                throw new ExprValidationException("On-merge statements may not update unique keys of tables");
            }
            return new TableUpdateStrategyWUniqueConstraint(updateHelper, desc.affectedIndexNames);
        }
        if (desc.affectedIndexNames != null) {
            return new TableUpdateStrategyIndexNonUnique(updateHelper, desc.affectedIndexNames);
        }
        return new TableUpdateStrategyNonIndex(updateHelper);
    }

    private static IndexUpdateDesc getAffectedIndexes(TableMetaData tableMetadata, String[] updatedProperties) {
        LinkedHashSet<NameAndModule> affectedIndexNames = null;
        boolean uniqueIndexUpdated = false;
        for (Map.Entry<IndexMultiKey, EventTableIndexMetadataEntry> index : tableMetadata.getIndexMetadata().getIndexes().entrySet()) {
            for (String updatedProperty : updatedProperties) {
                boolean match = TableUpdateStrategyFactory.determineUpdatesIndex(updatedProperty, index.getKey());
                if (!match) continue;
                if (affectedIndexNames == null) {
                    affectedIndexNames = new LinkedHashSet<NameAndModule>();
                }
                EventTableIndexMetadataEntry indexMeta = index.getValue();
                affectedIndexNames.add(new NameAndModule(indexMeta.getOptionalIndexName(), indexMeta.getOptionalIndexModuleName()));
                uniqueIndexUpdated |= index.getKey().isUnique();
            }
        }
        return new IndexUpdateDesc(affectedIndexNames, uniqueIndexUpdated);
    }

    private static boolean determineUpdatesIndex(String updatedProperty, IndexMultiKey key) {
        for (IndexedPropDesc prop : key.getHashIndexedProps()) {
            if (!prop.getIndexPropName().equals(updatedProperty)) continue;
            return true;
        }
        for (IndexedPropDesc prop : key.getRangeIndexedProps()) {
            if (!prop.getIndexPropName().equals(updatedProperty)) continue;
            return true;
        }
        return false;
    }

    private static class IndexUpdateDesc {
        private final Set<NameAndModule> affectedIndexNames;
        private final boolean uniqueIndexUpdated;

        public IndexUpdateDesc(Set<NameAndModule> affectedIndexNames, boolean uniqueIndexUpdated) {
            this.affectedIndexNames = affectedIndexNames;
            this.uniqueIndexUpdated = uniqueIndexUpdated;
        }
    }
}

