/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.updatehelper;

import com.espertech.esper.common.client.EventPropertyDescriptor;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.FragmentEventType;
import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypeNull;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.compile.stage1.spec.OnTriggerSetAssignment;
import com.espertech.esper.common.internal.epl.expression.assign.ExprAssignment;
import com.espertech.esper.common.internal.epl.expression.assign.ExprAssignmentCurly;
import com.espertech.esper.common.internal.epl.expression.assign.ExprAssignmentLHSArrayElement;
import com.espertech.esper.common.internal.epl.expression.assign.ExprAssignmentLHSIdent;
import com.espertech.esper.common.internal.epl.expression.assign.ExprAssignmentStraight;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprIdentNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityPrint;
import com.espertech.esper.common.internal.epl.expression.core.ExprStreamUnderlyingNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeIdentifierCollectVisitor;
import com.espertech.esper.common.internal.epl.updatehelper.EventBeanUpdateHelperForge;
import com.espertech.esper.common.internal.epl.updatehelper.EventBeanUpdateItemArray;
import com.espertech.esper.common.internal.epl.updatehelper.EventBeanUpdateItemForge;
import com.espertech.esper.common.internal.event.avro.EventTypeAvroHandler;
import com.espertech.esper.common.internal.event.core.BaseNestableEventType;
import com.espertech.esper.common.internal.event.core.EventBeanCopyMethodForge;
import com.espertech.esper.common.internal.event.core.EventPropertyGetterSPI;
import com.espertech.esper.common.internal.event.core.EventPropertyWriterSPI;
import com.espertech.esper.common.internal.event.core.EventTypeSPI;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import com.espertech.esper.common.internal.util.ClassHelperPrint;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import com.espertech.esper.common.internal.util.StringValue;
import com.espertech.esper.common.internal.util.TypeWidenerCustomizer;
import com.espertech.esper.common.internal.util.TypeWidenerException;
import com.espertech.esper.common.internal.util.TypeWidenerFactory;
import com.espertech.esper.common.internal.util.TypeWidenerSPI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class EventBeanUpdateHelperForgeFactory {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EventBeanUpdateHelperForge make(String updatedWindowOrTableName, EventTypeSPI eventTypeSPI, List<OnTriggerSetAssignment> assignments, String updatedAlias, EventType optionalTriggeringEventType, boolean isCopyOnWrite, String statementName, EventTypeAvroHandler avroHandler) throws ExprValidationException {
        EventBeanCopyMethodForge copyMethod;
        ArrayList<EventBeanUpdateItemForge> updateItems = new ArrayList<EventBeanUpdateItemForge>();
        ArrayList<String> properties = new ArrayList<String>();
        TypeWidenerCustomizer typeWidenerCustomizer = avroHandler.getTypeWidenerCustomizer(eventTypeSPI);
        for (int i = 0; i < assignments.size(); ++i) {
            OnTriggerSetAssignment desc = assignments.get(i);
            ExprAssignment assignment = desc.getValidated();
            if (assignment == null) {
                throw new IllegalStateException("Assignment has not been validated");
            }
            try {
                EventBeanUpdateItemForge updateItem;
                if (assignment instanceof ExprAssignmentStraight) {
                    ExprAssignmentStraight straight = (ExprAssignmentStraight)assignment;
                    if (straight.getLhs() instanceof ExprAssignmentLHSIdent) {
                        TypeWidenerSPI widener;
                        ExprAssignmentLHSIdent ident = (ExprAssignmentLHSIdent)straight.getLhs();
                        String propertyName = ident.getIdent();
                        EventPropertyDescriptor writableProperty = eventTypeSPI.getWritableProperty(propertyName);
                        if (writableProperty == null) {
                            Pair<String, EventPropertyDescriptor> nameWriteablePair = EventBeanUpdateHelperForgeFactory.checkIndexedOrMappedProp(propertyName, updatedWindowOrTableName, updatedAlias, eventTypeSPI);
                            propertyName = nameWriteablePair.getFirst();
                            writableProperty = nameWriteablePair.getSecond();
                        }
                        EPType type = writableProperty.getPropertyEPType();
                        ExprNode rhsExpr = straight.getRhs();
                        ExprForge rhsForge = rhsExpr.getForge();
                        EventPropertyWriterSPI writer = eventTypeSPI.getWriter(propertyName);
                        boolean notNullableField = JavaClassHelper.isTypePrimitive(type);
                        properties.add(propertyName);
                        EPType evalType = rhsForge.getEvaluationType();
                        try {
                            widener = TypeWidenerFactory.getCheckPropertyAssignType(ExprNodeUtilityPrint.toExpressionStringMinPrecedenceSafe(rhsExpr), evalType == null ? EPTypeNull.INSTANCE : evalType, writableProperty.getPropertyEPType(), propertyName, false, typeWidenerCustomizer, statementName);
                        }
                        catch (TypeWidenerException ex) {
                            throw new ExprValidationException(ex.getMessage(), ex);
                        }
                        boolean useUntypedAssignment = false;
                        boolean useTriggeringEvent = false;
                        if (optionalTriggeringEventType != null) {
                            ExprStreamUnderlyingNode und;
                            if (rhsExpr instanceof ExprIdentNode) {
                                ExprIdentNode node = (ExprIdentNode)rhsExpr;
                                FragmentEventType fragmentRHS = optionalTriggeringEventType.getFragmentType(node.getResolvedPropertyName());
                                FragmentEventType fragmentLHS = eventTypeSPI.getFragmentType(propertyName);
                                if (fragmentRHS != null && fragmentLHS != null && !EventTypeUtility.isTypeOrSubTypeOf(fragmentRHS.getFragmentType(), fragmentLHS.getFragmentType())) {
                                    throw EventBeanUpdateHelperForgeFactory.makeEventTypeMismatch(propertyName, fragmentLHS.getFragmentType(), fragmentRHS.getFragmentType());
                                }
                                if (node.getStreamId() == 0 && fragmentLHS != null && eventTypeSPI instanceof BaseNestableEventType) {
                                    useUntypedAssignment = true;
                                }
                            }
                            if (rhsExpr instanceof ExprStreamUnderlyingNode && (und = (ExprStreamUnderlyingNode)rhsExpr).getStreamId() == 1) {
                                FragmentEventType fragmentLHS = eventTypeSPI.getFragmentType(propertyName);
                                if (fragmentLHS != null && optionalTriggeringEventType instanceof BaseNestableEventType && !EventTypeUtility.isTypeOrSubTypeOf(optionalTriggeringEventType, fragmentLHS.getFragmentType())) {
                                    throw EventBeanUpdateHelperForgeFactory.makeEventTypeMismatch(propertyName, fragmentLHS.getFragmentType(), optionalTriggeringEventType);
                                }
                                if (eventTypeSPI instanceof BaseNestableEventType) {
                                    useUntypedAssignment = true;
                                    useTriggeringEvent = true;
                                }
                            }
                        }
                        updateItem = new EventBeanUpdateItemForge(rhsForge, propertyName, writer, notNullableField, widener, useUntypedAssignment, useTriggeringEvent, null);
                    } else {
                        TypeWidenerSPI widener;
                        if (!(straight.getLhs() instanceof ExprAssignmentLHSArrayElement)) throw new IllegalStateException("Unrecognized LHS assignment " + straight);
                        ExprAssignmentLHSArrayElement arrayElementLHS = (ExprAssignmentLHSArrayElement)straight.getLhs();
                        String arrayPropertyName = arrayElementLHS.getIdent();
                        ExprNode rhs = straight.getRhs();
                        EPType evaluationType = rhs.getForge().getEvaluationType();
                        EPType propertyType = eventTypeSPI.getPropertyEPType(arrayPropertyName);
                        if (!eventTypeSPI.isProperty(arrayPropertyName)) {
                            throw new ExprValidationException("Property '" + arrayPropertyName + "' could not be found");
                        }
                        if (propertyType == null || propertyType == EPTypeNull.INSTANCE || !((EPTypeClass)propertyType).getType().isArray()) {
                            throw new ExprValidationException("Property '" + arrayPropertyName + "' is not an array");
                        }
                        if (evaluationType == null || evaluationType == EPTypeNull.INSTANCE) {
                            throw new ExprValidationException("Right-hand-side evaluation returns null-typed value for '" + arrayPropertyName + "'");
                        }
                        EPTypeClass evaluationClass = (EPTypeClass)evaluationType;
                        EPTypeClass propertyClass = (EPTypeClass)propertyType;
                        EventPropertyGetterSPI getter = eventTypeSPI.getGetterSPI(arrayPropertyName);
                        EPTypeClass componentType = JavaClassHelper.getArrayComponentType(propertyClass);
                        if (!JavaClassHelper.isAssignmentCompatible(evaluationClass, componentType.getType())) {
                            throw new ExprValidationException("Invalid assignment to property '" + arrayPropertyName + "' component type '" + ClassHelperPrint.getClassNameFullyQualPretty(componentType) + "' from expression returning '" + evaluationType.getTypeName() + "'");
                        }
                        try {
                            widener = TypeWidenerFactory.getCheckPropertyAssignType(ExprNodeUtilityPrint.toExpressionStringMinPrecedenceSafe(straight.getRhs()), evaluationType, componentType, arrayPropertyName, false, typeWidenerCustomizer, statementName);
                        }
                        catch (TypeWidenerException ex) {
                            throw new ExprValidationException(ex.getMessage(), ex);
                        }
                        EventBeanUpdateItemArray arrayInfo = new EventBeanUpdateItemArray(arrayPropertyName, arrayElementLHS.getIndexExpression(), propertyClass, getter);
                        updateItem = new EventBeanUpdateItemForge(rhs.getForge(), arrayPropertyName, null, false, widener, false, false, arrayInfo);
                    }
                } else {
                    if (!(assignment instanceof ExprAssignmentCurly)) throw new IllegalStateException("Unrecognized assignment " + assignment);
                    ExprAssignmentCurly dot = (ExprAssignmentCurly)assignment;
                    updateItem = new EventBeanUpdateItemForge(dot.getExpression().getForge(), null, null, false, null, false, false, null);
                }
                updateItems.add(updateItem);
                continue;
            }
            catch (ExprValidationException ex) {
                throw new ExprValidationException("Failed to validate assignment expression '" + ExprNodeUtilityPrint.toExpressionStringMinPrecedenceSafe(assignment.getOriginalExpression()) + "': " + ex.getMessage(), ex);
            }
        }
        if (isCopyOnWrite) {
            ArrayList propertiesUniqueList = new ArrayList(new HashSet(properties));
            String[] propertiesArray = propertiesUniqueList.toArray(new String[propertiesUniqueList.size()]);
            copyMethod = eventTypeSPI.getCopyMethodForge(propertiesArray);
            if (copyMethod == null) {
                throw new ExprValidationException("Event type does not support event bean copy");
            }
        } else {
            copyMethod = null;
            Set<String> propertiesInitialValue = EventBeanUpdateHelperForgeFactory.determinePropertiesInitialValue(assignments);
            if (!propertiesInitialValue.isEmpty()) {
                String[] propertiesInitialValueArray = propertiesInitialValue.toArray(new String[propertiesInitialValue.size()]);
                copyMethod = eventTypeSPI.getCopyMethodForge(propertiesInitialValueArray);
            }
        }
        EventBeanUpdateItemForge[] updateItemsArray = updateItems.toArray(new EventBeanUpdateItemForge[updateItems.size()]);
        return new EventBeanUpdateHelperForge(eventTypeSPI, copyMethod, updateItemsArray);
    }

    private static ExprValidationException makeEventTypeMismatch(String propertyName, EventType lhs, EventType rhs) {
        return new ExprValidationException("Invalid assignment to property '" + propertyName + "' event type '" + lhs.getName() + "' from event type '" + rhs.getName() + "'");
    }

    private static Set<String> determinePropertiesInitialValue(List<OnTriggerSetAssignment> assignments) {
        HashSet<String> props = new HashSet<String>();
        ExprNodeIdentifierCollectVisitor visitor = new ExprNodeIdentifierCollectVisitor();
        for (OnTriggerSetAssignment assignment : assignments) {
            assignment.getValidated().accept(visitor);
            for (ExprIdentNode node : visitor.getExprProperties()) {
                if (node.getStreamId() != 2) continue;
                props.add(node.getResolvedPropertyName());
            }
            visitor.reset();
        }
        return props;
    }

    private static Pair<String, EventPropertyDescriptor> checkIndexedOrMappedProp(String propertyName, String updatedWindowOrTableName, String namedWindowAlias, EventTypeSPI eventTypeSPI) throws ExprValidationException {
        String name;
        String prefix;
        EventPropertyDescriptor writableProperty = null;
        int indexDot = propertyName.indexOf(".");
        if (namedWindowAlias != null && indexDot != -1) {
            prefix = StringValue.unescapeBacktick(propertyName.substring(0, indexDot));
            name = propertyName.substring(indexDot + 1);
            if (prefix.equals(namedWindowAlias)) {
                writableProperty = eventTypeSPI.getWritableProperty(name);
                propertyName = name;
            }
        }
        if (writableProperty == null && indexDot != -1) {
            prefix = propertyName.substring(0, indexDot);
            name = propertyName.substring(indexDot + 1);
            if (prefix.equals(updatedWindowOrTableName)) {
                writableProperty = eventTypeSPI.getWritableProperty(name);
                propertyName = name;
            }
        }
        if (writableProperty == null) {
            throw new ExprValidationException("Property '" + propertyName + "' is not available for write access");
        }
        return new Pair<String, Object>(propertyName, writableProperty);
    }
}

