/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.updatehelper;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.epl.expression.codegen.CodegenLegoCast;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.updatehelper.EventBeanUpdateItemArrayExpressions;
import com.espertech.esper.common.internal.event.core.EventPropertyGetterSPI;

public class EventBeanUpdateItemArray {
    private final String propertyName;
    private final ExprNode indexExpression;
    private final EPTypeClass arrayType;
    private final EventPropertyGetterSPI getter;

    public EventBeanUpdateItemArray(String propertyName, ExprNode indexExpression, EPTypeClass arrayType, EventPropertyGetterSPI getter) {
        this.propertyName = propertyName;
        this.indexExpression = indexExpression;
        this.arrayType = arrayType;
        this.getter = getter;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public EPTypeClass getArrayType() {
        return this.arrayType;
    }

    public EventBeanUpdateItemArrayExpressions getArrayExpressions(CodegenMethodScope parentScope, ExprForgeCodegenSymbol symbols, CodegenClassScope classScope) {
        CodegenExpression index = this.indexExpression.getForge().evaluateCodegen(EPTypePremade.INTEGERBOXED.getEPType(), parentScope, symbols, classScope);
        CodegenExpression arrayGet = this.evaluateArrayCodegen(parentScope, symbols, classScope);
        return new EventBeanUpdateItemArrayExpressions(index, arrayGet);
    }

    private CodegenExpression evaluateArrayCodegen(CodegenMethodScope parent, ExprForgeCodegenSymbol symbols, CodegenClassScope classScope) {
        CodegenMethod method = parent.makeChild(this.arrayType, this.getClass(), (CodegenScope)classScope);
        method.getBlock().declareVar(EventBean.EPTYPE, "event", CodegenExpressionBuilder.arrayAtIndex(symbols.getAddEPS(method), CodegenExpressionBuilder.constant(0))).ifRefNullReturnNull("event").methodReturn(CodegenLegoCast.castSafeFromObjectType(this.arrayType, this.getter.eventBeanGetCodegen(CodegenExpressionBuilder.ref("event"), method, classScope)));
        return CodegenExpressionBuilder.localMethod(method, new CodegenExpression[0]);
    }
}

