/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.util;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class FilteredEventIterator
implements Iterator<EventBean> {
    private final Iterator<EventBean> parent;
    private final ExprEvaluator filter;
    private final EventBean[] eventPerStream = new EventBean[1];
    private final ExprEvaluatorContext exprEvaluatorContext;
    private EventBean next;

    public FilteredEventIterator(ExprEvaluator filter, Iterator<EventBean> parent, ExprEvaluatorContext exprEvaluatorContext) {
        if (filter == null) {
            throw new IllegalArgumentException("Null filter");
        }
        this.parent = parent;
        this.filter = filter;
        this.exprEvaluatorContext = exprEvaluatorContext;
        this.getNext();
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public EventBean next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        EventBean result = this.next;
        this.getNext();
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void getNext() {
        while (this.parent.hasNext()) {
            this.eventPerStream[0] = this.next = this.parent.next();
            Boolean result = (Boolean)this.filter.evaluate(this.eventPerStream, true, this.exprEvaluatorContext);
            if (result == null || !result.booleanValue()) continue;
            return;
        }
        this.next = null;
    }
}

