/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.util;

import com.espertech.esper.common.internal.compile.stage1.spec.NamedWindowConsumerStreamSpec;
import com.espertech.esper.common.internal.compile.stage1.spec.PatternStreamSpecCompiled;
import com.espertech.esper.common.internal.compile.stage1.spec.StreamSpecCompiled;
import com.espertech.esper.common.internal.compile.stage2.EvalNodeAnalysisResult;
import com.espertech.esper.common.internal.compile.stage2.EvalNodeUtil;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecCompiled;
import com.espertech.esper.common.internal.compile.stage2.FilterStreamSpecCompiled;
import com.espertech.esper.common.internal.compile.stage2.StatementSpecCompiled;
import com.espertech.esper.common.internal.epl.expression.subquery.ExprSubselectNode;
import com.espertech.esper.common.internal.epl.pattern.filter.EvalFilterForgeNode;
import com.espertech.esper.common.internal.epl.util.StatementSpecCompiledAnalyzerResult;
import java.util.ArrayList;
import java.util.List;

public class StatementSpecCompiledAnalyzer {
    public static StatementSpecCompiledAnalyzerResult analyzeFilters(StatementSpecCompiled spec) {
        ArrayList<FilterSpecCompiled> filters = new ArrayList<FilterSpecCompiled>();
        ArrayList<NamedWindowConsumerStreamSpec> namedWindows = new ArrayList<NamedWindowConsumerStreamSpec>();
        StatementSpecCompiledAnalyzer.addFilters(spec.getStreamSpecs(), filters, namedWindows);
        for (ExprSubselectNode subselect : spec.getSubselectNodes()) {
            StatementSpecCompiledAnalyzer.addFilters(subselect.getStatementSpecCompiled().getStreamSpecs(), filters, namedWindows);
        }
        return new StatementSpecCompiledAnalyzerResult(filters, namedWindows);
    }

    private static void addFilters(StreamSpecCompiled[] streams, List<FilterSpecCompiled> filters, List<NamedWindowConsumerStreamSpec> namedWindows) {
        for (StreamSpecCompiled compiled : streams) {
            if (compiled instanceof FilterStreamSpecCompiled) {
                FilterStreamSpecCompiled c = (FilterStreamSpecCompiled)compiled;
                filters.add(c.getFilterSpecCompiled());
            }
            if (compiled instanceof PatternStreamSpecCompiled) {
                PatternStreamSpecCompiled r = (PatternStreamSpecCompiled)compiled;
                EvalNodeAnalysisResult evalNodeAnalysisResult = EvalNodeUtil.recursiveAnalyzeChildNodes(r.getRoot());
                List<EvalFilterForgeNode> filterNodes = evalNodeAnalysisResult.getFilterNodes();
                for (EvalFilterForgeNode filterNode : filterNodes) {
                    filters.add(filterNode.getFilterSpecCompiled());
                }
            }
            if (!(compiled instanceof NamedWindowConsumerStreamSpec)) continue;
            namedWindows.add((NamedWindowConsumerStreamSpec)compiled);
        }
    }
}

