/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.util;

import com.espertech.esper.common.internal.compile.stage1.spec.FilterStreamSpecRaw;
import com.espertech.esper.common.internal.compile.stage1.spec.FireAndForgetSpec;
import com.espertech.esper.common.internal.compile.stage1.spec.FireAndForgetSpecInsert;
import com.espertech.esper.common.internal.compile.stage1.spec.FireAndForgetSpecUpdate;
import com.espertech.esper.common.internal.compile.stage1.spec.OnTriggerDesc;
import com.espertech.esper.common.internal.compile.stage1.spec.OnTriggerMergeAction;
import com.espertech.esper.common.internal.compile.stage1.spec.OnTriggerMergeActionInsert;
import com.espertech.esper.common.internal.compile.stage1.spec.OnTriggerMergeActionUpdate;
import com.espertech.esper.common.internal.compile.stage1.spec.OnTriggerMergeDesc;
import com.espertech.esper.common.internal.compile.stage1.spec.OnTriggerMergeMatched;
import com.espertech.esper.common.internal.compile.stage1.spec.OnTriggerSetAssignment;
import com.espertech.esper.common.internal.compile.stage1.spec.OnTriggerSetDesc;
import com.espertech.esper.common.internal.compile.stage1.spec.OnTriggerSplitStream;
import com.espertech.esper.common.internal.compile.stage1.spec.OnTriggerSplitStreamDesc;
import com.espertech.esper.common.internal.compile.stage1.spec.OnTriggerWindowUpdateDesc;
import com.espertech.esper.common.internal.compile.stage1.spec.PatternStreamSpecRaw;
import com.espertech.esper.common.internal.compile.stage1.spec.SelectClauseElementRaw;
import com.espertech.esper.common.internal.compile.stage1.spec.SelectClauseExprRawSpec;
import com.espertech.esper.common.internal.compile.stage1.spec.StatementSpecRaw;
import com.espertech.esper.common.internal.compile.stage1.spec.StreamSpecRaw;
import com.espertech.esper.common.internal.compile.stage2.EvalNodeAnalysisResult;
import com.espertech.esper.common.internal.compile.stage2.EvalNodeUtil;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeSubselectDeclaredDotVisitor;
import com.espertech.esper.common.internal.epl.pattern.core.EvalForgeNode;
import com.espertech.esper.common.internal.epl.pattern.filter.EvalFilterForgeNode;
import com.espertech.esper.common.internal.epl.pattern.observer.EvalObserverForgeNode;
import java.util.List;
import java.util.Map;

public class StatementSpecRawWalkerSubselectAndDeclaredDot {
    public static ExprNodeSubselectDeclaredDotVisitor walkSubselectAndDeclaredDotExpr(StatementSpecRaw spec) throws ExprValidationException {
        ExprNodeSubselectDeclaredDotVisitor visitor = new ExprNodeSubselectDeclaredDotVisitor();
        StatementSpecRawWalkerSubselectAndDeclaredDot.walkSubselectAndDeclaredDotExpr(spec, visitor);
        return visitor;
    }

    public static void walkSubselectAndDeclaredDotExpr(StatementSpecRaw spec, ExprNodeSubselectDeclaredDotVisitor visitor) throws ExprValidationException {
        StatementSpecRawWalkerSubselectAndDeclaredDot.walkSubselectSelectClause(spec.getSelectClauseSpec().getSelectExprList(), visitor);
        if (spec.getWhereClause() != null) {
            spec.getWhereClause().accept(visitor);
        }
        if (spec.getHavingClause() != null) {
            spec.getHavingClause().accept(visitor);
        }
        if (spec.getUpdateDesc() != null) {
            if (spec.getUpdateDesc().getOptionalWhereClause() != null) {
                spec.getUpdateDesc().getOptionalWhereClause().accept(visitor);
            }
            for (OnTriggerSetAssignment assignment : spec.getUpdateDesc().getAssignments()) {
                assignment.getExpression().accept(visitor);
            }
        }
        if (spec.getOnTriggerDesc() != null) {
            StatementSpecRawWalkerSubselectAndDeclaredDot.visitSubselectOnTrigger(spec.getOnTriggerDesc(), visitor);
        }
        StatementSpecRawWalkerSubselectAndDeclaredDot.walkStreamSpecs(spec, visitor);
        if (spec.getInsertIntoDesc() != null && spec.getInsertIntoDesc().getEventPrecedence() != null) {
            spec.getInsertIntoDesc().getEventPrecedence().accept(visitor);
        }
        StatementSpecRawWalkerSubselectAndDeclaredDot.walkFAFSpec(spec.getFireAndForgetSpec(), visitor);
        Map<Integer, List<ExprNode>> sqlParams = spec.getSqlParameters();
        if (sqlParams != null) {
            for (Map.Entry<Integer, List<ExprNode>> entry : sqlParams.entrySet()) {
                for (ExprNode node : entry.getValue()) {
                    node.accept(visitor);
                }
            }
        }
    }

    private static void walkFAFSpec(FireAndForgetSpec fireAndForgetSpec, ExprNodeSubselectDeclaredDotVisitor visitor) {
        if (fireAndForgetSpec == null) {
            return;
        }
        if (fireAndForgetSpec instanceof FireAndForgetSpecUpdate) {
            FireAndForgetSpecUpdate update = (FireAndForgetSpecUpdate)fireAndForgetSpec;
            for (OnTriggerSetAssignment onTriggerSetAssignment : update.getAssignments()) {
                onTriggerSetAssignment.getExpression().accept(visitor);
            }
        }
        if (fireAndForgetSpec instanceof FireAndForgetSpecInsert) {
            FireAndForgetSpecInsert insert = (FireAndForgetSpecInsert)fireAndForgetSpec;
            for (List list : insert.getMultirow()) {
                for (ExprNode col : list) {
                    col.accept(visitor);
                }
            }
        }
    }

    public static void walkStreamSpecs(StatementSpecRaw spec, ExprNodeSubselectDeclaredDotVisitor visitor) throws ExprValidationException {
        for (StreamSpecRaw streamSpecRaw : spec.getStreamSpecs()) {
            if (!(streamSpecRaw instanceof PatternStreamSpecRaw)) continue;
            PatternStreamSpecRaw patternStreamSpecRaw = (PatternStreamSpecRaw)streamSpecRaw;
            EvalNodeAnalysisResult analysisResult = EvalNodeUtil.recursiveAnalyzeChildNodes(patternStreamSpecRaw.getEvalForgeNode());
            for (EvalForgeNode evalNode : analysisResult.getActiveNodes()) {
                if (evalNode instanceof EvalFilterForgeNode) {
                    EvalFilterForgeNode filterNode = (EvalFilterForgeNode)evalNode;
                    for (ExprNode filterExpr : filterNode.getRawFilterSpec().getFilterExpressions()) {
                        filterExpr.accept(visitor);
                    }
                    continue;
                }
                if (!(evalNode instanceof EvalObserverForgeNode)) continue;
                int beforeCount = visitor.getSubselects().size();
                EvalObserverForgeNode observerNode = (EvalObserverForgeNode)evalNode;
                for (ExprNode param : observerNode.getPatternObserverSpec().getObjectParameters()) {
                    param.accept(visitor);
                }
                if (visitor.getSubselects().size() == beforeCount) continue;
                throw new ExprValidationException("Subselects are not allowed within pattern observer parameters, please consider using a variable instead");
            }
        }
        for (StreamSpecRaw rawSpec : spec.getStreamSpecs()) {
            if (!(rawSpec instanceof FilterStreamSpecRaw)) continue;
            FilterStreamSpecRaw raw = (FilterStreamSpecRaw)rawSpec;
            for (ExprNode filterExpr : raw.getRawFilterSpec().getFilterExpressions()) {
                filterExpr.accept(visitor);
            }
        }
    }

    private static void visitSubselectOnTrigger(OnTriggerDesc onTriggerDesc, ExprNodeSubselectDeclaredDotVisitor visitor) {
        if (onTriggerDesc instanceof OnTriggerWindowUpdateDesc) {
            OnTriggerWindowUpdateDesc updates = (OnTriggerWindowUpdateDesc)onTriggerDesc;
            for (OnTriggerSetAssignment assignment : updates.getAssignments()) {
                assignment.getExpression().accept(visitor);
            }
        } else if (onTriggerDesc instanceof OnTriggerSetDesc) {
            OnTriggerSetDesc sets = (OnTriggerSetDesc)onTriggerDesc;
            for (OnTriggerSetAssignment assignment : sets.getAssignments()) {
                assignment.getExpression().accept(visitor);
            }
        } else if (onTriggerDesc instanceof OnTriggerSplitStreamDesc) {
            OnTriggerSplitStreamDesc splits = (OnTriggerSplitStreamDesc)onTriggerDesc;
            for (OnTriggerSplitStream split : splits.getSplitStreams()) {
                if (split.getWhereClause() != null) {
                    split.getWhereClause().accept(visitor);
                }
                if (split.getSelectClause().getSelectExprList() != null) {
                    StatementSpecRawWalkerSubselectAndDeclaredDot.walkSubselectSelectClause(split.getSelectClause().getSelectExprList(), visitor);
                }
                if (split.getInsertInto() == null || split.getInsertInto().getEventPrecedence() == null) continue;
                split.getInsertInto().getEventPrecedence().accept(visitor);
            }
        } else if (onTriggerDesc instanceof OnTriggerMergeDesc) {
            OnTriggerMergeDesc merge = (OnTriggerMergeDesc)onTriggerDesc;
            for (OnTriggerMergeMatched matched : merge.getItems()) {
                if (matched.getOptionalMatchCond() != null) {
                    matched.getOptionalMatchCond().accept(visitor);
                }
                for (OnTriggerMergeAction action : matched.getActions()) {
                    if (action.getOptionalWhereClause() != null) {
                        action.getOptionalWhereClause().accept(visitor);
                    }
                    if (action instanceof OnTriggerMergeActionUpdate) {
                        OnTriggerMergeActionUpdate update = (OnTriggerMergeActionUpdate)action;
                        for (OnTriggerSetAssignment assignment : update.getAssignments()) {
                            assignment.getExpression().accept(visitor);
                        }
                    }
                    if (!(action instanceof OnTriggerMergeActionInsert)) continue;
                    StatementSpecRawWalkerSubselectAndDeclaredDot.walkOnMergeActionInsert((OnTriggerMergeActionInsert)action, visitor);
                }
            }
            if (merge.getOptionalInsertNoMatch() != null) {
                StatementSpecRawWalkerSubselectAndDeclaredDot.walkOnMergeActionInsert(merge.getOptionalInsertNoMatch(), visitor);
            }
        }
    }

    private static void walkOnMergeActionInsert(OnTriggerMergeActionInsert action, ExprNodeSubselectDeclaredDotVisitor visitor) {
        StatementSpecRawWalkerSubselectAndDeclaredDot.walkSubselectSelectClause(action.getSelectClause(), visitor);
        if (action.getEventPrecedence() != null) {
            action.getEventPrecedence().accept(visitor);
        }
    }

    private static void walkSubselectSelectClause(List<SelectClauseElementRaw> selectClause, ExprNodeSubselectDeclaredDotVisitor visitor) {
        for (SelectClauseElementRaw element : selectClause) {
            if (!(element instanceof SelectClauseExprRawSpec)) continue;
            SelectClauseExprRawSpec selectExpr = (SelectClauseExprRawSpec)element;
            selectExpr.getSelectExpression().accept(visitor);
        }
    }
}

