/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.variable.core;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.util.NameAccessModifier;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenSymbolProvider;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionField;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbol;
import com.espertech.esper.common.internal.context.module.EPStatementInitServices;
import com.espertech.esper.common.internal.epl.variable.compiletime.VariableMetaData;
import com.espertech.esper.common.internal.epl.variable.core.Variable;
import com.espertech.esper.common.internal.epl.variable.core.VariableReader;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class VariableDeployTimeResolver {
    public static CodegenExpressionField makeVariableField(VariableMetaData variableMetaData, CodegenClassScope classScope, Class generator) {
        SAIFFInitializeSymbol symbols = new SAIFFInitializeSymbol();
        CodegenMethod variableInit = classScope.getPackageScope().getInitMethod().makeChildWithScope(Variable.EPTYPE, generator, (CodegenSymbolProvider)symbols, (CodegenScope)classScope).addParam(EPStatementInitServices.EPTYPE, EPStatementInitServices.REF.getRef());
        variableInit.getBlock().methodReturn(VariableDeployTimeResolver.makeResolveVariable(variableMetaData, EPStatementInitServices.REF));
        return classScope.getPackageScope().addFieldUnshared(true, Variable.EPTYPE, CodegenExpressionBuilder.localMethod(variableInit, EPStatementInitServices.REF));
    }

    public static CodegenExpression makeResolveVariable(VariableMetaData variable, CodegenExpression initSvc) {
        return CodegenExpressionBuilder.staticMethod(VariableDeployTimeResolver.class, "resolveVariable", CodegenExpressionBuilder.constant(variable.getVariableName()), CodegenExpressionBuilder.constant((Object)variable.getVariableVisibility()), CodegenExpressionBuilder.constant(variable.getVariableModuleName()), initSvc);
    }

    public static CodegenExpression makeResolveVariables(Collection<VariableMetaData> variables, CodegenExpression initSvc) {
        CodegenExpression[] expressions = new CodegenExpression[variables.size()];
        int count = 0;
        for (VariableMetaData variable : variables) {
            expressions[count++] = VariableDeployTimeResolver.makeResolveVariable(variable, initSvc);
        }
        return CodegenExpressionBuilder.newArrayWithInit(Variable.EPTYPE, expressions);
    }

    public static Variable resolveVariable(String variableName, NameAccessModifier visibility, String optionalModuleName, EPStatementInitServices services) {
        String deploymentId = VariableDeployTimeResolver.resolveDeploymentId(variableName, visibility, optionalModuleName, services);
        Variable variable = services.getVariableManagementService().getVariableMetaData(deploymentId, variableName);
        if (variable == null) {
            throw new EPException("Failed to resolve variable '" + variableName + "'");
        }
        return variable;
    }

    public static VariableReader resolveVariableReader(String variableName, NameAccessModifier visibility, String optionalModuleName, String optionalContextName, EPStatementInitServices services) {
        if (optionalContextName != null) {
            throw new IllegalArgumentException("Expected null context name");
        }
        String deploymentId = VariableDeployTimeResolver.resolveDeploymentId(variableName, visibility, optionalModuleName, services);
        VariableReader reader = services.getVariableManagementService().getReader(deploymentId, variableName, -1);
        if (reader == null) {
            throw new EPException("Failed to resolve variable '" + variableName + "'");
        }
        return reader;
    }

    public static Map<Integer, VariableReader> resolveVariableReaderPerCP(String variableName, NameAccessModifier visibility, String optionalModuleName, String optionalContextName, EPStatementInitServices services) {
        if (optionalContextName == null) {
            throw new IllegalArgumentException("No context name");
        }
        String deploymentId = VariableDeployTimeResolver.resolveDeploymentId(variableName, visibility, optionalModuleName, services);
        ConcurrentHashMap<Integer, VariableReader> reader = services.getVariableManagementService().getReadersPerCP(deploymentId, variableName);
        if (reader == null) {
            throw new EPException("Failed to resolve variable '" + variableName + "'");
        }
        return reader;
    }

    private static String resolveDeploymentId(String variableName, NameAccessModifier visibility, String optionalModuleName, EPStatementInitServices services) {
        String deploymentId;
        if (visibility == NameAccessModifier.PRECONFIGURED) {
            deploymentId = null;
        } else if (visibility == NameAccessModifier.PRIVATE) {
            deploymentId = services.getDeploymentId();
        } else if (visibility == NameAccessModifier.PUBLIC) {
            deploymentId = services.getVariablePathRegistry().getDeploymentId(variableName, optionalModuleName);
            if (deploymentId == null) {
                throw new EPException("Failed to resolve path variable '" + variableName + "'");
            }
        } else {
            throw new IllegalArgumentException("Unrecognized visibility " + (Object)((Object)visibility));
        }
        return deploymentId;
    }
}

