/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.variable.core;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.serde.DataInputOutputSerde;
import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.variable.VariableValueException;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.epl.variable.compiletime.VariableMetaData;
import com.espertech.esper.common.internal.epl.variable.core.Variable;
import com.espertech.esper.common.internal.epl.variable.core.VariableChangeCallback;
import com.espertech.esper.common.internal.epl.variable.core.VariableDeployment;
import com.espertech.esper.common.internal.epl.variable.core.VariableManagementService;
import com.espertech.esper.common.internal.epl.variable.core.VariableReader;
import com.espertech.esper.common.internal.epl.variable.core.VariableStateNonConstHandler;
import com.espertech.esper.common.internal.epl.variable.core.VariableUtil;
import com.espertech.esper.common.internal.epl.variable.core.VariableVersionThreadEntry;
import com.espertech.esper.common.internal.epl.variable.core.VariableVersionThreadLocal;
import com.espertech.esper.common.internal.epl.variable.core.VersionedValueList;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import com.espertech.esper.common.internal.schedule.TimeProvider;
import com.espertech.esper.common.internal.util.ClassHelperGenericType;
import com.espertech.esper.common.internal.util.DeploymentIdNamePair;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import com.espertech.esper.common.internal.util.NullableObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VariableManagementServiceImpl
implements VariableManagementService {
    private static final Logger log = LoggerFactory.getLogger(VariableManagementServiceImpl.class);
    protected static final int ROLLOVER_READER_BOUNDARY = 2147383647;
    protected static final int HIGH_WATERMARK_VERSIONS = 50;
    private final ArrayList<ConcurrentHashMap<Integer, VariableReader>> variableVersionsPerCP;
    private final ArrayList<Map<Integer, Set<VariableChangeCallback>>> changeCallbacksPerCP;
    private final Map<String, VariableDeployment> deploymentsWithVariables;
    private final ReadWriteLock readWriteLock;
    private VariableVersionThreadLocal versionThreadLocal = new VariableVersionThreadLocal();
    private final long millisecondLifetimeOldVersions;
    private final TimeProvider timeProvider;
    private final EventBeanTypedEventFactory eventBeanTypedEventFactory;
    private final VariableStateNonConstHandler optionalStateHandler;
    private volatile int currentVersionNumber;
    private int currentVariableNumber;

    public VariableManagementServiceImpl(long millisecondLifetimeOldVersions, TimeProvider timeProvider, EventBeanTypedEventFactory eventBeanTypedEventFactory, VariableStateNonConstHandler optionalStateHandler) {
        this(0, millisecondLifetimeOldVersions, timeProvider, eventBeanTypedEventFactory, optionalStateHandler);
    }

    protected VariableManagementServiceImpl(int startVersion, long millisecondLifetimeOldVersions, TimeProvider timeProvider, EventBeanTypedEventFactory eventBeanTypedEventFactory, VariableStateNonConstHandler optionalStateHandler) {
        this.millisecondLifetimeOldVersions = millisecondLifetimeOldVersions;
        this.timeProvider = timeProvider;
        this.eventBeanTypedEventFactory = eventBeanTypedEventFactory;
        this.optionalStateHandler = optionalStateHandler;
        this.deploymentsWithVariables = new HashMap<String, VariableDeployment>();
        this.readWriteLock = new ReentrantReadWriteLock();
        this.variableVersionsPerCP = new ArrayList();
        this.changeCallbacksPerCP = new ArrayList();
        this.currentVersionNumber = startVersion;
    }

    @Override
    public void destroy() {
        this.versionThreadLocal = new VariableVersionThreadLocal();
    }

    @Override
    public synchronized void removeVariableIfFound(String deploymentId, String variableName) {
        VariableDeployment entry = this.deploymentsWithVariables.get(deploymentId);
        if (entry == null) {
            return;
        }
        Variable variable = entry.getVariable(variableName);
        if (variable == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Removing variable '" + variableName + "'");
        }
        entry.remove(variableName);
        if (this.optionalStateHandler != null && !variable.getMetaData().isConstant()) {
            ConcurrentHashMap<Integer, VariableReader> readers = this.variableVersionsPerCP.get(variable.getVariableNumber());
            Set cps = Collections.emptySet();
            if (readers != null) {
                cps = readers.keySet();
            }
            this.optionalStateHandler.removeVariable(variable, deploymentId, cps);
        }
        int number = variable.getVariableNumber();
        this.variableVersionsPerCP.set(number, null);
        this.changeCallbacksPerCP.set(number, null);
    }

    @Override
    public void setLocalVersion() {
        this.versionThreadLocal.getCurrentThread().setVersion(this.currentVersionNumber);
    }

    @Override
    public void registerCallback(String deploymentId, String variableName, int agentInstanceId, VariableChangeCallback variableChangeCallback) {
        Set<VariableChangeCallback> callbacks;
        VariableDeployment entry = this.deploymentsWithVariables.get(deploymentId);
        if (entry == null) {
            return;
        }
        Variable variable = entry.getVariable(variableName);
        if (variable == null) {
            return;
        }
        Map<Integer, Set<VariableChangeCallback>> cps = this.changeCallbacksPerCP.get(variable.getVariableNumber());
        if (cps == null) {
            cps = new HashMap<Integer, Set<VariableChangeCallback>>();
            this.changeCallbacksPerCP.set(variable.getVariableNumber(), cps);
        }
        if (variable.getMetaData().getOptionalContextName() == null) {
            agentInstanceId = -1;
        }
        if ((callbacks = cps.get(agentInstanceId)) == null) {
            callbacks = new CopyOnWriteArraySet<VariableChangeCallback>();
            cps.put(agentInstanceId, callbacks);
        }
        callbacks.add(variableChangeCallback);
    }

    @Override
    public void unregisterCallback(String deploymentId, String variableName, int agentInstanceId, VariableChangeCallback variableChangeCallback) {
        Set<VariableChangeCallback> callbacks;
        VariableDeployment entry = this.deploymentsWithVariables.get(deploymentId);
        if (entry == null) {
            return;
        }
        Variable variable = entry.getVariable(variableName);
        if (variable == null) {
            return;
        }
        Map<Integer, Set<VariableChangeCallback>> cps = this.changeCallbacksPerCP.get(variable.getVariableNumber());
        if (cps == null) {
            return;
        }
        if (variable.getMetaData().getOptionalContextName() == null) {
            agentInstanceId = 0;
        }
        if ((callbacks = cps.get(agentInstanceId)) != null) {
            callbacks.remove(variableChangeCallback);
        }
    }

    @Override
    public synchronized void addVariable(String deploymentId, VariableMetaData metaData, String optionalDeploymentIdContext, DataInputOutputSerde optionalSerde) {
        int variableNumber;
        VariableDeployment deploymentEntry = this.deploymentsWithVariables.get(deploymentId);
        if (deploymentEntry != null) {
            Variable variable = deploymentEntry.getVariable(metaData.getVariableName());
            if (variable != null) {
                throw new IllegalArgumentException("Variable already exists by name '" + metaData.getVariableName() + "' and deployment '" + deploymentId + "'");
            }
        } else {
            deploymentEntry = new VariableDeployment();
            this.deploymentsWithVariables.put(deploymentId, deploymentEntry);
        }
        int emptySpot = -1;
        int count = 0;
        for (Map map : this.variableVersionsPerCP) {
            if (map == null) {
                emptySpot = count;
                break;
            }
            ++count;
        }
        if (emptySpot != -1) {
            variableNumber = emptySpot;
            this.variableVersionsPerCP.set(emptySpot, new ConcurrentHashMap());
            this.changeCallbacksPerCP.set(emptySpot, null);
        } else {
            variableNumber = this.currentVariableNumber++;
            this.variableVersionsPerCP.add(new ConcurrentHashMap());
            this.changeCallbacksPerCP.add(null);
        }
        Variable variable = new Variable(variableNumber, deploymentId, metaData, optionalDeploymentIdContext);
        deploymentEntry.addVariable(metaData.getVariableName(), variable);
        if (this.optionalStateHandler != null && !metaData.isConstant()) {
            this.optionalStateHandler.addVariable(deploymentId, metaData.getVariableName(), variable, optionalSerde);
        }
    }

    @Override
    public void allocateVariableState(String deploymentId, String variableName, int agentInstanceId, boolean recovery, NullableObject<Object> initialValue, EventBeanTypedEventFactory eventBeanTypedEventFactory) {
        VariableDeployment entry = this.deploymentsWithVariables.get(deploymentId);
        if (entry == null) {
            throw new IllegalArgumentException("Failed to find variable deployment id '" + deploymentId + "'");
        }
        Variable variable = entry.getVariable(variableName);
        if (variable == null) {
            throw new IllegalArgumentException("Failed to find variable '" + variableName + "'");
        }
        Object initialState = initialValue != null ? initialValue.getObject() : variable.getMetaData().getValueWhenAvailable();
        if (variable.getMetaData().getEventType() != null && initialState != null && !(initialState instanceof EventBean)) {
            initialState = eventBeanTypedEventFactory.adapterForTypedBean(initialState, variable.getMetaData().getEventType());
        }
        if (this.optionalStateHandler != null && !variable.getMetaData().isConstant()) {
            NullableObject<Object> priorValue = this.optionalStateHandler.getHasState(variable, agentInstanceId);
            if (recovery) {
                if (priorValue != null) {
                    initialState = priorValue.getObject();
                }
            } else if (priorValue == null) {
                this.optionalStateHandler.setState(variable, agentInstanceId, initialState);
            } else {
                initialState = priorValue.getObject();
            }
        }
        long timestamp = this.timeProvider.getTime();
        VersionedValueList<Object> valuePerVersion = new VersionedValueList<Object>(variableName, this.currentVersionNumber, initialState, timestamp, this.millisecondLifetimeOldVersions, this.readWriteLock.readLock(), 50, false);
        Map cps = this.variableVersionsPerCP.get(variable.getVariableNumber());
        VariableReader reader = new VariableReader(variable, this.versionThreadLocal, valuePerVersion);
        cps.put(agentInstanceId, reader);
    }

    @Override
    public void deallocateVariableState(String deploymentId, String variableName, int agentInstanceId) {
        VariableDeployment entry = this.deploymentsWithVariables.get(deploymentId);
        if (entry == null) {
            throw new IllegalArgumentException("Failed to find variable deployment id '" + deploymentId + "'");
        }
        Variable variable = entry.getVariable(variableName);
        if (variable == null) {
            throw new IllegalArgumentException("Failed to find variable '" + variableName + "'");
        }
        Map cps = this.variableVersionsPerCP.get(variable.getVariableNumber());
        cps.remove(agentInstanceId);
        if (this.optionalStateHandler != null && !variable.getMetaData().isConstant()) {
            this.optionalStateHandler.removeState(variable, agentInstanceId);
        }
    }

    @Override
    public Variable getVariableMetaData(String deploymentId, String variableName) {
        VariableDeployment entry = this.deploymentsWithVariables.get(deploymentId);
        if (entry == null) {
            return null;
        }
        return entry.getVariable(variableName);
    }

    @Override
    public VariableReader getReader(String deploymentId, String variableName, int agentInstanceIdAccessor) {
        VariableDeployment entry = this.deploymentsWithVariables.get(deploymentId);
        if (entry == null) {
            return null;
        }
        Variable variable = entry.getVariable(variableName);
        if (variable == null) {
            return null;
        }
        Map cps = this.variableVersionsPerCP.get(variable.getVariableNumber());
        if (variable.getMetaData().getOptionalContextName() == null) {
            return (VariableReader)cps.get(-1);
        }
        return (VariableReader)cps.get(agentInstanceIdAccessor);
    }

    @Override
    public void write(int variableNumber, int agentInstanceId, Object newValue) {
        VariableVersionThreadEntry entry = this.versionThreadLocal.getCurrentThread();
        if (entry.getUncommitted() == null) {
            entry.setUncommitted(new HashMap<Integer, Pair<Integer, Object>>());
        }
        entry.getUncommitted().put(variableNumber, new Pair<Integer, Object>(agentInstanceId, newValue));
    }

    @Override
    public ReadWriteLock getReadWriteLock() {
        return this.readWriteLock;
    }

    @Override
    public void commit() {
        VariableVersionThreadEntry entry = this.versionThreadLocal.getCurrentThread();
        if (entry.getUncommitted() == null) {
            return;
        }
        int newVersion = this.currentVersionNumber + 1;
        if (this.currentVersionNumber == 2147383647) {
            this.rollOver();
            newVersion = 2;
        }
        long timestamp = this.timeProvider.getTime();
        for (Map.Entry<Integer, Pair<Integer, Object>> uncommittedEntry : entry.getUncommitted().entrySet()) {
            VariableMetaData metaData;
            Set<VariableChangeCallback> callbacks;
            Map cps = this.variableVersionsPerCP.get(uncommittedEntry.getKey());
            VariableReader reader = (VariableReader)cps.get(uncommittedEntry.getValue().getFirst());
            VersionedValueList<Object> versions = reader.getVersionsLow();
            Object newValue = uncommittedEntry.getValue().getSecond();
            Object oldValue = versions.addValue(newVersion, newValue, timestamp);
            Map<Integer, Set<VariableChangeCallback>> cpsCallback = this.changeCallbacksPerCP.get(uncommittedEntry.getKey());
            if (cpsCallback != null && (callbacks = cpsCallback.get(uncommittedEntry.getValue().getFirst())) != null) {
                for (VariableChangeCallback callback : callbacks) {
                    callback.update(newValue, oldValue);
                }
            }
            if (this.optionalStateHandler == null || (metaData = reader.getMetaData()).isConstant()) continue;
            int agentInstanceId = metaData.getOptionalContextName() == null ? -1 : uncommittedEntry.getValue().getFirst();
            this.optionalStateHandler.setState(reader.getVariable(), agentInstanceId, newValue);
        }
        this.currentVersionNumber = newVersion;
        entry.setUncommitted(null);
    }

    @Override
    public void rollback() {
        VariableVersionThreadEntry entry = this.versionThreadLocal.getCurrentThread();
        entry.setUncommitted(null);
    }

    private void rollOver() {
        for (Map map : this.variableVersionsPerCP) {
            for (Map.Entry entry : map.entrySet()) {
                String name = ((VariableReader)entry.getValue()).getMetaData().getVariableName();
                long timestamp = this.timeProvider.getTime();
                VersionedValueList<Object> versionsOld = ((VariableReader)entry.getValue()).getVersionsLow();
                Object currentValue = versionsOld.getCurrentAndPriorValue().getCurrentVersion().getValue();
                VersionedValueList<Object> versionsNew = new VersionedValueList<Object>(name, 1, currentValue, timestamp, this.millisecondLifetimeOldVersions, this.readWriteLock.readLock(), 50, false);
                ((VariableReader)entry.getValue()).setVersionsHigh(versionsOld);
                ((VariableReader)entry.getValue()).setVersionsLow(versionsNew);
            }
        }
    }

    @Override
    public void checkAndWrite(String deploymentId, String variableName, int agentInstanceId, Object newValue) throws VariableValueException {
        VariableDeployment entry = this.deploymentsWithVariables.get(deploymentId);
        if (entry == null) {
            throw new IllegalArgumentException("Failed to find variable deployment id '" + deploymentId + "'");
        }
        Variable variable = entry.getVariable(variableName);
        int variableNumber = variable.getVariableNumber();
        if (newValue == null) {
            this.write(variableNumber, agentInstanceId, null);
            return;
        }
        EPTypeClass valueType = ClassHelperGenericType.getClassEPType(newValue.getClass());
        if (variable.getMetaData().getEventType() != null) {
            if (!JavaClassHelper.isSubclassOrImplementsInterface(newValue.getClass(), variable.getMetaData().getEventType().getUnderlyingType())) {
                throw new VariableValueException("Variable '" + variableName + "' of declared event type '" + variable.getMetaData().getEventType().getName() + "' underlying type '" + variable.getMetaData().getEventType().getUnderlyingType().getName() + "' cannot be assigned a value of type '" + valueType.getTypeName() + "'");
            }
            EventBean eventBean = this.eventBeanTypedEventFactory.adapterForTypedBean(newValue, variable.getMetaData().getEventType());
            this.write(variableNumber, agentInstanceId, eventBean);
            return;
        }
        EPTypeClass variableType = variable.getMetaData().getType();
        if (valueType.equals(variableType) || variableType.getType() == Object.class) {
            this.write(variableNumber, agentInstanceId, newValue);
            return;
        }
        if (JavaClassHelper.isSubclassOrImplementsInterface((EPType)valueType, variableType.getType())) {
            this.write(variableNumber, agentInstanceId, newValue);
            return;
        }
        if (!JavaClassHelper.isNumeric(variableType) || !JavaClassHelper.isNumeric(valueType)) {
            throw new VariableValueException(VariableUtil.getAssigmentExMessage(variableName, variableType, valueType));
        }
        if (!JavaClassHelper.canCoerce(valueType.getType(), variableType.getType())) {
            throw new VariableValueException(VariableUtil.getAssigmentExMessage(variableName, variableType, valueType));
        }
        Number valueCoerced = JavaClassHelper.coerceBoxed((Number)newValue, variableType.getType());
        this.write(variableNumber, agentInstanceId, valueCoerced);
    }

    @Override
    public ConcurrentHashMap<Integer, VariableReader> getReadersPerCP(String deploymentId, String variableName) {
        VariableDeployment entry = this.deploymentsWithVariables.get(deploymentId);
        if (entry == null) {
            throw new IllegalArgumentException("Failed to find variable deployment id '" + deploymentId + "'");
        }
        Variable variable = entry.getVariable(variableName);
        return this.variableVersionsPerCP.get(variable.getVariableNumber());
    }

    @Override
    public Map<DeploymentIdNamePair, VariableReader> getVariableReadersNonCP() {
        HashMap<DeploymentIdNamePair, VariableReader> result = new HashMap<DeploymentIdNamePair, VariableReader>();
        for (Map.Entry<String, VariableDeployment> deployment : this.deploymentsWithVariables.entrySet()) {
            for (Map.Entry<String, Variable> variable : deployment.getValue().getVariables().entrySet()) {
                int variableNum = variable.getValue().getVariableNumber();
                if (variable.getValue().getMetaData().getOptionalContextName() != null) continue;
                for (Map.Entry<Integer, VariableReader> entry : this.variableVersionsPerCP.get(variableNum).entrySet()) {
                    result.put(new DeploymentIdNamePair(deployment.getKey(), variable.getKey()), entry.getValue());
                }
            }
        }
        return result;
    }

    @Override
    public VariableStateNonConstHandler getOptionalStateHandler() {
        return this.optionalStateHandler;
    }

    @Override
    public Map<String, VariableDeployment> getDeploymentsWithVariables() {
        return this.deploymentsWithVariables;
    }

    @Override
    public void traverseVariables(BiConsumer<String, Variable> consumer) {
        for (Map.Entry<String, VariableDeployment> entry : this.deploymentsWithVariables.entrySet()) {
            for (Map.Entry<String, Variable> variable : entry.getValue().getVariables().entrySet()) {
                consumer.accept(entry.getKey(), variable.getValue());
            }
        }
    }
}

