/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.virtualdw;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.hook.vdw.VirtualDataWindowKeyRange;
import com.espertech.esper.common.client.hook.vdw.VirtualDataWindowLookup;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValueEntryRange;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValueEntryRangeIn;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValueEntryRangeRelOp;
import com.espertech.esper.common.internal.epl.lookup.LookupStrategyDesc;
import com.espertech.esper.common.internal.epl.lookup.LookupStrategyType;
import com.espertech.esper.common.internal.epl.lookup.SubordTableLookupStrategy;
import com.espertech.esper.common.internal.epl.virtualdw.SubordTableLookupStrategyFactoryVDW;
import com.espertech.esper.common.internal.epl.virtualdw.VirtualDWViewFactory;
import com.espertech.esper.common.internal.event.core.EventBeanUtility;
import java.util.Collection;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubordTableLookupStrategyVDW
implements SubordTableLookupStrategy {
    private static final Logger log = LoggerFactory.getLogger(SubordTableLookupStrategyVDW.class);
    private final VirtualDWViewFactory factory;
    private final VirtualDataWindowLookup externalIndex;
    private final ExternalEvaluator[] evaluators;
    private final boolean nwOnTrigger;
    private final EventBean[] eventsLocal;

    public SubordTableLookupStrategyVDW(VirtualDWViewFactory factory, SubordTableLookupStrategyFactoryVDW subordTableFactory, VirtualDataWindowLookup externalIndex) {
        this.factory = factory;
        this.externalIndex = externalIndex;
        this.nwOnTrigger = subordTableFactory.isNwOnTrigger();
        ExprEvaluator[] hashKeys = subordTableFactory.getHashEvals();
        EPTypeClass[] hashCoercionTypes = subordTableFactory.getHashCoercionTypes();
        QueryGraphValueEntryRange[] rangeKeys = subordTableFactory.getRangeEvals();
        EPTypeClass[] rangeCoercionTypes = subordTableFactory.getRangeCoercionTypes();
        this.evaluators = new ExternalEvaluator[hashKeys.length + rangeKeys.length];
        this.eventsLocal = new EventBean[subordTableFactory.getNumOuterStreams() + 1];
        int count = 0;
        for (ExprEvaluator hashKey : hashKeys) {
            this.evaluators[count] = new ExternalEvaluatorHashRelOp(hashKeys[count], hashCoercionTypes[count]);
            ++count;
        }
        for (int i = 0; i < rangeKeys.length; ++i) {
            QueryGraphValueEntryRange rangeKey = rangeKeys[i];
            if (rangeKey.getType().isRange()) {
                QueryGraphValueEntryRangeIn range = (QueryGraphValueEntryRangeIn)rangeKey;
                ExprEvaluator evaluatorStart = range.getExprStart();
                ExprEvaluator evaluatorEnd = range.getExprEnd();
                this.evaluators[count] = new ExternalEvaluatorBtreeRange(evaluatorStart, evaluatorEnd, rangeCoercionTypes[i]);
            } else {
                QueryGraphValueEntryRangeRelOp relOp = (QueryGraphValueEntryRangeRelOp)rangeKey;
                ExprEvaluator evaluator = relOp.getExpression();
                this.evaluators[count] = new ExternalEvaluatorHashRelOp(evaluator, rangeCoercionTypes[i]);
            }
            ++count;
        }
    }

    @Override
    public Collection<EventBean> lookup(EventBean[] eventsPerStream, ExprEvaluatorContext context) {
        EventBean[] events;
        if (this.nwOnTrigger) {
            events = eventsPerStream;
        } else {
            System.arraycopy(eventsPerStream, 0, this.eventsLocal, 1, eventsPerStream.length);
            events = this.eventsLocal;
        }
        Object[] keys = new Object[this.evaluators.length];
        for (int i = 0; i < this.evaluators.length; ++i) {
            keys[i] = this.evaluators[i].evaluate(events, context);
        }
        Set<EventBean> data = null;
        try {
            data = this.externalIndex.lookup(keys, eventsPerStream);
        }
        catch (RuntimeException ex) {
            log.warn("Exception encountered invoking virtual data window external index for window '" + this.factory.getNamedWindowName() + "': " + ex.getMessage(), (Throwable)ex);
        }
        return data;
    }

    @Override
    public String toQueryPlan() {
        return this.getClass().getSimpleName() + " external index " + this.externalIndex;
    }

    @Override
    public LookupStrategyDesc getStrategyDesc() {
        return new LookupStrategyDesc(LookupStrategyType.VDW);
    }

    private static class ExternalEvaluatorBtreeRange
    implements ExternalEvaluator {
        private final ExprEvaluator startEval;
        private final ExprEvaluator endEval;
        private final EPTypeClass coercionType;

        private ExternalEvaluatorBtreeRange(ExprEvaluator startEval, ExprEvaluator endEval, EPTypeClass coercionType) {
            this.startEval = startEval;
            this.endEval = endEval;
            this.coercionType = coercionType;
        }

        @Override
        public Object evaluate(EventBean[] events, ExprEvaluatorContext context) {
            Object start = EventBeanUtility.coerce(this.startEval.evaluate(events, true, context), this.coercionType);
            Object end = EventBeanUtility.coerce(this.endEval.evaluate(events, true, context), this.coercionType);
            return new VirtualDataWindowKeyRange(start, end);
        }
    }

    private static class ExternalEvaluatorHashRelOp
    implements ExternalEvaluator {
        private final ExprEvaluator hashKeysEval;
        private final EPTypeClass coercionType;

        private ExternalEvaluatorHashRelOp(ExprEvaluator hashKeysEval, EPTypeClass coercionType) {
            this.hashKeysEval = hashKeysEval;
            this.coercionType = coercionType;
        }

        @Override
        public Object evaluate(EventBean[] events, ExprEvaluatorContext context) {
            return EventBeanUtility.coerce(this.hashKeysEval.evaluate(events, true, context), this.coercionType);
        }
    }

    private static interface ExternalEvaluator {
        public Object evaluate(EventBean[] var1, ExprEvaluatorContext var2);
    }
}

