/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.arr;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventPropertyDescriptor;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.meta.EventTypeMetadata;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.event.arr.EventTypeNestableGetterFactoryObjectArray;
import com.espertech.esper.common.internal.event.arr.ObjectArrayEventBeanCopyMethodForge;
import com.espertech.esper.common.internal.event.arr.ObjectArrayEventBeanCopyMethodWithArrayMapForge;
import com.espertech.esper.common.internal.event.arr.ObjectArrayEventBeanPropertyWriter;
import com.espertech.esper.common.internal.event.arr.ObjectArrayEventBeanPropertyWriterIndexedProp;
import com.espertech.esper.common.internal.event.arr.ObjectArrayEventBeanPropertyWriterMapProp;
import com.espertech.esper.common.internal.event.arr.ObjectArrayEventBeanWriterPerProp;
import com.espertech.esper.common.internal.event.arr.ObjectArrayEventBeanWriterSimpleProps;
import com.espertech.esper.common.internal.event.bean.service.BeanEventTypeFactory;
import com.espertech.esper.common.internal.event.core.BaseNestableEventType;
import com.espertech.esper.common.internal.event.core.BaseNestableEventUtil;
import com.espertech.esper.common.internal.event.core.EventBeanCopyMethodForge;
import com.espertech.esper.common.internal.event.core.EventBeanWriter;
import com.espertech.esper.common.internal.event.core.EventTypeNestableGetterFactory;
import com.espertech.esper.common.internal.event.property.IndexedProperty;
import com.espertech.esper.common.internal.event.property.MappedProperty;
import com.espertech.esper.common.internal.event.property.Property;
import com.espertech.esper.common.internal.event.property.PropertyParser;
import com.espertech.esper.common.internal.util.CollectionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ObjectArrayEventType
extends BaseNestableEventType {
    public static final EPTypeClass EPTYPE = new EPTypeClass(ObjectArrayEventType.class);
    protected Map<String, Pair<EventPropertyDescriptor, ObjectArrayEventBeanPropertyWriter>> propertyWriters;
    protected EventPropertyDescriptor[] writablePropertyDescriptors;

    public ObjectArrayEventType(EventTypeMetadata metadata, Map<String, Object> properyTypes, EventType[] optionalSuperTypes, Set<EventType> optionalDeepSupertypes, String startTimestampName, String endTimestampName, BeanEventTypeFactory beanEventTypeFactory) {
        super(metadata, properyTypes, optionalSuperTypes, optionalDeepSupertypes, startTimestampName, endTimestampName, ObjectArrayEventType.getGetterFactory(metadata.getName(), properyTypes, optionalSuperTypes), beanEventTypeFactory, false);
    }

    public Map<String, Integer> getPropertiesIndexes() {
        return ((EventTypeNestableGetterFactoryObjectArray)this.getterFactory).getPropertiesIndex();
    }

    @Override
    public final Class getUnderlyingType() {
        return Object[].class;
    }

    @Override
    public EPTypeClass getUnderlyingEPType() {
        return EPTypePremade.OBJECTARRAY.getEPType();
    }

    @Override
    public EventBeanCopyMethodForge getCopyMethodForge(String[] properties) {
        BaseNestableEventUtil.MapIndexedPropPair pair = BaseNestableEventUtil.getIndexedAndMappedProps(properties);
        if (pair.getMapProperties().isEmpty() && pair.getArrayProperties().isEmpty()) {
            return new ObjectArrayEventBeanCopyMethodForge(this, this.beanEventTypeFactory.getEventBeanTypedEventFactory());
        }
        return new ObjectArrayEventBeanCopyMethodWithArrayMapForge(this, pair.getMapProperties(), pair.getArrayProperties(), this.getPropertiesIndexes());
    }

    @Override
    public ObjectArrayEventBeanPropertyWriter getWriter(String propertyName) {
        Pair<EventPropertyDescriptor, ObjectArrayEventBeanPropertyWriter> pair;
        if (this.writablePropertyDescriptors == null) {
            this.initializeWriters();
        }
        if ((pair = this.propertyWriters.get(propertyName)) != null) {
            return pair.getSecond();
        }
        Property property = PropertyParser.parseAndWalkLaxToSimple(propertyName);
        if (property instanceof MappedProperty) {
            MappedProperty mapProp = (MappedProperty)property;
            Integer index = this.getPropertiesIndexes().get(mapProp.getPropertyNameAtomic());
            if (index == null) {
                return null;
            }
            return new ObjectArrayEventBeanPropertyWriterMapProp(index, mapProp.getKey());
        }
        if (property instanceof IndexedProperty) {
            IndexedProperty indexedProp = (IndexedProperty)property;
            Integer index = this.getPropertiesIndexes().get(indexedProp.getPropertyNameAtomic());
            if (index == null) {
                return null;
            }
            return new ObjectArrayEventBeanPropertyWriterIndexedProp(index, indexedProp.getIndex());
        }
        return null;
    }

    @Override
    public EventPropertyDescriptor getWritableProperty(String propertyName) {
        Pair<EventPropertyDescriptor, ObjectArrayEventBeanPropertyWriter> pair;
        if (this.writablePropertyDescriptors == null) {
            this.initializeWriters();
        }
        if ((pair = this.propertyWriters.get(propertyName)) != null) {
            return pair.getFirst();
        }
        Property property = PropertyParser.parseAndWalkLaxToSimple(propertyName);
        if (property instanceof MappedProperty) {
            ObjectArrayEventBeanPropertyWriter writer = this.getWriter(propertyName);
            if (writer == null) {
                return null;
            }
            MappedProperty mapProp = (MappedProperty)property;
            return new EventPropertyDescriptor(mapProp.getPropertyNameAtomic(), EPTypePremade.OBJECT.getEPType(), false, true, false, true, false);
        }
        if (property instanceof IndexedProperty) {
            ObjectArrayEventBeanPropertyWriter writer = this.getWriter(propertyName);
            if (writer == null) {
                return null;
            }
            IndexedProperty indexedProp = (IndexedProperty)property;
            return new EventPropertyDescriptor(indexedProp.getPropertyNameAtomic(), EPTypePremade.OBJECT.getEPType(), true, false, true, false, false);
        }
        return null;
    }

    @Override
    public EventPropertyDescriptor[] getWriteableProperties() {
        if (this.writablePropertyDescriptors == null) {
            this.initializeWriters();
        }
        return this.writablePropertyDescriptors;
    }

    @Override
    public EventBeanWriter getWriter(String[] properties) {
        if (this.writablePropertyDescriptors == null) {
            this.initializeWriters();
        }
        boolean allSimpleProps = true;
        ObjectArrayEventBeanPropertyWriter[] writers = new ObjectArrayEventBeanPropertyWriter[properties.length];
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        Map<String, Integer> indexesPerProperty = this.getPropertiesIndexes();
        for (int i = 0; i < properties.length; ++i) {
            Pair<EventPropertyDescriptor, ObjectArrayEventBeanPropertyWriter> writerPair = this.propertyWriters.get(properties[i]);
            if (writerPair != null) {
                writers[i] = writerPair.getSecond();
                indexes.add(indexesPerProperty.get(writerPair.getFirst().getPropertyName()));
                continue;
            }
            writers[i] = this.getWriter(properties[i]);
            if (writers[i] == null) {
                return null;
            }
            allSimpleProps = false;
        }
        if (allSimpleProps) {
            int[] propertyIndexes = CollectionUtil.intArray(indexes);
            return new ObjectArrayEventBeanWriterSimpleProps(propertyIndexes);
        }
        return new ObjectArrayEventBeanWriterPerProp(writers);
    }

    public static Object[] convertEvent(EventBean theEvent, ObjectArrayEventType targetType) {
        Map<String, Integer> indexesTarget = targetType.getPropertiesIndexes();
        Map<String, Integer> indexesSource = ((ObjectArrayEventType)theEvent.getEventType()).getPropertiesIndexes();
        Object[] dataTarget = new Object[indexesTarget.size()];
        Object[] dataSource = (Object[])theEvent.getUnderlying();
        for (Map.Entry<String, Integer> sourceEntry : indexesSource.entrySet()) {
            Object value;
            String propertyName = sourceEntry.getKey();
            Integer targetIndex = indexesTarget.get(propertyName);
            if (targetIndex == null) continue;
            dataTarget[targetIndex.intValue()] = value = dataSource[sourceEntry.getValue()];
        }
        return dataTarget;
    }

    public boolean isDeepEqualsConsiderOrder(ObjectArrayEventType other) {
        EventTypeNestableGetterFactoryObjectArray factoryOther = (EventTypeNestableGetterFactoryObjectArray)other.getterFactory;
        EventTypeNestableGetterFactoryObjectArray factoryMe = (EventTypeNestableGetterFactoryObjectArray)this.getterFactory;
        if (factoryOther.getPropertiesIndex().size() != factoryMe.getPropertiesIndex().size()) {
            return false;
        }
        for (Map.Entry<String, Integer> propMeEntry : factoryMe.getPropertiesIndex().entrySet()) {
            Object setTwoType;
            boolean setOneTypeFound;
            Object setOneType;
            Integer otherIndex = factoryOther.getPropertiesIndex().get(propMeEntry.getKey());
            if (otherIndex == null || !otherIndex.equals(propMeEntry.getValue())) {
                return false;
            }
            String propName = propMeEntry.getKey();
            ExprValidationException comparedMessage = BaseNestableEventUtil.comparePropType(propName, setOneType = this.nestableTypes.get(propName), setOneTypeFound = this.nestableTypes.containsKey(propName), setTwoType = other.nestableTypes.get(propName), other.getName());
            if (comparedMessage == null) continue;
            return false;
        }
        return true;
    }

    private void initializeWriters() {
        ArrayList<EventPropertyDescriptor> writeableProps = new ArrayList<EventPropertyDescriptor>();
        HashMap<String, Pair<EventPropertyDescriptor, ObjectArrayEventBeanPropertyWriter>> propertWritersMap = new HashMap<String, Pair<EventPropertyDescriptor, ObjectArrayEventBeanPropertyWriter>>();
        for (EventPropertyDescriptor prop : this.propertyDescriptors) {
            writeableProps.add(prop);
            String propertyName = prop.getPropertyName();
            Integer index = this.getPropertiesIndexes().get(prop.getPropertyName());
            if (index == null) continue;
            ObjectArrayEventBeanPropertyWriter eventPropertyWriter = new ObjectArrayEventBeanPropertyWriter(index);
            propertWritersMap.put(propertyName, new Pair<EventPropertyDescriptor, ObjectArrayEventBeanPropertyWriter>(prop, eventPropertyWriter));
        }
        this.propertyWriters = propertWritersMap;
        this.writablePropertyDescriptors = writeableProps.toArray(new EventPropertyDescriptor[writeableProps.size()]);
    }

    private static EventTypeNestableGetterFactory getGetterFactory(String eventTypeName, Map<String, Object> propertyTypes, EventType[] optionalSupertypes) {
        HashMap<String, Integer> indexPerProperty = new HashMap<String, Integer>();
        int index = 0;
        if (optionalSupertypes != null) {
            for (EventType superType : optionalSupertypes) {
                ObjectArrayEventType objectArraySuperType = (ObjectArrayEventType)superType;
                for (String propertyName : objectArraySuperType.getPropertyNames()) {
                    if (indexPerProperty.containsKey(propertyName)) continue;
                    indexPerProperty.put(propertyName, index);
                    ++index;
                }
            }
        }
        for (Map.Entry entry : propertyTypes.entrySet()) {
            indexPerProperty.put((String)entry.getKey(), index);
            ++index;
        }
        return new EventTypeNestableGetterFactoryObjectArray(eventTypeName, indexPerProperty);
    }
}

