/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.arr;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.PropertyAccessException;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.event.arr.ObjectArrayEventPropertyGetter;
import com.espertech.esper.common.internal.event.core.BaseNestableEventUtil;
import com.espertech.esper.common.internal.event.map.MapEventPropertyGetter;
import java.util.Map;

public class ObjectArrayMapPropertyGetter
implements ObjectArrayEventPropertyGetter {
    private final int index;
    private final MapEventPropertyGetter getter;

    public ObjectArrayMapPropertyGetter(int index, MapEventPropertyGetter getter) {
        if (getter == null) {
            throw new IllegalArgumentException("Getter is a required parameter");
        }
        this.index = index;
        this.getter = getter;
    }

    @Override
    public Object getObjectArray(Object[] array) throws PropertyAccessException {
        Object valueTopObj = array[this.index];
        if (!(valueTopObj instanceof Map)) {
            return null;
        }
        return this.getter.getMap((Map)valueTopObj);
    }

    private CodegenMethod getObjectArrayCodegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return codegenMethodScope.makeChild(EPTypePremade.OBJECT.getEPType(), this.getClass(), (CodegenScope)codegenClassScope).addParam(EPTypePremade.OBJECTARRAY.getEPType(), "array").getBlock().declareVar(EPTypePremade.OBJECT.getEPType(), "valueTopObj", CodegenExpressionBuilder.arrayAtIndex(CodegenExpressionBuilder.ref("array"), CodegenExpressionBuilder.constant(this.index))).ifRefNotTypeReturnConst("valueTopObj", EPTypePremade.MAP.getEPType(), null).methodReturn(this.getter.underlyingGetCodegen(CodegenExpressionBuilder.cast(EPTypePremade.MAP.getEPType(), (CodegenExpression)CodegenExpressionBuilder.ref("valueTopObj")), codegenMethodScope, codegenClassScope));
    }

    @Override
    public boolean isObjectArrayExistsProperty(Object[] array) {
        Object valueTopObj = array[this.index];
        if (!(valueTopObj instanceof Map)) {
            return false;
        }
        return this.getter.isMapExistsProperty((Map)valueTopObj);
    }

    private CodegenMethod isObjectArrayExistsPropertyCodegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return codegenMethodScope.makeChild(EPTypePremade.BOOLEANPRIMITIVE.getEPType(), this.getClass(), (CodegenScope)codegenClassScope).addParam(EPTypePremade.OBJECTARRAY.getEPType(), "array").getBlock().declareVar(EPTypePremade.OBJECT.getEPType(), "valueTopObj", CodegenExpressionBuilder.arrayAtIndex(CodegenExpressionBuilder.ref("array"), CodegenExpressionBuilder.constant(this.index))).ifRefNotTypeReturnConst("valueTopObj", EPTypePremade.MAP.getEPType(), false).methodReturn(this.getter.underlyingExistsCodegen(CodegenExpressionBuilder.cast(EPTypePremade.MAP.getEPType(), (CodegenExpression)CodegenExpressionBuilder.ref("valueTopObj")), codegenMethodScope, codegenClassScope));
    }

    @Override
    public Object get(EventBean eventBean) throws PropertyAccessException {
        Object[] array = BaseNestableEventUtil.checkedCastUnderlyingObjectArray(eventBean);
        return this.getObjectArray(array);
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        Object[] array = BaseNestableEventUtil.checkedCastUnderlyingObjectArray(eventBean);
        return this.isObjectArrayExistsProperty(array);
    }

    @Override
    public Object getFragment(EventBean eventBean) {
        return null;
    }

    @Override
    public CodegenExpression eventBeanGetCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return this.underlyingGetCodegen(CodegenExpressionBuilder.castUnderlying(EPTypePremade.OBJECTARRAY.getEPType(), beanExpression), codegenMethodScope, codegenClassScope);
    }

    @Override
    public CodegenExpression eventBeanExistsCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return this.underlyingExistsCodegen(CodegenExpressionBuilder.castUnderlying(EPTypePremade.OBJECTARRAY.getEPType(), beanExpression), codegenMethodScope, codegenClassScope);
    }

    @Override
    public CodegenExpression eventBeanFragmentCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.constantNull();
    }

    @Override
    public CodegenExpression underlyingGetCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.localMethod(this.getObjectArrayCodegen(codegenMethodScope, codegenClassScope), underlyingExpression);
    }

    @Override
    public CodegenExpression underlyingExistsCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.localMethod(this.isObjectArrayExistsPropertyCodegen(codegenMethodScope, codegenClassScope), underlyingExpression);
    }

    @Override
    public CodegenExpression underlyingFragmentCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.constantNull();
    }
}

