/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.arr;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.PropertyAccessException;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.event.arr.ObjectArrayEventPropertyGetterAndMapped;
import com.espertech.esper.common.internal.event.core.BaseNestableEventUtil;

public class ObjectArrayMappedPropertyGetter
implements ObjectArrayEventPropertyGetterAndMapped {
    private final int propertyIndex;
    private final String key;

    public static Object getOAMapValue(Object[] objectArray, int propertyIndex, String providedKey) throws PropertyAccessException {
        Object value = objectArray[propertyIndex];
        return BaseNestableEventUtil.getMappedPropertyValue(value, providedKey);
    }

    public static boolean getOAMapExists(Object[] objectArray, int propertyIndex, String providedKey) throws PropertyAccessException {
        Object value = objectArray[propertyIndex];
        return BaseNestableEventUtil.getMappedPropertyExists(value, providedKey);
    }

    public ObjectArrayMappedPropertyGetter(int propertyIndex, String key) {
        this.propertyIndex = propertyIndex;
        this.key = key;
    }

    @Override
    public Object getObjectArray(Object[] array) throws PropertyAccessException {
        return ObjectArrayMappedPropertyGetter.getOAMapValue(array, this.propertyIndex, this.key);
    }

    @Override
    public boolean isObjectArrayExistsProperty(Object[] array) {
        return ObjectArrayMappedPropertyGetter.getOAMapExists(array, this.propertyIndex, this.key);
    }

    @Override
    public Object get(EventBean eventBean, String mapKey) throws PropertyAccessException {
        Object[] data = BaseNestableEventUtil.checkedCastUnderlyingObjectArray(eventBean);
        return ObjectArrayMappedPropertyGetter.getOAMapValue(data, this.propertyIndex, mapKey);
    }

    @Override
    public Object get(EventBean eventBean) throws PropertyAccessException {
        Object[] data = BaseNestableEventUtil.checkedCastUnderlyingObjectArray(eventBean);
        return ObjectArrayMappedPropertyGetter.getOAMapValue(data, this.propertyIndex, this.key);
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        Object[] data = BaseNestableEventUtil.checkedCastUnderlyingObjectArray(eventBean);
        return ObjectArrayMappedPropertyGetter.getOAMapExists(data, this.propertyIndex, this.key);
    }

    @Override
    public Object getFragment(EventBean eventBean) {
        return null;
    }

    @Override
    public CodegenExpression eventBeanGetCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return this.underlyingGetCodegen(CodegenExpressionBuilder.castUnderlying(EPTypePremade.OBJECTARRAY.getEPType(), beanExpression), codegenMethodScope, codegenClassScope);
    }

    @Override
    public CodegenExpression eventBeanExistsCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return this.underlyingExistsCodegen(CodegenExpressionBuilder.castUnderlying(EPTypePremade.OBJECTARRAY.getEPType(), beanExpression), codegenMethodScope, codegenClassScope);
    }

    @Override
    public CodegenExpression eventBeanFragmentCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.constantNull();
    }

    @Override
    public CodegenExpression underlyingGetCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.staticMethod(this.getClass(), "getOAMapValue", underlyingExpression, CodegenExpressionBuilder.constant(this.propertyIndex), CodegenExpressionBuilder.constant(this.key));
    }

    @Override
    public CodegenExpression underlyingExistsCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.staticMethod(this.getClass(), "getOAMapExists", underlyingExpression, CodegenExpressionBuilder.constant(this.propertyIndex), CodegenExpressionBuilder.constant(this.key));
    }

    @Override
    public CodegenExpression underlyingFragmentCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.constantNull();
    }

    @Override
    public CodegenExpression eventBeanGetMappedCodegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope, CodegenExpression beanExpression, CodegenExpression key) {
        return CodegenExpressionBuilder.staticMethod(this.getClass(), "getOAMapValue", CodegenExpressionBuilder.castUnderlying(EPTypePremade.OBJECTARRAY.getEPType(), beanExpression), CodegenExpressionBuilder.constant(this.propertyIndex), key);
    }
}

