/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.bean.core;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.event.bean.core.BeanEventType;
import com.espertech.esper.common.internal.event.core.EventBeanCopyMethod;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanEventBeanConfiguredCopyMethod
implements EventBeanCopyMethod {
    public static final EPTypeClass EPTYPE = new EPTypeClass(BeanEventBeanConfiguredCopyMethod.class);
    private static final Logger log = LoggerFactory.getLogger(BeanEventBeanConfiguredCopyMethod.class);
    private final BeanEventType beanEventType;
    private final EventBeanTypedEventFactory eventAdapterService;
    private final Method copyMethod;

    public BeanEventBeanConfiguredCopyMethod(BeanEventType beanEventType, EventBeanTypedEventFactory eventAdapterService, Method copyMethod) {
        this.beanEventType = beanEventType;
        this.eventAdapterService = eventAdapterService;
        this.copyMethod = copyMethod;
    }

    @Override
    public EventBean copy(EventBean theEvent) {
        Object copied;
        Object underlying = theEvent.getUnderlying();
        try {
            copied = this.copyMethod.invoke(underlying, null);
        }
        catch (IllegalAccessException e) {
            log.error("IllegalAccessException copying event object for update: " + e.getMessage(), (Throwable)e);
            return null;
        }
        catch (InvocationTargetException e) {
            log.error("InvocationTargetException copying event object for update: " + e.getMessage(), (Throwable)e);
            return null;
        }
        catch (RuntimeException e) {
            log.error("RuntimeException copying event object for update: " + e.getMessage(), (Throwable)e);
            return null;
        }
        return this.eventAdapterService.adapterForTypedBean(copied, this.beanEventType);
    }
}

