/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.bean.core;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventSender;
import com.espertech.esper.common.internal.event.bean.core.BeanEventType;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import com.espertech.esper.common.internal.event.util.EPRuntimeEventProcessWrapped;
import com.espertech.esper.common.internal.statement.thread.ThreadingCommon;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.util.HashSet;
import java.util.Set;

public class EventSenderBean
implements EventSender {
    private final EPRuntimeEventProcessWrapped runtime;
    private final BeanEventType beanEventType;
    private final EventBeanTypedEventFactory eventBeanTypedEventFactory;
    private final Set<Class> compatibleClasses;
    private final ThreadingCommon threadingService;

    public EventSenderBean(EPRuntimeEventProcessWrapped runtime, BeanEventType beanEventType, EventBeanTypedEventFactory eventBeanTypedEventFactory, ThreadingCommon threadingService) {
        this.runtime = runtime;
        this.beanEventType = beanEventType;
        this.eventBeanTypedEventFactory = eventBeanTypedEventFactory;
        this.compatibleClasses = new HashSet<Class>();
        this.threadingService = threadingService;
    }

    @Override
    public void sendEvent(Object theEvent) {
        if (theEvent == null) {
            throw new NullPointerException("No event object provided to sendEvent method");
        }
        EventBean eventBean = this.getEventBean(theEvent);
        if (this.threadingService.isInboundThreading()) {
            this.threadingService.submitInbound(eventBean, this.runtime);
        } else {
            this.runtime.processWrappedEvent(eventBean);
        }
    }

    @Override
    public void routeEvent(Object theEvent) throws EPException {
        EventBean eventBean = this.getEventBean(theEvent);
        this.runtime.routeEventBean(eventBean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EventBean getEventBean(Object theEvent) {
        if (theEvent.getClass() != this.beanEventType.getUnderlyingType()) {
            EventSenderBean eventSenderBean = this;
            synchronized (eventSenderBean) {
                if (!this.compatibleClasses.contains(theEvent.getClass())) {
                    if (JavaClassHelper.isSubclassOrImplementsInterface(theEvent.getClass(), this.beanEventType.getUnderlyingType())) {
                        this.compatibleClasses.add(theEvent.getClass());
                    } else {
                        throw new EPException("Event object of type " + theEvent.getClass().getName() + " does not equal, extend or implement the type " + this.beanEventType.getUnderlyingType().getName() + " of event type '" + this.beanEventType.getName() + "'");
                    }
                }
            }
        }
        return this.eventBeanTypedEventFactory.adapterForTypedBean(theEvent, this.beanEventType);
    }
}

