/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.bean.getter;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.PropertyAccessException;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.event.bean.core.BeanEventPropertyGetter;
import com.espertech.esper.common.internal.event.bean.getter.BaseNativePropertyGetter;
import com.espertech.esper.common.internal.event.bean.service.BeanEventTypeFactory;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import com.espertech.esper.common.internal.event.core.EventPropertyGetterAndMapped;
import com.espertech.esper.common.internal.event.util.PropertyUtility;
import com.espertech.esper.common.internal.util.ClassHelperGenericType;
import com.espertech.esper.common.internal.util.CollectionUtil;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class KeyedMapMethodPropertyGetter
extends BaseNativePropertyGetter
implements BeanEventPropertyGetter,
EventPropertyGetterAndMapped {
    private final Method method;
    private final Object key;

    public KeyedMapMethodPropertyGetter(Method method, Object key, EventBeanTypedEventFactory eventBeanTypedEventFactory, BeanEventTypeFactory beanEventTypeFactory) {
        super(eventBeanTypedEventFactory, beanEventTypeFactory, JavaClassHelper.getSecondParameterTypeOrObject(ClassHelperGenericType.getMethodReturnEPType(method)));
        this.key = key;
        this.method = method;
    }

    @Override
    public Object get(EventBean eventBean, String mapKey) throws PropertyAccessException {
        return this.getBeanPropInternal(eventBean.getUnderlying(), mapKey);
    }

    @Override
    public Object getBeanProp(Object object) throws PropertyAccessException {
        return this.getBeanPropInternal(object, this.key);
    }

    public Object getBeanPropInternal(Object object, Object key) throws PropertyAccessException {
        try {
            Object result = this.method.invoke(object, (Object[])null);
            return CollectionUtil.getMapValueChecked(result, key);
        }
        catch (ClassCastException e) {
            throw PropertyUtility.getMismatchException(this.method, object, e);
        }
        catch (InvocationTargetException e) {
            throw PropertyUtility.getInvocationTargetException(this.method, e);
        }
        catch (IllegalAccessException e) {
            throw PropertyUtility.getIllegalAccessException(this.method, e);
        }
        catch (IllegalArgumentException e) {
            throw PropertyUtility.getIllegalArgumentException(this.method, e);
        }
    }

    public boolean getBeanPropExistsInternal(Object object, Object key) throws PropertyAccessException {
        try {
            Object result = this.method.invoke(object, (Object[])null);
            return CollectionUtil.getMapKeyExistsChecked(result, key);
        }
        catch (ClassCastException e) {
            throw PropertyUtility.getMismatchException(this.method, object, e);
        }
        catch (InvocationTargetException e) {
            throw PropertyUtility.getInvocationTargetException(this.method, e);
        }
        catch (IllegalAccessException e) {
            throw PropertyUtility.getIllegalAccessException(this.method, e);
        }
        catch (IllegalArgumentException e) {
            throw PropertyUtility.getIllegalArgumentException(this.method, e);
        }
    }

    static CodegenMethod getBeanPropInternalCodegen(CodegenMethodScope codegenMethodScope, EPTypeClass beanPropType, EPTypeClass targetType, Method method, CodegenClassScope codegenClassScope) throws PropertyAccessException {
        EPTypeClass returnType = ClassHelperGenericType.getMethodReturnEPType(method);
        return codegenMethodScope.makeChild(beanPropType, KeyedMapMethodPropertyGetter.class, (CodegenScope)codegenClassScope).addParam(targetType, "object").addParam(EPTypePremade.OBJECT.getEPType(), "key").getBlock().declareVar(returnType, "result", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("object"), method.getName(), new CodegenExpression[0])).ifRefNotTypeReturnConst("result", EPTypePremade.MAP.getEPType(), null).methodReturn(CodegenExpressionBuilder.cast(beanPropType, CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.cast(EPTypePremade.MAP.getEPType(), (CodegenExpression)CodegenExpressionBuilder.ref("result")), "get", CodegenExpressionBuilder.ref("key"))));
    }

    static CodegenMethod getBeanPropExistsInternalCodegen(CodegenMethodScope codegenMethodScope, Class beanPropType, EPTypeClass targetType, Method method, CodegenClassScope codegenClassScope) throws PropertyAccessException {
        EPTypeClass returnType = ClassHelperGenericType.getMethodReturnEPType(method);
        return codegenMethodScope.makeChild(EPTypePremade.BOOLEANPRIMITIVE.getEPType(), KeyedMapMethodPropertyGetter.class, (CodegenScope)codegenClassScope).addParam(targetType, "object").addParam(EPTypePremade.OBJECT.getEPType(), "key").getBlock().declareVar(returnType, "result", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("object"), method.getName(), new CodegenExpression[0])).ifRefNotTypeReturnConst("result", EPTypePremade.MAP.getEPType(), false).methodReturn(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.cast(EPTypePremade.MAP.getEPType(), (CodegenExpression)CodegenExpressionBuilder.ref("result")), "containsKey", CodegenExpressionBuilder.ref("key")));
    }

    @Override
    public boolean isBeanExistsProperty(Object object) {
        return true;
    }

    @Override
    public final Object get(EventBean obj) throws PropertyAccessException {
        Object underlying = obj.getUnderlying();
        return this.getBeanProp(underlying);
    }

    public String toString() {
        return "KeyedMapMethodPropertyGetter  method=" + this.method.toString() + " key=" + this.key;
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        Object underlying = eventBean.getUnderlying();
        return this.getBeanPropExistsInternal(underlying, this.key);
    }

    @Override
    public EPTypeClass getTargetType() {
        return ClassHelperGenericType.getClassEPType(this.method.getDeclaringClass());
    }

    @Override
    public CodegenExpression eventBeanGetCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return this.underlyingGetCodegen(CodegenExpressionBuilder.castUnderlying(this.getTargetType(), beanExpression), codegenMethodScope, codegenClassScope);
    }

    @Override
    public CodegenExpression eventBeanExistsCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return this.underlyingExistsCodegen(CodegenExpressionBuilder.castUnderlying(this.getTargetType(), beanExpression), codegenMethodScope, codegenClassScope);
    }

    @Override
    public CodegenExpression underlyingGetCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.localMethod(KeyedMapMethodPropertyGetter.getBeanPropInternalCodegen(codegenMethodScope, this.getBeanPropType(), this.getTargetType(), this.method, codegenClassScope), underlyingExpression, CodegenExpressionBuilder.constant(this.key));
    }

    @Override
    public CodegenExpression underlyingExistsCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.localMethod(KeyedMapMethodPropertyGetter.getBeanPropExistsInternalCodegen(codegenMethodScope, this.getBeanPropType().getType(), this.getTargetType(), this.method, codegenClassScope), underlyingExpression, CodegenExpressionBuilder.constant(this.key));
    }

    @Override
    public CodegenExpression eventBeanGetMappedCodegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope, CodegenExpression beanExpression, CodegenExpression key) {
        return CodegenExpressionBuilder.localMethod(KeyedMapMethodPropertyGetter.getBeanPropInternalCodegen(codegenMethodScope, this.getBeanPropType(), this.getTargetType(), this.method, codegenClassScope), CodegenExpressionBuilder.castUnderlying(this.getTargetType(), beanExpression), key);
    }
}

