/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.bean.instantiator;

import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.event.bean.instantiator.BeanInstantiator;
import com.espertech.esper.common.internal.event.bean.instantiator.BeanInstantiatorForge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanInstantiatorForgeByNewInstanceReflection
implements BeanInstantiatorForge,
BeanInstantiator {
    private static final Logger log = LoggerFactory.getLogger(BeanInstantiatorForgeByNewInstanceReflection.class);
    private final EPTypeClass clazz;

    public BeanInstantiatorForgeByNewInstanceReflection(EPTypeClass clazz) {
        this.clazz = clazz;
    }

    @Override
    public Object instantiate() {
        try {
            return this.clazz.getType().newInstance();
        }
        catch (IllegalAccessException e) {
            return this.handle(e);
        }
        catch (InstantiationException e) {
            return this.handle(e);
        }
    }

    @Override
    public CodegenExpression make(CodegenMethodScope parent, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.newInstance(this.clazz, new CodegenExpression[0]);
    }

    @Override
    public BeanInstantiator getBeanInstantiator() {
        return this;
    }

    private Object handle(Exception e) {
        String message = "Unexpected exception encountered invoking newInstance on class '" + this.clazz.getTypeName() + "': " + e.getMessage();
        log.error(message, (Throwable)e);
        return null;
    }
}

