/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.bean.manufacturer;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionField;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionNewAnonymousClass;
import com.espertech.esper.common.internal.context.module.EPStatementInitServices;
import com.espertech.esper.common.internal.event.bean.instantiator.BeanInstantiatorForge;
import com.espertech.esper.common.internal.event.bean.instantiator.BeanInstantiatorForgeByNewInstanceReflection;
import com.espertech.esper.common.internal.event.bean.manufacturer.EventBeanManufacturerJsonProvided;
import com.espertech.esper.common.internal.event.core.EventBeanManufactureException;
import com.espertech.esper.common.internal.event.core.EventBeanManufacturer;
import com.espertech.esper.common.internal.event.core.EventBeanManufacturerForge;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactoryCodegenField;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import com.espertech.esper.common.internal.event.core.WriteablePropertyDescriptor;
import com.espertech.esper.common.internal.event.json.compiletime.JsonUnderlyingField;
import com.espertech.esper.common.internal.event.json.core.JsonEventType;
import com.espertech.esper.common.internal.settings.ClasspathImportService;
import com.espertech.esper.common.internal.util.ClassHelperGenericType;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import com.espertech.esper.common.internal.util.SimpleTypeCaster;
import com.espertech.esper.common.internal.util.SimpleTypeCasterFactory;
import java.lang.reflect.Field;

public class EventBeanManufacturerJsonProvidedForge
implements EventBeanManufacturerForge {
    private final BeanInstantiatorForge beanInstantiator;
    private final JsonEventType jsonEventType;
    private final WriteablePropertyDescriptor[] properties;
    private final ClasspathImportService classpathImportService;
    private final Field[] writeFieldReflection;
    private final boolean[] primitiveType;

    public EventBeanManufacturerJsonProvidedForge(JsonEventType jsonEventType, WriteablePropertyDescriptor[] properties, ClasspathImportService classpathImportService) throws EventBeanManufactureException {
        this.jsonEventType = jsonEventType;
        this.properties = properties;
        this.classpathImportService = classpathImportService;
        this.beanInstantiator = new BeanInstantiatorForgeByNewInstanceReflection(jsonEventType.getUnderlyingEPType());
        this.writeFieldReflection = new Field[properties.length];
        this.primitiveType = new boolean[properties.length];
        for (int i = 0; i < properties.length; ++i) {
            String propertyName = properties[i].getPropertyName();
            JsonUnderlyingField field = jsonEventType.getDetail().getFieldDescriptors().get(propertyName);
            this.writeFieldReflection[i] = field.getOptionalField();
            this.primitiveType[i] = JavaClassHelper.isTypePrimitive(properties[i].getType());
        }
    }

    @Override
    public EventBeanManufacturer getManufacturer(EventBeanTypedEventFactory eventBeanTypedEventFactory) throws EventBeanManufactureException {
        return new EventBeanManufacturerJsonProvided(this.jsonEventType, eventBeanTypedEventFactory, this.properties, this.classpathImportService);
    }

    @Override
    public CodegenExpression make(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        CodegenMethod init = codegenClassScope.getPackageScope().getInitMethod();
        CodegenExpressionField factory = codegenClassScope.addOrGetFieldSharable(EventBeanTypedEventFactoryCodegenField.INSTANCE);
        CodegenExpressionField beanType = codegenClassScope.addFieldUnshared(true, EventType.EPTYPE, EventTypeUtility.resolveTypeCodegen(this.jsonEventType, EPStatementInitServices.REF));
        CodegenExpressionNewAnonymousClass manufacturer = CodegenExpressionBuilder.newAnonymousClass(init.getBlock(), EventBeanManufacturer.EPTYPE);
        CodegenMethod makeUndMethod = CodegenMethod.makeParentNode(EPTypePremade.OBJECT.getEPType(), this.getClass(), codegenClassScope).addParam(EPTypePremade.OBJECTARRAY.getEPType(), "properties");
        manufacturer.addMethod("makeUnderlying", makeUndMethod);
        this.makeUnderlyingCodegen(makeUndMethod, codegenClassScope);
        CodegenMethod makeMethod = CodegenMethod.makeParentNode(EventBean.EPTYPE, this.getClass(), codegenClassScope).addParam(EPTypePremade.OBJECTARRAY.getEPType(), "properties");
        manufacturer.addMethod("make", makeMethod);
        makeMethod.getBlock().declareVar(EPTypePremade.OBJECT.getEPType(), "und", (CodegenExpression)CodegenExpressionBuilder.localMethod(makeUndMethod, CodegenExpressionBuilder.ref("properties"))).methodReturn(CodegenExpressionBuilder.exprDotMethod(factory, "adapterForTypedJson", CodegenExpressionBuilder.ref("und"), beanType));
        return codegenClassScope.addFieldUnshared(true, EventBeanManufacturer.EPTYPE, manufacturer);
    }

    private void makeUnderlyingCodegen(CodegenMethod method, CodegenClassScope codegenClassScope) {
        method.getBlock().declareVar(this.jsonEventType.getUnderlyingEPType(), "und", CodegenExpressionBuilder.cast(this.jsonEventType.getUnderlyingEPType(), this.beanInstantiator.make(method, codegenClassScope))).declareVar(EPTypePremade.OBJECT.getEPType(), "value", CodegenExpressionBuilder.constantNull());
        for (int i = 0; i < this.writeFieldReflection.length; ++i) {
            CodegenExpression value;
            method.getBlock().assignRef("value", CodegenExpressionBuilder.arrayAtIndex(CodegenExpressionBuilder.ref("properties"), CodegenExpressionBuilder.constant(i)));
            EPTypeClass targetType = ClassHelperGenericType.getFieldEPType(this.writeFieldReflection[i]);
            if (targetType.getType().isPrimitive()) {
                SimpleTypeCaster caster = SimpleTypeCasterFactory.getCaster(EPTypePremade.OBJECT.getEPType(), targetType);
                value = caster.codegen(CodegenExpressionBuilder.ref("value"), EPTypePremade.OBJECT.getEPType(), method, codegenClassScope);
            } else {
                value = CodegenExpressionBuilder.cast(targetType, (CodegenExpression)CodegenExpressionBuilder.ref("value"));
            }
            CodegenExpression set = CodegenExpressionBuilder.assign(CodegenExpressionBuilder.exprDotName(CodegenExpressionBuilder.ref("und"), this.writeFieldReflection[i].getName()), value);
            if (this.primitiveType[i]) {
                method.getBlock().ifRefNotNull("value").expression(set).blockEnd();
                continue;
            }
            method.getBlock().expression(set);
        }
        method.getBlock().methodReturn(CodegenExpressionBuilder.ref("und"));
    }
}

