/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.bean.manufacturer;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionField;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionNewAnonymousClass;
import com.espertech.esper.common.internal.bytecodemodel.util.CodegenRepetitiveLengthBuilder;
import com.espertech.esper.common.internal.context.module.EPStatementInitServices;
import com.espertech.esper.common.internal.event.arr.ObjectArrayEventType;
import com.espertech.esper.common.internal.event.bean.manufacturer.EventBeanManufacturerObjectArray;
import com.espertech.esper.common.internal.event.core.EventBeanManufacturer;
import com.espertech.esper.common.internal.event.core.EventBeanManufacturerForge;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactoryCodegenField;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import com.espertech.esper.common.internal.event.core.WriteablePropertyDescriptor;
import java.util.Map;

public class EventBeanManufacturerObjectArrayForge
implements EventBeanManufacturerForge {
    private final ObjectArrayEventType eventType;
    private final int[] indexPerWritable;
    private final boolean oneToOne;

    public EventBeanManufacturerObjectArrayForge(ObjectArrayEventType eventType, WriteablePropertyDescriptor[] properties) {
        this.eventType = eventType;
        Map<String, Integer> indexes = eventType.getPropertiesIndexes();
        this.indexPerWritable = new int[properties.length];
        boolean oneToOneMapping = true;
        for (int i = 0; i < properties.length; ++i) {
            String propertyName = properties[i].getPropertyName();
            Integer index = indexes.get(propertyName);
            if (index == null) {
                throw new IllegalStateException("Failed to find property '" + propertyName + "' among the array indexes");
            }
            this.indexPerWritable[i] = index;
            if (index == i) continue;
            oneToOneMapping = false;
        }
        this.oneToOne = oneToOneMapping && properties.length == eventType.getPropertyNames().length;
    }

    @Override
    public EventBeanManufacturer getManufacturer(EventBeanTypedEventFactory eventBeanTypedEventFactory) {
        return new EventBeanManufacturerObjectArray(this.eventType, eventBeanTypedEventFactory, this.indexPerWritable, this.oneToOne);
    }

    @Override
    public CodegenExpression make(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        CodegenMethod init = codegenClassScope.getPackageScope().getInitMethod();
        CodegenExpressionField factory = codegenClassScope.addOrGetFieldSharable(EventBeanTypedEventFactoryCodegenField.INSTANCE);
        CodegenExpressionField eventType = codegenClassScope.addFieldUnshared(true, EventType.EPTYPE, EventTypeUtility.resolveTypeCodegen(this.eventType, EPStatementInitServices.REF));
        CodegenExpressionNewAnonymousClass manufacturer = CodegenExpressionBuilder.newAnonymousClass(init.getBlock(), EventBeanManufacturer.EPTYPE);
        CodegenMethod makeUndMethod = CodegenMethod.makeParentNode(EPTypePremade.OBJECTARRAY.getEPType(), this.getClass(), codegenClassScope).addParam(EPTypePremade.OBJECTARRAY.getEPType(), "properties");
        manufacturer.addMethod("makeUnderlying", makeUndMethod);
        this.makeUnderlyingCodegen(makeUndMethod, codegenClassScope);
        CodegenMethod makeMethod = CodegenMethod.makeParentNode(EventBean.EPTYPE, this.getClass(), codegenClassScope).addParam(EPTypePremade.OBJECTARRAY.getEPType(), "properties");
        manufacturer.addMethod("make", makeMethod);
        makeMethod.getBlock().declareVar(EPTypePremade.OBJECTARRAY.getEPType(), "und", (CodegenExpression)CodegenExpressionBuilder.localMethod(makeUndMethod, CodegenExpressionBuilder.ref("properties"))).methodReturn(CodegenExpressionBuilder.exprDotMethod(factory, "adapterForTypedObjectArray", CodegenExpressionBuilder.ref("und"), eventType));
        return codegenClassScope.addFieldUnshared(true, EventBeanManufacturer.EPTYPE, manufacturer);
    }

    private void makeUnderlyingCodegen(CodegenMethod method, CodegenClassScope codegenClassScope) {
        if (this.oneToOne) {
            method.getBlock().methodReturn(CodegenExpressionBuilder.ref("properties"));
            return;
        }
        method.getBlock().declareVar(EPTypePremade.OBJECTARRAY.getEPType(), "cols", CodegenExpressionBuilder.newArrayByLength(EPTypePremade.OBJECT.getEPType(), CodegenExpressionBuilder.constant(this.eventType.getPropertyNames().length)));
        new CodegenRepetitiveLengthBuilder(this.indexPerWritable.length, method, codegenClassScope, this.getClass()).addParam(EPTypePremade.OBJECTARRAY.getEPType(), "cols").addParam(EPTypePremade.OBJECTARRAY.getEPType(), "properties").setConsumer((index, leaf) -> leaf.getBlock().assignArrayElement(CodegenExpressionBuilder.ref("cols"), CodegenExpressionBuilder.constant(this.indexPerWritable[index]), CodegenExpressionBuilder.arrayAtIndex(CodegenExpressionBuilder.ref("properties"), CodegenExpressionBuilder.constant(index)))).build();
        method.getBlock().methodReturn(CodegenExpressionBuilder.ref("cols"));
    }
}

