/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.bean.service;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.configuration.common.ConfigurationCommonEventTypeBean;
import com.espertech.esper.common.client.meta.EventTypeApplicationType;
import com.espertech.esper.common.client.meta.EventTypeIdPair;
import com.espertech.esper.common.client.meta.EventTypeMetadata;
import com.espertech.esper.common.client.meta.EventTypeTypeClass;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.util.AccessorStyle;
import com.espertech.esper.common.client.util.EventTypeBusModifier;
import com.espertech.esper.common.client.util.NameAccessModifier;
import com.espertech.esper.common.internal.event.bean.core.BeanEventType;
import com.espertech.esper.common.internal.event.bean.core.BeanEventTypeStemService;
import com.espertech.esper.common.internal.event.bean.introspect.BeanEventTypeStem;
import com.espertech.esper.common.internal.event.bean.service.BeanEventTypeFactory;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import com.espertech.esper.common.internal.event.eventtypefactory.EventTypeFactory;
import com.espertech.esper.common.internal.util.CRC32Util;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class BeanEventTypeFactoryPrivate
implements BeanEventTypeFactory {
    private final EventBeanTypedEventFactory typedEventFactory;
    private final EventTypeFactory eventTypeFactory;
    private final BeanEventTypeStemService stemFactory;
    private final Map<EPTypeClass, BeanEventType> types = new HashMap<EPTypeClass, BeanEventType>();

    public BeanEventTypeFactoryPrivate(EventBeanTypedEventFactory typedEventFactory, EventTypeFactory eventTypeFactory, BeanEventTypeStemService stemFactory) {
        this.typedEventFactory = typedEventFactory;
        this.eventTypeFactory = eventTypeFactory;
        this.stemFactory = stemFactory;
    }

    @Override
    public BeanEventType getCreateBeanType(EPTypeClass clazz, boolean publicFields) {
        BeanEventType existing = this.types.get(clazz);
        if (existing != null) {
            return existing;
        }
        ConfigurationCommonEventTypeBean config = null;
        if (publicFields) {
            config = new ConfigurationCommonEventTypeBean();
            config.setAccessorStyle(AccessorStyle.PUBLIC);
        }
        BeanEventTypeStem stem = this.stemFactory.getCreateStem(clazz, config);
        EventTypeMetadata metadata = new EventTypeMetadata(clazz.getTypeName(), null, EventTypeTypeClass.BEAN_INCIDENTAL, EventTypeApplicationType.CLASS, NameAccessModifier.TRANSIENT, EventTypeBusModifier.NONBUS, false, this.computeTypeId(clazz.getTypeName()));
        EventType[] superTypes = this.getSuperTypes(stem.getSuperTypes());
        Set<EventType> deepSuperTypes = this.getDeepSupertypes(stem.getDeepSuperTypes());
        BeanEventType eventType = this.eventTypeFactory.createBeanType(stem, metadata, this, superTypes, deepSuperTypes, null, null);
        this.types.put(clazz, eventType);
        return eventType;
    }

    @Override
    public EventBeanTypedEventFactory getEventBeanTypedEventFactory() {
        return this.typedEventFactory;
    }

    public NameAccessModifier getVisibility() {
        return NameAccessModifier.TRANSIENT;
    }

    @Override
    public EventTypeFactory getEventTypeFactory() {
        return this.eventTypeFactory;
    }

    public EventTypeIdPair computeTypeId(String eventTypeName) {
        long id = CRC32Util.computeCRC32(eventTypeName);
        return new EventTypeIdPair(0L, id);
    }

    private EventType[] getSuperTypes(EPTypeClass[] superTypes) {
        if (superTypes == null || superTypes.length == 0) {
            return null;
        }
        EventType[] types = new EventType[superTypes.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = this.getCreateBeanType(superTypes[i], false);
        }
        return types;
    }

    private Set<EventType> getDeepSupertypes(Set<EPTypeClass> superTypes) {
        if (superTypes == null || superTypes.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<EventType> supers = new LinkedHashSet<EventType>(4);
        for (EPTypeClass clazz : superTypes) {
            supers.add(this.getCreateBeanType(clazz, false));
        }
        return supers;
    }
}

