/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.core;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventPropertyGetter;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.PropertyAccessException;
import com.espertech.esper.common.client.meta.EventTypeApplicationType;
import com.espertech.esper.common.client.meta.EventTypeMetadata;
import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypeNull;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRelational;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.event.arr.ObjectArrayEventPropertyGetter;
import com.espertech.esper.common.internal.event.arr.ObjectArrayEventType;
import com.espertech.esper.common.internal.event.bean.core.BeanEventPropertyGetter;
import com.espertech.esper.common.internal.event.bean.core.BeanEventType;
import com.espertech.esper.common.internal.event.bean.service.BeanEventTypeFactory;
import com.espertech.esper.common.internal.event.core.BaseNestableEventType;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import com.espertech.esper.common.internal.event.core.EventPropertyGetterSPI;
import com.espertech.esper.common.internal.event.core.EventTypeCompileTimeResolver;
import com.espertech.esper.common.internal.event.core.EventTypeNameResolver;
import com.espertech.esper.common.internal.event.core.EventTypeSPI;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import com.espertech.esper.common.internal.event.core.MappedEventBean;
import com.espertech.esper.common.internal.event.core.ObjectArrayBackedEventBean;
import com.espertech.esper.common.internal.event.core.TypeBeanOrUnderlying;
import com.espertech.esper.common.internal.event.json.core.JsonEventType;
import com.espertech.esper.common.internal.event.map.MapEventPropertyGetter;
import com.espertech.esper.common.internal.event.map.MapEventType;
import com.espertech.esper.common.internal.event.property.IndexedProperty;
import com.espertech.esper.common.internal.event.property.MappedProperty;
import com.espertech.esper.common.internal.event.property.Property;
import com.espertech.esper.common.internal.event.property.PropertyParser;
import com.espertech.esper.common.internal.event.util.CodegenLegoPropertyBeanOrUnd;
import com.espertech.esper.common.internal.util.ClassHelperGenericType;
import com.espertech.esper.common.internal.util.ClassHelperPrint;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class BaseNestableEventUtil {
    public static MapEventType makeMapTypeCompileTime(EventTypeMetadata metadata, Map<String, Object> propertyTypes, EventType[] optionalSuperTypes, Set<EventType> optionalDeepSupertypes, String startTimestampPropertyName, String endTimestampPropertyName, BeanEventTypeFactory beanEventTypeFactory, EventTypeCompileTimeResolver eventTypeCompileTimeResolver) {
        if (metadata.getApplicationType() != EventTypeApplicationType.MAP) {
            throw new IllegalArgumentException("Invalid application type " + (Object)((Object)metadata.getApplicationType()));
        }
        LinkedHashMap<String, Object> verified = BaseNestableEventUtil.resolvePropertyTypes(propertyTypes, eventTypeCompileTimeResolver);
        return new MapEventType(metadata, verified, optionalSuperTypes, optionalDeepSupertypes, startTimestampPropertyName, endTimestampPropertyName, beanEventTypeFactory);
    }

    public static ObjectArrayEventType makeOATypeCompileTime(EventTypeMetadata metadata, Map<String, Object> properyTypes, EventType[] optionalSuperTypes, Set<EventType> optionalDeepSupertypes, String startTimestampName, String endTimestampName, BeanEventTypeFactory beanEventTypeFactory, EventTypeCompileTimeResolver eventTypeCompileTimeResolver) {
        if (metadata.getApplicationType() != EventTypeApplicationType.OBJECTARR) {
            throw new IllegalArgumentException("Invalid application type " + (Object)((Object)metadata.getApplicationType()));
        }
        LinkedHashMap<String, Object> verified = BaseNestableEventUtil.resolvePropertyTypes(properyTypes, eventTypeCompileTimeResolver);
        return new ObjectArrayEventType(metadata, verified, optionalSuperTypes, optionalDeepSupertypes, startTimestampName, endTimestampName, beanEventTypeFactory);
    }

    public static LinkedHashMap<String, Object> resolvePropertyTypes(Map<String, Object> propertyTypes, EventTypeNameResolver eventTypeNameResolver) {
        LinkedHashMap<String, Object> verified = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> prop : propertyTypes.entrySet()) {
            EventType eventType;
            Object[] types;
            String propertyName = prop.getKey();
            Object propertyType = prop.getValue();
            if (propertyType == null) {
                verified.put(propertyName, EPTypeNull.INSTANCE);
                continue;
            }
            if (propertyType instanceof EPType || propertyType instanceof EventType || propertyType instanceof TypeBeanOrUnderlying) {
                verified.put(propertyName, propertyType);
                continue;
            }
            if (propertyType instanceof EventType[]) {
                types = (EventType[])propertyType;
                if (types.length != 1 || types[0] == null) {
                    throw new IllegalArgumentException("Invalid null event type array");
                }
                verified.put(propertyName, propertyType);
                continue;
            }
            if (propertyType instanceof TypeBeanOrUnderlying[]) {
                types = (TypeBeanOrUnderlying[])propertyType;
                if (types.length != 1 || types[0] == null) {
                    throw new IllegalArgumentException("Invalid null event type array");
                }
                verified.put(propertyName, propertyType);
                continue;
            }
            if (propertyType instanceof Map) {
                LinkedHashMap<String, Object> inner = BaseNestableEventUtil.resolvePropertyTypes((Map)propertyType, eventTypeNameResolver);
                verified.put(propertyName, inner);
                continue;
            }
            if (!(propertyType instanceof String)) {
                throw BaseNestableEventUtil.makeUnexpectedTypeException(propertyType.toString(), propertyName);
            }
            String propertyTypeName = propertyType.toString();
            boolean isArray = EventTypeUtility.isPropertyArray(propertyTypeName);
            if (isArray) {
                propertyTypeName = EventTypeUtility.getPropertyRemoveArray(propertyTypeName);
            }
            if (!((eventType = eventTypeNameResolver.getTypeByName(propertyTypeName)) instanceof BaseNestableEventType) && !(eventType instanceof BeanEventType)) {
                Class<?> clazz = JavaClassHelper.getPrimitiveClassForName(propertyTypeName);
                if (clazz != null) {
                    verified.put(propertyName, ClassHelperGenericType.getClassEPType(clazz));
                    continue;
                }
                throw BaseNestableEventUtil.makeUnexpectedTypeException(propertyTypeName, propertyName);
            }
            if (eventType instanceof BaseNestableEventType) {
                TypeBeanOrUnderlying[] typeBeanOrUnderlyingArray;
                if (!isArray) {
                    typeBeanOrUnderlyingArray = new TypeBeanOrUnderlying(eventType);
                } else {
                    TypeBeanOrUnderlying[] typeBeanOrUnderlyingArray2 = new TypeBeanOrUnderlying[1];
                    typeBeanOrUnderlyingArray = typeBeanOrUnderlyingArray2;
                    typeBeanOrUnderlyingArray2[0] = new TypeBeanOrUnderlying(eventType);
                }
                TypeBeanOrUnderlying[] type = typeBeanOrUnderlyingArray;
                verified.put(propertyName, type);
                continue;
            }
            BeanEventType beanEventType = (BeanEventType)eventType;
            Class<?> type = !isArray ? beanEventType.getUnderlyingType() : JavaClassHelper.getArrayType(beanEventType.getUnderlyingType());
            verified.put(propertyName, type);
        }
        return verified;
    }

    private static EPException makeUnexpectedTypeException(String propertyTypeName, String propertyName) {
        return new EPException("Nestable type configuration encountered an unexpected property type name '" + propertyTypeName + "' for property '" + propertyName + "', expected java.lang.Class or java.util.Map or the name of a previously-declared event type");
    }

    public static Map<String, Object> checkedCastUnderlyingMap(EventBean theEvent) throws PropertyAccessException {
        return (Map)theEvent.getUnderlying();
    }

    public static Object[] checkedCastUnderlyingObjectArray(EventBean theEvent) throws PropertyAccessException {
        return (Object[])theEvent.getUnderlying();
    }

    public static Object getBNArrayValueAtIndex(Object value, int index) {
        if (!value.getClass().isArray()) {
            return null;
        }
        if (Array.getLength(value) <= index) {
            return null;
        }
        return Array.get(value, index);
    }

    public static Object getBNArrayValueAtIndexWithNullCheck(Object value, int index) {
        if (value == null) {
            return null;
        }
        return BaseNestableEventUtil.getBNArrayValueAtIndex(value, index);
    }

    public static Object handleBNCreateFragmentMap(Object value, EventType fragmentEventType, EventBeanTypedEventFactory eventBeanTypedEventFactory) {
        if (!(value instanceof Map)) {
            if (value instanceof EventBean) {
                return value;
            }
            return null;
        }
        Map subEvent = (Map)value;
        return eventBeanTypedEventFactory.adapterForTypedMap(subEvent, fragmentEventType);
    }

    public static Object getBNFragmentPojo(Object result, BeanEventType eventType, EventBeanTypedEventFactory eventBeanTypedEventFactory) {
        if (result == null) {
            return null;
        }
        if (result instanceof EventBean[]) {
            return result;
        }
        if (result instanceof EventBean) {
            return result;
        }
        if (result.getClass().isArray()) {
            int len = Array.getLength(result);
            EventBean[] events = new EventBean[len];
            for (int i = 0; i < events.length; ++i) {
                events[i] = eventBeanTypedEventFactory.adapterForTypedBean(Array.get(result, i), eventType);
            }
            return events;
        }
        if (result instanceof Collection) {
            Collection collection = (Collection)result;
            EventBean[] events = new EventBean[collection.size()];
            Iterator it = collection.iterator();
            int index = 0;
            while (it.hasNext()) {
                Object row = it.next();
                events[index] = eventBeanTypedEventFactory.adapterForTypedBean(row, eventType);
                ++index;
            }
            return events;
        }
        return eventBeanTypedEventFactory.adapterForTypedBean(result, eventType);
    }

    public static Object handleBNCreateFragmentObjectArray(Object value, EventType fragmentEventType, EventBeanTypedEventFactory eventBeanTypedEventFactory) {
        if (!(value instanceof Object[])) {
            if (value instanceof EventBean) {
                return value;
            }
            return null;
        }
        Object[] subEvent = (Object[])value;
        return eventBeanTypedEventFactory.adapterForTypedObjectArray(subEvent, fragmentEventType);
    }

    public static Object handleNestedValueArrayWithMap(Object value, int index, MapEventPropertyGetter getter) {
        Object valueMap = BaseNestableEventUtil.getBNArrayValueAtIndex(value, index);
        if (!(valueMap instanceof Map)) {
            if (valueMap instanceof EventBean) {
                return getter.get((EventBean)valueMap);
            }
            return null;
        }
        return getter.getMap((Map)valueMap);
    }

    public static CodegenExpression handleNestedValueArrayWithMapCode(int index, MapEventPropertyGetter getter, CodegenExpression ref, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope, Class generator) {
        CodegenMethod method = CodegenLegoPropertyBeanOrUnd.from(codegenMethodScope, codegenClassScope, EPTypePremade.MAP.getEPType(), getter, CodegenLegoPropertyBeanOrUnd.AccessType.GET, generator);
        return CodegenExpressionBuilder.localMethod(method, CodegenExpressionBuilder.staticMethod(BaseNestableEventUtil.class, "getBNArrayValueAtIndex", ref, CodegenExpressionBuilder.constant(index)));
    }

    public static Object handleBNNestedValueArrayWithMapFragment(Object value, int index, MapEventPropertyGetter getter, EventBeanTypedEventFactory eventBeanTypedEventFactory, EventType fragmentType) {
        Object valueMap = BaseNestableEventUtil.getBNArrayValueAtIndex(value, index);
        if (!(valueMap instanceof Map)) {
            if (value instanceof EventBean) {
                return getter.getFragment((EventBean)value);
            }
            return null;
        }
        MappedEventBean eventBean = eventBeanTypedEventFactory.adapterForTypedMap((Map)valueMap, fragmentType);
        return getter.getFragment(eventBean);
    }

    public static CodegenExpression handleBNNestedValueArrayWithMapFragmentCode(int index, MapEventPropertyGetter getter, CodegenExpression ref, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope, EventBeanTypedEventFactory eventBeanTypedEventFactory, EventType fragmentType, Class generator) {
        CodegenMethod method = CodegenLegoPropertyBeanOrUnd.from(codegenMethodScope, codegenClassScope, EPTypePremade.MAP.getEPType(), getter, CodegenLegoPropertyBeanOrUnd.AccessType.FRAGMENT, generator);
        return CodegenExpressionBuilder.localMethod(method, CodegenExpressionBuilder.staticMethod(BaseNestableEventUtil.class, "getBNArrayValueAtIndex", ref, CodegenExpressionBuilder.constant(index)));
    }

    public static boolean handleNestedValueArrayWithMapExists(Object value, int index, MapEventPropertyGetter getter) {
        Object valueMap = BaseNestableEventUtil.getBNArrayValueAtIndex(value, index);
        if (!(valueMap instanceof Map)) {
            if (valueMap instanceof EventBean) {
                return getter.isExistsProperty((EventBean)valueMap);
            }
            return false;
        }
        return getter.isMapExistsProperty((Map)valueMap);
    }

    public static CodegenExpression handleNestedValueArrayWithMapExistsCode(int index, MapEventPropertyGetter getter, CodegenExpression ref, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope, Class generator) {
        CodegenMethod method = CodegenLegoPropertyBeanOrUnd.from(codegenMethodScope, codegenClassScope, EPTypePremade.MAP.getEPType(), getter, CodegenLegoPropertyBeanOrUnd.AccessType.EXISTS, generator);
        return CodegenExpressionBuilder.localMethod(method, CodegenExpressionBuilder.staticMethod(BaseNestableEventUtil.class, "getBNArrayValueAtIndex", ref, CodegenExpressionBuilder.constant(index)));
    }

    public static Object handleNestedValueArrayWithObjectArray(Object value, int index, ObjectArrayEventPropertyGetter getter) {
        Object valueArray = BaseNestableEventUtil.getBNArrayValueAtIndex(value, index);
        if (!(valueArray instanceof Object[])) {
            if (valueArray instanceof EventBean) {
                return getter.get((EventBean)valueArray);
            }
            return null;
        }
        return getter.getObjectArray((Object[])valueArray);
    }

    public static CodegenExpression handleNestedValueArrayWithObjectArrayCodegen(int index, ObjectArrayEventPropertyGetter getter, CodegenExpression ref, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope, Class generator) {
        CodegenMethod method = CodegenLegoPropertyBeanOrUnd.from(codegenMethodScope, codegenClassScope, EPTypePremade.OBJECTARRAY.getEPType(), getter, CodegenLegoPropertyBeanOrUnd.AccessType.GET, generator);
        return CodegenExpressionBuilder.localMethod(method, CodegenExpressionBuilder.staticMethod(BaseNestableEventUtil.class, "getBNArrayValueAtIndex", ref, CodegenExpressionBuilder.constant(index)));
    }

    public static boolean handleNestedValueArrayWithObjectArrayExists(Object value, int index, ObjectArrayEventPropertyGetter getter) {
        Object valueArray = BaseNestableEventUtil.getBNArrayValueAtIndex(value, index);
        if (!(valueArray instanceof Object[])) {
            if (valueArray instanceof EventBean) {
                return getter.isExistsProperty((EventBean)valueArray);
            }
            return false;
        }
        return getter.isObjectArrayExistsProperty((Object[])valueArray);
    }

    public static CodegenExpression handleNestedValueArrayWithObjectArrayExistsCodegen(int index, ObjectArrayEventPropertyGetter getter, CodegenExpression ref, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope, Class generator) {
        CodegenMethod method = CodegenLegoPropertyBeanOrUnd.from(codegenMethodScope, codegenClassScope, EPTypePremade.OBJECTARRAY.getEPType(), getter, CodegenLegoPropertyBeanOrUnd.AccessType.EXISTS, generator);
        return CodegenExpressionBuilder.localMethod(method, CodegenExpressionBuilder.staticMethod(BaseNestableEventUtil.class, "getBNArrayValueAtIndex", ref, CodegenExpressionBuilder.constant(index)));
    }

    public static Object handleNestedValueArrayWithObjectArrayFragment(Object value, int index, ObjectArrayEventPropertyGetter getter, EventType fragmentType, EventBeanTypedEventFactory eventBeanTypedEventFactory) {
        Object valueArray = BaseNestableEventUtil.getBNArrayValueAtIndex(value, index);
        if (!(valueArray instanceof Object[])) {
            if (value instanceof EventBean) {
                return getter.getFragment((EventBean)value);
            }
            return null;
        }
        ObjectArrayBackedEventBean eventBean = eventBeanTypedEventFactory.adapterForTypedObjectArray((Object[])valueArray, fragmentType);
        return getter.getFragment(eventBean);
    }

    public static CodegenExpression handleNestedValueArrayWithObjectArrayFragmentCodegen(int index, ObjectArrayEventPropertyGetter getter, CodegenExpression ref, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope, Class generator) {
        CodegenMethod method = CodegenLegoPropertyBeanOrUnd.from(codegenMethodScope, codegenClassScope, EPTypePremade.OBJECTARRAY.getEPType(), getter, CodegenLegoPropertyBeanOrUnd.AccessType.FRAGMENT, generator);
        return CodegenExpressionBuilder.localMethod(method, CodegenExpressionBuilder.staticMethod(BaseNestableEventUtil.class, "getBNArrayValueAtIndex", ref, CodegenExpressionBuilder.constant(index)));
    }

    public static Object getMappedPropertyValue(Object value, String key) {
        if (value == null) {
            return null;
        }
        if (!(value instanceof Map)) {
            return null;
        }
        Map innerMap = (Map)value;
        return innerMap.get(key);
    }

    public static boolean getMappedPropertyExists(Object value, String key) {
        if (value == null) {
            return false;
        }
        if (!(value instanceof Map)) {
            return false;
        }
        Map innerMap = (Map)value;
        return innerMap.containsKey(key);
    }

    public static MapIndexedPropPair getIndexedAndMappedProps(String[] properties) {
        HashSet<String> mapPropertiesToCopy = new HashSet<String>();
        HashSet<String> arrayPropertiesToCopy = new HashSet<String>();
        for (int i = 0; i < properties.length; ++i) {
            Property prop = PropertyParser.parseAndWalkLaxToSimple(properties[i]);
            if (prop instanceof MappedProperty) {
                MappedProperty mappedProperty = (MappedProperty)prop;
                mapPropertiesToCopy.add(mappedProperty.getPropertyNameAtomic());
            }
            if (!(prop instanceof IndexedProperty)) continue;
            IndexedProperty indexedProperty = (IndexedProperty)prop;
            arrayPropertiesToCopy.add(indexedProperty.getPropertyNameAtomic());
        }
        return new MapIndexedPropPair(mapPropertiesToCopy, arrayPropertiesToCopy);
    }

    public static boolean isExistsIndexedValue(Object value, int index) {
        if (value == null) {
            return false;
        }
        if (!value.getClass().isArray()) {
            return false;
        }
        return index < Array.getLength(value);
    }

    public static EventBean getBNFragmentNonPojo(Object fragmentUnderlying, EventType fragmentEventType, EventBeanTypedEventFactory eventBeanTypedEventFactory) {
        if (fragmentUnderlying == null) {
            return null;
        }
        if (fragmentEventType instanceof MapEventType) {
            return eventBeanTypedEventFactory.adapterForTypedMap((Map)fragmentUnderlying, fragmentEventType);
        }
        return eventBeanTypedEventFactory.adapterForTypedObjectArray((Object[])fragmentUnderlying, fragmentEventType);
    }

    public static Object getBNFragmentArray(Object value, EventType fragmentEventType, EventBeanTypedEventFactory eventBeanTypedEventFactory) {
        if (value instanceof Object[]) {
            Object[] subEvents = (Object[])value;
            int countNull = 0;
            for (Object subEvent : subEvents) {
                if (subEvent == null) continue;
                ++countNull;
            }
            EventBean[] outEvents = new EventBean[countNull];
            int count = 0;
            for (Object item : subEvents) {
                if (item == null) continue;
                outEvents[count++] = BaseNestableEventUtil.getBNFragmentNonPojo(item, fragmentEventType, eventBeanTypedEventFactory);
            }
            return outEvents;
        }
        if (!(value instanceof Map[])) {
            return null;
        }
        Map[] mapTypedSubEvents = (Map[])value;
        int countNull = 0;
        for (Map map : mapTypedSubEvents) {
            if (map == null) continue;
            ++countNull;
        }
        EventBean[] mapEvents = new EventBean[countNull];
        int count = 0;
        for (Map map : mapTypedSubEvents) {
            if (map == null) continue;
            mapEvents[count++] = eventBeanTypedEventFactory.adapterForTypedMap(map, fragmentEventType);
        }
        return mapEvents;
    }

    public static Object getBeanArrayValue(BeanEventPropertyGetter nestedGetter, Object value, int index) {
        if (value == null) {
            return null;
        }
        if (!value.getClass().isArray()) {
            return null;
        }
        if (Array.getLength(value) <= index) {
            return null;
        }
        Object arrayItem = Array.get(value, index);
        if (arrayItem == null) {
            return null;
        }
        return nestedGetter.getBeanProp(arrayItem);
    }

    public static CodegenMethod getBeanArrayValueCodegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope, BeanEventPropertyGetter nestedGetter, int index) {
        return codegenMethodScope.makeChild(EPTypePremade.OBJECT.getEPType(), BaseNestableEventUtil.class, (CodegenScope)codegenClassScope).addParam(EPTypePremade.OBJECT.getEPType(), "value").getBlock().ifRefNullReturnNull("value").ifConditionReturnConst(CodegenExpressionBuilder.not(CodegenExpressionBuilder.exprDotMethodChain(CodegenExpressionBuilder.ref("value")).add("getClass", new CodegenExpression[0]).add("isArray", new CodegenExpression[0])), null).ifConditionReturnConst(CodegenExpressionBuilder.relational(CodegenExpressionBuilder.staticMethod(Array.class, "getLength", CodegenExpressionBuilder.ref("value")), CodegenExpressionRelational.CodegenRelational.LE, CodegenExpressionBuilder.constant(index)), null).declareVar(EPTypePremade.OBJECT.getEPType(), "arrayItem", CodegenExpressionBuilder.staticMethod(Array.class, "get", CodegenExpressionBuilder.ref("value"), CodegenExpressionBuilder.constant(index))).ifRefNullReturnNull("arrayItem").methodReturn(nestedGetter.underlyingGetCodegen(CodegenExpressionBuilder.cast(nestedGetter.getTargetType(), (CodegenExpression)CodegenExpressionBuilder.ref("arrayItem")), codegenMethodScope, codegenClassScope));
    }

    public static CodegenMethod getBeanArrayValueExistsCodegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope, BeanEventPropertyGetter nestedGetter, int index) {
        return codegenMethodScope.makeChild(EPTypePremade.BOOLEANPRIMITIVE.getEPType(), BaseNestableEventUtil.class, (CodegenScope)codegenClassScope).addParam(EPTypePremade.OBJECT.getEPType(), "value").getBlock().ifRefNullReturnFalse("value").ifConditionReturnConst(CodegenExpressionBuilder.not(CodegenExpressionBuilder.exprDotMethodChain(CodegenExpressionBuilder.ref("value")).add("getClass", new CodegenExpression[0]).add("isArray", new CodegenExpression[0])), false).ifConditionReturnConst(CodegenExpressionBuilder.relational(CodegenExpressionBuilder.staticMethod(Array.class, "getLength", CodegenExpressionBuilder.ref("value")), CodegenExpressionRelational.CodegenRelational.LE, CodegenExpressionBuilder.constant(index)), false).declareVar(EPTypePremade.OBJECT.getEPType(), "arrayItem", CodegenExpressionBuilder.staticMethod(Array.class, "get", CodegenExpressionBuilder.ref("value"), CodegenExpressionBuilder.constant(index))).ifRefNullReturnFalse("arrayItem").methodReturn(nestedGetter.underlyingExistsCodegen(CodegenExpressionBuilder.cast(nestedGetter.getTargetType(), (CodegenExpression)CodegenExpressionBuilder.ref("arrayItem")), codegenMethodScope, codegenClassScope));
    }

    public static Object getArrayPropertyValue(EventBean[] wrapper, int index, EventPropertyGetter nestedGetter) {
        if (wrapper == null) {
            return null;
        }
        if (wrapper.length <= index) {
            return null;
        }
        EventBean innerArrayEvent = wrapper[index];
        return nestedGetter.get(innerArrayEvent);
    }

    public static CodegenMethod getArrayPropertyValueCodegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope, int index, EventPropertyGetterSPI nestedGetter) {
        return codegenMethodScope.makeChild(EPTypePremade.OBJECT.getEPType(), BaseNestableEventUtil.class, (CodegenScope)codegenClassScope).addParam(EventBean.EPTYPEARRAY, "wrapper").getBlock().ifRefNullReturnNull("wrapper").ifConditionReturnConst(CodegenExpressionBuilder.relational(CodegenExpressionBuilder.arrayLength(CodegenExpressionBuilder.ref("wrapper")), CodegenExpressionRelational.CodegenRelational.LE, CodegenExpressionBuilder.constant(index)), null).declareVar(EventBean.EPTYPE, "inner", CodegenExpressionBuilder.arrayAtIndex(CodegenExpressionBuilder.ref("wrapper"), CodegenExpressionBuilder.constant(index))).methodReturn(nestedGetter.eventBeanGetCodegen(CodegenExpressionBuilder.ref("inner"), codegenMethodScope, codegenClassScope));
    }

    public static Object getArrayPropertyFragment(EventBean[] wrapper, int index, EventPropertyGetter nestedGetter) {
        if (wrapper == null) {
            return null;
        }
        if (wrapper.length <= index) {
            return null;
        }
        EventBean innerArrayEvent = wrapper[index];
        return nestedGetter.getFragment(innerArrayEvent);
    }

    public static CodegenMethod getArrayPropertyFragmentCodegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope, int index, EventPropertyGetterSPI nestedGetter) {
        return codegenMethodScope.makeChild(EPTypePremade.OBJECT.getEPType(), BaseNestableEventUtil.class, (CodegenScope)codegenClassScope).addParam(EventBean.EPTYPEARRAY, "wrapper").getBlock().ifRefNullReturnNull("wrapper").ifConditionReturnConst(CodegenExpressionBuilder.relational(CodegenExpressionBuilder.arrayLength(CodegenExpressionBuilder.ref("wrapper")), CodegenExpressionRelational.CodegenRelational.LE, CodegenExpressionBuilder.constant(index)), null).declareVar(EventBean.EPTYPE, "inner", CodegenExpressionBuilder.arrayAtIndex(CodegenExpressionBuilder.ref("wrapper"), CodegenExpressionBuilder.constant(index))).methodReturn(nestedGetter.eventBeanFragmentCodegen(CodegenExpressionBuilder.ref("inner"), codegenMethodScope, codegenClassScope));
    }

    public static Object getBNArrayPropertyUnderlying(EventBean[] wrapper, int index) {
        if (wrapper == null) {
            return null;
        }
        if (wrapper.length <= index) {
            return null;
        }
        return wrapper[index].getUnderlying();
    }

    public static Object getBNArrayPropertyBean(EventBean[] wrapper, int index) {
        if (wrapper == null) {
            return null;
        }
        if (wrapper.length <= index) {
            return null;
        }
        return wrapper[index];
    }

    public static Object getArrayPropertyAsUnderlyingsArray(EPTypeClass underlyingType, EventBean[] wrapper) {
        if (wrapper != null) {
            Object array = Array.newInstance(underlyingType.getType(), wrapper.length);
            for (int i = 0; i < wrapper.length; ++i) {
                Array.set(array, i, wrapper[i].getUnderlying());
            }
            return array;
        }
        return null;
    }

    public static CodegenMethod getArrayPropertyAsUnderlyingsArrayCodegen(EPTypeClass underlyingType, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        EPTypeClass arrayType = JavaClassHelper.getArrayType(underlyingType);
        return codegenMethodScope.makeChild(EPTypePremade.OBJECT.getEPType(), BaseNestableEventUtil.class, (CodegenScope)codegenClassScope).addParam(EventBean.EPTYPEARRAY, "wrapper").getBlock().ifRefNullReturnNull("wrapper").declareVar(arrayType, "array", CodegenExpressionBuilder.newArrayByLength(underlyingType, CodegenExpressionBuilder.arrayLength(CodegenExpressionBuilder.ref("wrapper")))).forLoopIntSimple("i", CodegenExpressionBuilder.arrayLength(CodegenExpressionBuilder.ref("wrapper"))).assignArrayElement("array", (CodegenExpression)CodegenExpressionBuilder.ref("i"), CodegenExpressionBuilder.cast(underlyingType, CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.arrayAtIndex(CodegenExpressionBuilder.ref("wrapper"), CodegenExpressionBuilder.ref("i")), "getUnderlying", new CodegenExpression[0]))).blockEnd().methodReturn(CodegenExpressionBuilder.ref("array"));
    }

    public static ExprValidationException comparePropType(String propName, Object setOneType, boolean setOneTypeFound, Object setTwoType, String otherName) {
        if (BaseNestableEventUtil.isNestedType(setOneType) && setTwoType == null) {
            return null;
        }
        if (BaseNestableEventUtil.isNestedType(setTwoType) && setOneType == null) {
            return null;
        }
        if (!setOneTypeFound) {
            return new ExprValidationException("Type by name '" + otherName + "' in property '" + propName + "' property name not found in target");
        }
        if (setTwoType == null || setTwoType == EPTypeNull.INSTANCE) {
            return null;
        }
        if (setOneType == null || setOneType == EPTypeNull.INSTANCE) {
            return new ExprValidationException("Type by name '" + otherName + "' in property '" + propName + "' expects a null-value but receives '" + setTwoType + "'");
        }
        if (setTwoType instanceof EPTypeClass && setOneType instanceof EPTypeClass) {
            Class<?> boxedThis;
            Class<?> boxedOther = JavaClassHelper.getBoxedType((EPTypeClass)setTwoType).getType();
            if (!boxedOther.equals(boxedThis = JavaClassHelper.getBoxedType((EPTypeClass)setOneType).getType()) && !JavaClassHelper.isSubclassOrImplementsInterface(boxedOther, boxedThis)) {
                return BaseNestableEventUtil.makeExpectedReceivedException(otherName, propName, boxedThis, boxedOther);
            }
        } else if (setTwoType instanceof EventType && BaseNestableEventUtil.isNativeUnderlyingType((EventType)setTwoType) && setOneType instanceof EPTypeClass) {
            Class<?> boxedThis;
            Class<?> boxedOther = JavaClassHelper.getBoxedType(((EventType)setTwoType).getUnderlyingType());
            if (!boxedOther.equals(boxedThis = JavaClassHelper.getBoxedType((EPTypeClass)setOneType).getType())) {
                return BaseNestableEventUtil.makeExpectedReceivedException(otherName, propName, boxedThis, boxedOther);
            }
        } else if (setTwoType instanceof EventType[] && BaseNestableEventUtil.isNativeUnderlyingType(((EventType[])setTwoType)[0]) && setOneType instanceof EPTypeClass && ((EPTypeClass)setOneType).getType().isArray()) {
            Class<?> boxedThis;
            Class<?> boxedOther = JavaClassHelper.getBoxedType(((EventType[])setTwoType)[0].getUnderlyingType());
            if (!boxedOther.equals(boxedThis = JavaClassHelper.getBoxedType(((EPTypeClass)setOneType).getType().getComponentType()))) {
                return BaseNestableEventUtil.makeExpectedReceivedException(otherName, propName, boxedThis, boxedOther);
            }
        } else if (setTwoType instanceof Map && setOneType instanceof Map) {
            ExprValidationException messageIsDeepEquals = BaseNestableEventType.isDeepEqualsProperties(propName, (Map)setOneType, (Map)setTwoType, true);
            if (messageIsDeepEquals != null) {
                return messageIsDeepEquals;
            }
        } else if (setTwoType instanceof EventType && setOneType instanceof EventType) {
            boolean mismatch;
            if (setTwoType instanceof EventTypeSPI && setOneType instanceof EventTypeSPI) {
                ExprValidationException compared = ((EventTypeSPI)setOneType).equalsCompareType((EventTypeSPI)setTwoType);
                mismatch = compared != null;
            } else {
                boolean bl = mismatch = !setOneType.equals(setTwoType);
            }
            if (mismatch) {
                EventType setOneEventType = (EventType)setOneType;
                EventType setTwoEventType = (EventType)setTwoType;
                return BaseNestableEventUtil.getMismatchMessageEventType(otherName, propName, setOneEventType, setTwoEventType);
            }
        } else if (setTwoType instanceof TypeBeanOrUnderlying && setOneType instanceof EventType) {
            EventType setOneEventType = (EventType)setOneType;
            EventType setTwoEventType = ((TypeBeanOrUnderlying)setTwoType).getEventType();
            if (!EventTypeUtility.isTypeOrSubTypeOf(setTwoEventType, setOneEventType)) {
                return BaseNestableEventUtil.getMismatchMessageEventType(otherName, propName, setOneEventType, setTwoEventType);
            }
        } else if (setTwoType instanceof EventType && setOneType instanceof TypeBeanOrUnderlying) {
            EventType setTwoEventType = (EventType)setTwoType;
            EventType setOneEventType = ((TypeBeanOrUnderlying)setOneType).getEventType();
            if (!EventTypeUtility.isTypeOrSubTypeOf(setTwoEventType, setOneEventType)) {
                return BaseNestableEventUtil.getMismatchMessageEventType(otherName, propName, setOneEventType, setTwoEventType);
            }
        } else if (setTwoType instanceof TypeBeanOrUnderlying && setOneType instanceof TypeBeanOrUnderlying) {
            EventType setTwoEventType;
            EventType setOneEventType = ((TypeBeanOrUnderlying)setOneType).getEventType();
            if (!EventTypeUtility.isTypeOrSubTypeOf(setOneEventType, setTwoEventType = ((TypeBeanOrUnderlying)setTwoType).getEventType())) {
                return BaseNestableEventUtil.getMismatchMessageEventType(otherName, propName, setOneEventType, setTwoEventType);
            }
        } else if (setTwoType instanceof EventType[] && setOneType instanceof TypeBeanOrUnderlying[]) {
            EventType setTwoEventType = ((EventType[])setTwoType)[0];
            EventType setOneEventType = ((TypeBeanOrUnderlying[])setOneType)[0].getEventType();
            if (!EventTypeUtility.isTypeOrSubTypeOf(setOneEventType, setTwoEventType)) {
                return BaseNestableEventUtil.getMismatchMessageEventType(otherName, propName, setOneEventType, setTwoEventType);
            }
        } else {
            String typeTwo;
            String typeOne = BaseNestableEventUtil.getTypeName(setOneType);
            if (typeOne.equals(typeTwo = BaseNestableEventUtil.getTypeName(setTwoType))) {
                return null;
            }
            return new ExprValidationException("Type by name '" + otherName + "' in property '" + propName + "' expected " + typeOne + " but receives " + typeTwo);
        }
        return null;
    }

    private static ExprValidationException makeExpectedReceivedException(String otherName, String propName, Class boxedThis, Class boxedOther) {
        return new ExprValidationException("Type by name '" + otherName + "' in property '" + propName + "' expected " + ClassHelperPrint.getClassNameFullyQualPretty(boxedThis) + " but receives " + ClassHelperPrint.getClassNameFullyQualPretty(boxedOther));
    }

    private static ExprValidationException getMismatchMessageEventType(String otherName, String propName, EventType setOneEventType, EventType setTwoEventType) {
        return new ExprValidationException("Type by name '" + otherName + "' in property '" + propName + "' expected event type '" + setOneEventType.getName() + "' but receives event type '" + setTwoEventType.getName() + "'");
    }

    private static boolean isNestedType(Object type) {
        return type instanceof TypeBeanOrUnderlying || type instanceof EventType || type instanceof TypeBeanOrUnderlying[] || type instanceof EventType[];
    }

    private static String getTypeName(Object type) {
        if (type == null) {
            return "null";
        }
        if (type instanceof EPTypeClass) {
            return ((EPTypeClass)type).getType().getName();
        }
        if (type instanceof EventType) {
            return "event type '" + ((EventType)type).getName() + "'";
        }
        if (type instanceof EventType[]) {
            return "event type array '" + ((EventType[])type)[0].getName() + "'";
        }
        if (type instanceof TypeBeanOrUnderlying) {
            return "event type '" + ((TypeBeanOrUnderlying)type).getEventType().getName() + "'";
        }
        if (type instanceof TypeBeanOrUnderlying[]) {
            return "event type array '" + ((TypeBeanOrUnderlying[])type)[0].getEventType().getName() + "'";
        }
        return type.getClass().getName();
    }

    private static boolean isNativeUnderlyingType(EventType eventType) {
        if (eventType instanceof BeanEventType) {
            return true;
        }
        if (eventType instanceof JsonEventType) {
            return ((JsonEventType)eventType).getDetail().getOptionalUnderlyingProvided() != null;
        }
        return false;
    }

    public static class MapIndexedPropPair {
        private final Set<String> mapProperties;
        private final Set<String> arrayProperties;

        public MapIndexedPropPair(Set<String> mapProperties, Set<String> arrayProperties) {
            this.mapProperties = mapProperties;
            this.arrayProperties = arrayProperties;
        }

        public Set<String> getMapProperties() {
            return this.mapProperties;
        }

        public Set<String> getArrayProperties() {
            return this.arrayProperties;
        }
    }
}

