/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.core;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.event.arr.ObjectArrayEventType;
import com.espertech.esper.common.internal.event.avro.AvroSchemaEventType;
import com.espertech.esper.common.internal.event.bean.core.BeanEventType;
import com.espertech.esper.common.internal.event.core.MappedEventBean;
import com.espertech.esper.common.internal.event.core.ObjectArrayBackedEventBean;
import com.espertech.esper.common.internal.event.core.WrapperEventType;
import com.espertech.esper.common.internal.event.json.core.JsonEventType;
import com.espertech.esper.common.internal.event.map.MapEventType;
import com.espertech.esper.common.internal.event.xml.BaseXMLEventType;
import java.util.Map;
import org.w3c.dom.Node;

public interface EventBeanTypedEventFactory {
    public static final EPTypeClass EPTYPE = new EPTypeClass(EventBeanTypedEventFactory.class);
    public static final String ADAPTERFORTYPEDMAP = "adapterForTypedMap";
    public static final String ADAPTERFORTYPEDOBJECTARRAY = "adapterForTypedObjectArray";
    public static final String ADAPTERFORTYPEDBEAN = "adapterForTypedBean";
    public static final String ADAPTERFORTYPEDDOM = "adapterForTypedDOM";
    public static final String ADAPTERFORTYPEDAVRO = "adapterForTypedAvro";
    public static final String ADAPTERFORTYPEDWRAPPER = "adapterForTypedWrapper";
    public static final String ADAPTERFORTYPEDJSON = "adapterForTypedJson";

    public MappedEventBean adapterForTypedMap(Map<String, Object> var1, EventType var2);

    public ObjectArrayBackedEventBean adapterForTypedObjectArray(Object[] var1, EventType var2);

    public EventBean adapterForTypedBean(Object var1, EventType var2);

    public EventBean adapterForTypedDOM(Node var1, EventType var2);

    public EventBean adapterForTypedAvro(Object var1, EventType var2);

    public EventBean adapterForTypedWrapper(EventBean var1, Map<String, Object> var2, EventType var3);

    public EventBean adapterForTypedJson(Object var1, EventType var2);

    default public EventBean adapterForGivenType(Object value, EventType eventType) {
        if (eventType instanceof BeanEventType) {
            return this.adapterForTypedBean(value, eventType);
        }
        if (eventType instanceof MapEventType) {
            return this.adapterForTypedMap((Map)value, eventType);
        }
        if (eventType instanceof ObjectArrayEventType) {
            return this.adapterForTypedObjectArray((Object[])value, eventType);
        }
        if (eventType instanceof JsonEventType) {
            return this.adapterForTypedJson(value, eventType);
        }
        if (eventType instanceof AvroSchemaEventType) {
            return this.adapterForTypedAvro(value, eventType);
        }
        if (eventType instanceof BaseXMLEventType) {
            return this.adapterForTypedDOM((Node)value, eventType);
        }
        if (eventType instanceof WrapperEventType) {
            throw new UnsupportedOperationException("EventBean allocation for wrapper event types without the decorated event type is not supported");
        }
        throw new UnsupportedOperationException("Event type " + eventType.getName() + " of type " + eventType.getClass().getSimpleName() + " is not a recognized type");
    }
}

