/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.eventtyperepo;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.configuration.ConfigurationException;
import com.espertech.esper.common.client.configuration.common.ConfigurationCommonEventTypeMap;
import com.espertech.esper.common.client.configuration.common.ConfigurationCommonEventTypeWithSupertype;
import com.espertech.esper.common.client.meta.EventTypeApplicationType;
import com.espertech.esper.common.client.meta.EventTypeIdPair;
import com.espertech.esper.common.client.meta.EventTypeMetadata;
import com.espertech.esper.common.client.meta.EventTypeTypeClass;
import com.espertech.esper.common.client.util.EventTypeBusModifier;
import com.espertech.esper.common.client.util.NameAccessModifier;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.event.bean.service.BeanEventTypeFactory;
import com.espertech.esper.common.internal.event.core.EventAdapterException;
import com.espertech.esper.common.internal.event.core.EventTypeNameResolver;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import com.espertech.esper.common.internal.event.eventtyperepo.EventTypeRepositoryImpl;
import com.espertech.esper.common.internal.event.eventtyperepo.EventTypeRepositoryUtil;
import com.espertech.esper.common.internal.event.map.MapEventType;
import com.espertech.esper.common.internal.settings.ClasspathImportService;
import com.espertech.esper.common.internal.util.CRC32Util;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.lang.reflect.Array;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class EventTypeRepositoryMapTypeUtil {
    public static void buildMapTypes(EventTypeRepositoryImpl repo, Map<String, ConfigurationCommonEventTypeMap> mapTypeConfigurations, Map<String, Properties> mapTypes, Map<String, Map<String, Object>> nestableMapEvents, BeanEventTypeFactory beanEventTypeFactory, ClasspathImportService classpathImportService) {
        List<String> creationOrder = EventTypeRepositoryUtil.getCreationOrder(mapTypes.keySet(), nestableMapEvents.keySet(), mapTypeConfigurations);
        for (String mapName : creationOrder) {
            Map<String, Object> propertiesNestable;
            if (repo.getTypeByName(mapName) != null) continue;
            ConfigurationCommonEventTypeMap mapConfig = mapTypeConfigurations.get(mapName);
            Properties propertiesUnnested = mapTypes.get(mapName);
            if (propertiesUnnested != null) {
                Map<String, Object> propertyTypes = EventTypeRepositoryMapTypeUtil.createPropertyTypes(propertiesUnnested, classpathImportService);
                LinkedHashMap<String, Object> propertyTypesCompiled = EventTypeUtility.compileMapTypeProperties(propertyTypes, repo);
                EventTypeRepositoryMapTypeUtil.addNestableMapType(mapName, propertyTypesCompiled, mapConfig, repo, beanEventTypeFactory, repo);
            }
            if ((propertiesNestable = nestableMapEvents.get(mapName)) == null) continue;
            LinkedHashMap<String, Object> propertiesNestableCompiled = EventTypeUtility.compileMapTypeProperties(propertiesNestable, repo);
            EventTypeRepositoryMapTypeUtil.addNestableMapType(mapName, propertiesNestableCompiled, mapConfig, repo, beanEventTypeFactory, repo);
        }
    }

    protected static Map<String, Set<String>> toTypesReferences(Map<String, ? extends ConfigurationCommonEventTypeWithSupertype> mapTypeConfigurations) {
        LinkedHashMap<String, Set<String>> result = new LinkedHashMap<String, Set<String>>();
        for (Map.Entry<String, ? extends ConfigurationCommonEventTypeWithSupertype> entry : mapTypeConfigurations.entrySet()) {
            result.put(entry.getKey(), entry.getValue().getSuperTypes());
        }
        return result;
    }

    private static void addNestableMapType(String eventTypeName, LinkedHashMap<String, Object> propertyTypesMayHavePrimitive, ConfigurationCommonEventTypeMap optionalConfig, EventTypeRepositoryImpl repo, BeanEventTypeFactory beanEventTypeFactory, EventTypeNameResolver eventTypeNameResolver) throws EventAdapterException {
        EventTypeMetadata metadata = new EventTypeMetadata(eventTypeName, null, EventTypeTypeClass.APPLICATION, EventTypeApplicationType.MAP, NameAccessModifier.PRECONFIGURED, EventTypeBusModifier.BUS, false, new EventTypeIdPair(CRC32Util.computeCRC32(eventTypeName), -1L));
        LinkedHashMap<String, Object> propertyTypes = EventTypeUtility.getPropertyTypesNonPrimitive(propertyTypesMayHavePrimitive);
        String[] superTypes = null;
        if (optionalConfig != null && optionalConfig.getSuperTypes() != null && !optionalConfig.getSuperTypes().isEmpty()) {
            superTypes = optionalConfig.getSuperTypes().toArray(new String[optionalConfig.getSuperTypes().size()]);
        }
        MapEventType newEventType = beanEventTypeFactory.getEventTypeFactory().createMap(metadata, propertyTypes, superTypes, optionalConfig != null ? optionalConfig.getStartTimestampPropertyName() : null, optionalConfig != null ? optionalConfig.getEndTimestampPropertyName() : null, beanEventTypeFactory, eventTypeNameResolver);
        EventType existingType = repo.getTypeByName(eventTypeName);
        if (existingType != null) {
            if (newEventType.equalsCompareType(existingType) != null) {
                ExprValidationException message = newEventType.compareEquals(existingType);
                throw new EPException("Event type named '" + eventTypeName + "' has already been declared with differing column name or type information: " + message.getMessage(), message);
            }
            return;
        }
        repo.addType(newEventType);
    }

    private static Map<String, Object> createPropertyTypes(Properties properties, ClasspathImportService classpathImportService) {
        LinkedHashMap<String, Object> propertyTypes = new LinkedHashMap<String, Object>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String property = (String)entry.getKey();
            String className = (String)entry.getValue();
            Class clazz = EventTypeRepositoryMapTypeUtil.resolveClassForTypeName(className, classpathImportService);
            if (clazz == null) continue;
            propertyTypes.put(property, clazz);
        }
        return propertyTypes;
    }

    private static Class resolveClassForTypeName(String type, ClasspathImportService classpathImportService) {
        boolean isArray = false;
        if (type != null && EventTypeUtility.isPropertyArray(type)) {
            isArray = true;
            type = EventTypeUtility.getPropertyRemoveArray(type);
        }
        if (type == null) {
            throw new ConfigurationException("A null value has been provided for the type");
        }
        Class<?> clazz = JavaClassHelper.getClassForSimpleName(type, classpathImportService.getClassForNameProvider());
        if (clazz == null) {
            throw new ConfigurationException("The type '" + type + "' is not a recognized type");
        }
        if (isArray) {
            clazz = Array.newInstance(clazz, 0).getClass();
        }
        return clazz;
    }
}

