/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.json.compiletime;

import com.espertech.esper.common.client.json.minimaljson.JsonWriter;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenPackageScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenSymbolProvider;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenSymbolProviderEmpty;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClass;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClassMethods;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClassType;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenCtor;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenTypedParam;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRelational;
import com.espertech.esper.common.internal.bytecodemodel.model.statement.CodegenStatementSwitch;
import com.espertech.esper.common.internal.bytecodemodel.util.CodegenStackGenerator;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeable;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeableType;
import com.espertech.esper.common.internal.event.json.compiletime.JsonUnderlyingField;
import com.espertech.esper.common.internal.event.json.compiletime.StmtClassForgeableJsonDesc;
import com.espertech.esper.common.internal.event.json.compiletime.StmtClassForgeableJsonUtil;
import com.espertech.esper.common.internal.event.json.core.JsonEventObjectBase;
import com.espertech.esper.common.internal.event.json.parser.forge.JsonForgeDesc;
import com.espertech.esper.common.internal.event.json.write.JsonWriteForgeRefs;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class StmtClassForgeableJsonUnderlying
implements StmtClassForgeable {
    public static final String DYNAMIC_PROP_FIELD = "__dyn";
    private final String className;
    private final CodegenPackageScope packageScope;
    private final StmtClassForgeableJsonDesc desc;

    public StmtClassForgeableJsonUnderlying(String className, CodegenPackageScope packageScope, StmtClassForgeableJsonDesc desc) {
        this.className = className;
        this.packageScope = packageScope;
        this.desc = desc;
    }

    @Override
    public CodegenClass forge(boolean includeDebugSymbols, boolean fireAndForget) {
        CodegenCtor ctor = new CodegenCtor(StmtClassForgeableJsonUnderlying.class, includeDebugSymbols, Collections.emptyList());
        if (this.needDynamic()) {
            ctor.getBlock().assignRef(DYNAMIC_PROP_FIELD, CodegenExpressionBuilder.newInstance(EPTypePremade.LINKEDHASHMAP.getEPType(), new CodegenExpression[0]));
        }
        CodegenClassMethods methods = new CodegenClassMethods();
        CodegenClassScope classScope = new CodegenClassScope(includeDebugSymbols, this.packageScope, this.className);
        ArrayList<CodegenTypedParam> explicitMembers = new ArrayList<CodegenTypedParam>(this.desc.getPropertiesThisType().size());
        if (this.needDynamic()) {
            explicitMembers.add(new CodegenTypedParam(EPTypePremade.MAP.getEPType(), DYNAMIC_PROP_FIELD, false, true));
        }
        for (Map.Entry<String, Object> property : this.desc.getPropertiesThisType().entrySet()) {
            JsonUnderlyingField field = this.desc.getFieldDescriptorsInclSupertype().get(property.getKey());
            explicitMembers.add(new CodegenTypedParam(field.getPropertyType(), field.getFieldName(), false, true));
        }
        CodegenMethod getNativeSizeMethod = CodegenMethod.makeParentNode(EPTypePremade.INTEGERPRIMITIVE.getEPType(), this.getClass(), (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope);
        getNativeSizeMethod.getBlock().methodReturn(CodegenExpressionBuilder.constant(this.desc.getPropertiesThisType().size() + this.desc.getNumFieldsSupertype()));
        CodegenStackGenerator.recursiveBuildStack(getNativeSizeMethod, "getNativeSize", methods);
        CodegenMethod getNativeEntryMethod = CodegenMethod.makeParentNode(EPTypePremade.MAPENTRY.getEPType(), this.getClass(), (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope).addParam(EPTypePremade.INTEGERPRIMITIVE.getEPType(), "num");
        this.makeGetNativeEntry(getNativeEntryMethod, classScope);
        CodegenStackGenerator.recursiveBuildStack(getNativeEntryMethod, "getNativeEntry", methods);
        CodegenMethod getNativeKey = CodegenMethod.makeParentNode(EPTypePremade.STRING.getEPType(), this.getClass(), (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope).addParam(EPTypePremade.INTEGERPRIMITIVE.getEPType(), "num");
        this.makeGetNativeKey(getNativeKey);
        CodegenStackGenerator.recursiveBuildStack(getNativeKey, "getNativeKey", methods);
        CodegenMethod nativeContainsKeyMethod = CodegenMethod.makeParentNode(EPTypePremade.BOOLEANPRIMITIVE.getEPType(), this.getClass(), (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope).addParam(EPTypePremade.OBJECT.getEPType(), "name");
        this.makeNativeContainsKey(nativeContainsKeyMethod);
        CodegenStackGenerator.recursiveBuildStack(nativeContainsKeyMethod, "nativeContainsKey", methods);
        CodegenMethod getNativeValueMethod = CodegenMethod.makeParentNode(EPTypePremade.OBJECT.getEPType(), this.getClass(), (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope).addParam(EPTypePremade.INTEGERPRIMITIVE.getEPType(), "num");
        this.makeGetNativeValueMethod(getNativeValueMethod, classScope);
        CodegenStackGenerator.recursiveBuildStack(getNativeValueMethod, "getNativeValue", methods);
        CodegenMethod getNativeNumMethod = CodegenMethod.makeParentNode(EPTypePremade.INTEGERPRIMITIVE.getEPType(), this.getClass(), (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope).addParam(EPTypePremade.STRING.getEPType(), "name");
        this.makeGetNativeNum(getNativeNumMethod, classScope);
        CodegenStackGenerator.recursiveBuildStack(getNativeNumMethod, "getNativeNum", methods);
        CodegenMethod nativeWriteMethod = CodegenMethod.makeParentNode(EPTypePremade.VOID.getEPType(), this.getClass(), (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope).addParam(JsonWriter.EPTYPE, "writer").addThrown(EPTypePremade.IOEXCEPTION.getEPType());
        this.makeNativeWrite(nativeWriteMethod, classScope);
        CodegenStackGenerator.recursiveBuildStack(nativeWriteMethod, "nativeWrite", methods);
        if (!this.parentDynamic()) {
            CodegenMethod addJsonValueMethod = CodegenMethod.makeParentNode(EPTypePremade.VOID.getEPType(), this.getClass(), (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope).addParam(EPTypePremade.STRING.getEPType(), "name").addParam(EPTypePremade.OBJECT.getEPType(), "value");
            if (this.needDynamic()) {
                addJsonValueMethod.getBlock().exprDotMethod(CodegenExpressionBuilder.ref(DYNAMIC_PROP_FIELD), "put", CodegenExpressionBuilder.ref("name"), CodegenExpressionBuilder.ref("value"));
            }
            CodegenStackGenerator.recursiveBuildStack(addJsonValueMethod, "addJsonValue", methods);
            CodegenMethod getJsonValuesMethod = CodegenMethod.makeParentNode(EPTypePremade.MAP.getEPType(), this.getClass(), (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope);
            getJsonValuesMethod.getBlock().methodReturn(this.desc.isDynamic() ? CodegenExpressionBuilder.ref(DYNAMIC_PROP_FIELD) : CodegenExpressionBuilder.publicConstValue(Collections.class, "EMPTY_MAP"));
            CodegenStackGenerator.recursiveBuildStack(getJsonValuesMethod, "getJsonValues", methods);
        }
        CodegenClass clazz = new CodegenClass(CodegenClassType.JSONEVENT, this.className, classScope, explicitMembers, ctor, methods, Collections.emptyList());
        if (this.desc.getOptionalSupertype() == null) {
            clazz.getSupers().setClassExtended(JsonEventObjectBase.EPTYPE);
        } else {
            clazz.getSupers().setClassExtended(this.desc.getOptionalSupertype().getUnderlyingEPType());
        }
        return clazz;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public StmtClassForgeableType getForgeableType() {
        return StmtClassForgeableType.JSONEVENT;
    }

    private void makeNativeWrite(CodegenMethod method, CodegenClassScope classScope) {
        boolean first = true;
        if (this.desc.getOptionalSupertype() != null && !this.desc.getOptionalSupertype().getTypes().isEmpty()) {
            method.getBlock().exprDotMethod(CodegenExpressionBuilder.ref("super"), "nativeWrite", CodegenExpressionBuilder.ref("writer"));
            first = false;
        }
        for (Map.Entry<String, Object> property : this.desc.getPropertiesThisType().entrySet()) {
            JsonUnderlyingField field = this.desc.getFieldDescriptorsInclSupertype().get(property.getKey());
            JsonForgeDesc forge = this.desc.getForges().get(property.getKey());
            String fieldName = field.getFieldName();
            if (!first) {
                method.getBlock().exprDotMethod(CodegenExpressionBuilder.ref("writer"), "writeObjectSeparator", new CodegenExpression[0]);
            }
            first = false;
            CodegenExpression write = forge.getWriteForge().codegenWrite(new JsonWriteForgeRefs(CodegenExpressionBuilder.ref("writer"), CodegenExpressionBuilder.ref(fieldName), CodegenExpressionBuilder.constant(property.getKey())), method, classScope);
            method.getBlock().exprDotMethod(CodegenExpressionBuilder.ref("writer"), "writeMemberName", CodegenExpressionBuilder.constant(property.getKey())).exprDotMethod(CodegenExpressionBuilder.ref("writer"), "writeMemberSeparator", new CodegenExpression[0]).expression(write);
        }
    }

    private void makeGetNativeNum(CodegenMethod method, CodegenClassScope classScope) {
        if (this.desc.getNumFieldsSupertype() > 0) {
            method.getBlock().declareVar(EPTypePremade.INTEGERPRIMITIVE.getEPType(), "parent", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("super"), "getNativeNum", CodegenExpressionBuilder.ref("name"))).ifCondition(CodegenExpressionBuilder.relational(CodegenExpressionBuilder.ref("parent"), CodegenExpressionRelational.CodegenRelational.GT, CodegenExpressionBuilder.constant(-1))).blockReturn(CodegenExpressionBuilder.ref("parent"));
        }
        CodegenExpression[] expressions = new CodegenExpression[this.desc.getPropertiesThisType().size()];
        for (Map.Entry<String, Object> property : this.desc.getPropertiesThisType().entrySet()) {
            JsonUnderlyingField field = this.desc.getFieldDescriptorsInclSupertype().get(property.getKey());
            expressions[field.getPropertyNumber() - this.desc.getNumFieldsSupertype()] = CodegenExpressionBuilder.constant(property.getKey());
        }
        CodegenStatementSwitch switchStmt = method.getBlock().switchBlockExpressions(CodegenExpressionBuilder.ref("name"), expressions, true, false);
        for (int i = 0; i < switchStmt.getBlocks().length; ++i) {
            switchStmt.getBlocks()[i].blockReturn(CodegenExpressionBuilder.constant(this.desc.getNumFieldsSupertype() + i));
        }
        method.getBlock().methodReturn(CodegenExpressionBuilder.constant(-1));
    }

    private void makeGetNativeValueMethod(CodegenMethod method, CodegenClassScope classScope) {
        if (this.desc.getNumFieldsSupertype() > 0) {
            method.getBlock().ifCondition(CodegenExpressionBuilder.relational(CodegenExpressionBuilder.ref("num"), CodegenExpressionRelational.CodegenRelational.LT, CodegenExpressionBuilder.constant(this.desc.getNumFieldsSupertype()))).blockReturn(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("super"), "getNativeValue", CodegenExpressionBuilder.ref("num")));
        }
        CodegenExpression[] cases = StmtClassForgeableJsonUtil.getCasesNumberNtoM(this.desc);
        CodegenStatementSwitch switchStmt = method.getBlock().switchBlockExpressions(CodegenExpressionBuilder.ref("num"), cases, true, false);
        StmtClassForgeableJsonUtil.makeNoSuchElementDefault(switchStmt, CodegenExpressionBuilder.ref("num"));
        int index = 0;
        for (Map.Entry<String, Object> property : this.desc.getPropertiesThisType().entrySet()) {
            JsonUnderlyingField field = this.desc.getFieldDescriptorsInclSupertype().get(property.getKey());
            switchStmt.getBlocks()[index].blockReturn(CodegenExpressionBuilder.ref(field.getFieldName()));
            ++index;
        }
    }

    private void makeGetNativeEntry(CodegenMethod method, CodegenClassScope classScope) {
        CodegenMethod toEntry = method.makeChild(EPTypePremade.MAPENTRY.getEPType(), this.getClass(), (CodegenScope)classScope).addParam(EPTypePremade.STRING.getEPType(), "name").addParam(EPTypePremade.OBJECT.getEPType(), "value");
        toEntry.getBlock().methodReturn(CodegenExpressionBuilder.newInstance(EPTypePremade.ABSTRACTMAPSIMPLEENTRY.getEPType(), CodegenExpressionBuilder.ref("name"), CodegenExpressionBuilder.ref("value")));
        if (this.desc.getNumFieldsSupertype() > 0) {
            method.getBlock().ifCondition(CodegenExpressionBuilder.relational(CodegenExpressionBuilder.ref("num"), CodegenExpressionRelational.CodegenRelational.LT, CodegenExpressionBuilder.constant(this.desc.getNumFieldsSupertype()))).blockReturn(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("super"), "getNativeEntry", CodegenExpressionBuilder.ref("num")));
        }
        CodegenExpression[] cases = StmtClassForgeableJsonUtil.getCasesNumberNtoM(this.desc);
        CodegenStatementSwitch switchStmt = method.getBlock().switchBlockExpressions(CodegenExpressionBuilder.ref("num"), cases, true, false);
        StmtClassForgeableJsonUtil.makeNoSuchElementDefault(switchStmt, CodegenExpressionBuilder.ref("num"));
        int index = 0;
        for (Map.Entry<String, Object> property : this.desc.getPropertiesThisType().entrySet()) {
            JsonUnderlyingField field = this.desc.getFieldDescriptorsInclSupertype().get(property.getKey());
            switchStmt.getBlocks()[index].blockReturn(CodegenExpressionBuilder.localMethod(toEntry, CodegenExpressionBuilder.constant(property.getKey()), CodegenExpressionBuilder.ref(field.getFieldName())));
            ++index;
        }
    }

    private void makeGetNativeKey(CodegenMethod method) {
        if (this.desc.getNumFieldsSupertype() > 0) {
            method.getBlock().ifCondition(CodegenExpressionBuilder.relational(CodegenExpressionBuilder.ref("num"), CodegenExpressionRelational.CodegenRelational.LT, CodegenExpressionBuilder.constant(this.desc.getNumFieldsSupertype()))).blockReturn(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("super"), "getNativeKey", CodegenExpressionBuilder.ref("num")));
        }
        CodegenExpression[] cases = StmtClassForgeableJsonUtil.getCasesNumberNtoM(this.desc);
        CodegenStatementSwitch switchStmt = method.getBlock().switchBlockExpressions(CodegenExpressionBuilder.ref("num"), cases, true, false);
        StmtClassForgeableJsonUtil.makeNoSuchElementDefault(switchStmt, CodegenExpressionBuilder.ref("num"));
        int index = 0;
        for (Map.Entry<String, Object> property : this.desc.getPropertiesThisType().entrySet()) {
            switchStmt.getBlocks()[index].blockReturn(CodegenExpressionBuilder.constant(property.getKey()));
            ++index;
        }
    }

    private void makeNativeContainsKey(CodegenMethod method) {
        if (this.desc.getOptionalSupertype() != null) {
            method.getBlock().declareVar(EPTypePremade.BOOLEANBOXED.getEPType(), "parent", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("super"), "nativeContainsKey", CodegenExpressionBuilder.ref("name"))).ifCondition(CodegenExpressionBuilder.ref("parent")).blockReturn(CodegenExpressionBuilder.constantTrue());
        }
        if (this.desc.getPropertiesThisType().isEmpty()) {
            method.getBlock().methodReturn(CodegenExpressionBuilder.constantFalse());
            return;
        }
        Set<String> names = this.desc.getPropertiesThisType().keySet();
        Iterator<String> it = names.iterator();
        CodegenExpression or = CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("name"), "equals", CodegenExpressionBuilder.constant(it.next()));
        while (it.hasNext()) {
            or = CodegenExpressionBuilder.or(or, CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("name"), "equals", CodegenExpressionBuilder.constant(it.next())), new CodegenExpression[0]);
        }
        method.getBlock().methodReturn(or);
    }

    private boolean needDynamic() {
        return this.desc.isDynamic() && !this.parentDynamic();
    }

    private boolean parentDynamic() {
        return this.desc.getOptionalSupertype() != null && this.desc.getOptionalSupertype().getDetail().isDynamic();
    }
}

