/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.json.core;

import com.espertech.esper.common.client.json.minimaljson.JsonWriter;
import com.espertech.esper.common.client.json.minimaljson.WriterConfig;
import com.espertech.esper.common.client.json.minimaljson.WritingBuffer;
import com.espertech.esper.common.client.json.util.JsonEventObject;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.event.json.core.JsonEventUnderlyingEntrySet;
import com.espertech.esper.common.internal.event.json.core.JsonEventUnderlyingKeySet;
import com.espertech.esper.common.internal.event.json.core.JsonEventUnderlyingValueCollection;
import com.espertech.esper.common.internal.event.json.write.JsonWriteUtil;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;

public abstract class JsonEventObjectBase
implements JsonEventObject {
    public static final EPTypeClass EPTYPE = new EPTypeClass(JsonEventObjectBase.class);

    public abstract void addJsonValue(String var1, Object var2);

    public abstract Map<String, Object> getJsonValues();

    public abstract int getNativeSize();

    public abstract Map.Entry<String, Object> getNativeEntry(int var1);

    public abstract String getNativeKey(int var1);

    public abstract Object getNativeValue(int var1);

    public abstract int getNativeNum(String var1);

    public abstract boolean nativeContainsKey(Object var1);

    public abstract void nativeWrite(JsonWriter var1) throws IOException;

    @Override
    public void writeTo(Writer writer, WriterConfig config) throws IOException {
        WritingBuffer buffer = new WritingBuffer(writer, 128);
        this.write(config.createWriter(buffer));
        buffer.flush();
    }

    public void write(JsonWriter writer) throws IOException {
        writer.writeObjectOpen();
        this.nativeWrite(writer);
        boolean first = this.getNativeSize() == 0;
        for (Map.Entry<String, Object> entry : this.getJsonValues().entrySet()) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            writer.writeMemberName(entry.getKey());
            writer.writeMemberSeparator();
            JsonWriteUtil.writeJsonValue(writer, entry.getKey(), entry.getValue());
        }
        writer.writeObjectClose();
    }

    @Override
    public int size() {
        return this.getJsonValues().size() + this.getNativeSize();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return new JsonEventUnderlyingEntrySet(this);
    }

    @Override
    public boolean isEmpty() {
        return this.getNativeSize() == 0 && this.getJsonValues().isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return new JsonEventUnderlyingKeySet(this);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.nativeContainsKey(key) || this.getJsonValues().containsKey(key);
    }

    @Override
    public Object get(Object key) {
        if (key == null || !(key instanceof String)) {
            return this.getJsonValues().get(key);
        }
        int num = this.getNativeNum((String)key);
        if (num == -1) {
            return this.getJsonValues().get(key);
        }
        return this.getNativeValue(num);
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            for (int i = 0; i < this.getNativeSize(); ++i) {
                if (this.getNativeValue(i) != null) continue;
                return true;
            }
        } else {
            for (int i = 0; i < this.getNativeSize(); ++i) {
                if (!value.equals(this.getNativeValue(i))) continue;
                return true;
            }
        }
        return this.getJsonValues().containsValue(value);
    }

    @Override
    public Collection<Object> values() {
        return new JsonEventUnderlyingValueCollection(this, this.getJsonValues().values());
    }

    @Override
    public Object put(String key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replaceAll(BiFunction<? super String, ? super Object, ?> function) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object putIfAbsent(String key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean replace(String key, Object oldValue, Object newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object replace(String key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString(WriterConfig config) {
        StringWriter writer = new StringWriter();
        try {
            this.writeTo(writer, config);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        return writer.toString();
    }

    @Override
    public String toString() {
        return this.toString(WriterConfig.MINIMAL);
    }
}

