/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.json.core;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventPropertyDescriptor;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.json.minimaljson.JsonParser;
import com.espertech.esper.common.client.meta.EventTypeMetadata;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.event.bean.service.BeanEventTypeFactory;
import com.espertech.esper.common.internal.event.core.BaseNestableEventType;
import com.espertech.esper.common.internal.event.core.BaseNestableEventUtil;
import com.espertech.esper.common.internal.event.core.EventBeanCopyMethodForge;
import com.espertech.esper.common.internal.event.core.EventBeanWriter;
import com.espertech.esper.common.internal.event.core.EventTypeNestableGetterFactory;
import com.espertech.esper.common.internal.event.json.compiletime.JsonUnderlyingField;
import com.espertech.esper.common.internal.event.json.core.JsonEventTypeDetail;
import com.espertech.esper.common.internal.event.json.parser.core.JsonDelegateBase;
import com.espertech.esper.common.internal.event.json.parser.core.JsonDelegateFactory;
import com.espertech.esper.common.internal.event.json.parser.core.JsonHandlerDelegator;
import com.espertech.esper.common.internal.event.json.writer.JsonEventBeanCopyMethodForge;
import com.espertech.esper.common.internal.event.json.writer.JsonEventBeanPropertyWriter;
import com.espertech.esper.common.internal.event.json.writer.JsonEventBeanPropertyWriterIndexedProp;
import com.espertech.esper.common.internal.event.json.writer.JsonEventBeanPropertyWriterMapProp;
import com.espertech.esper.common.internal.event.json.writer.JsonEventBeanWriterPerProp;
import com.espertech.esper.common.internal.event.property.IndexedProperty;
import com.espertech.esper.common.internal.event.property.MappedProperty;
import com.espertech.esper.common.internal.event.property.Property;
import com.espertech.esper.common.internal.event.property.PropertyParser;
import com.espertech.esper.common.internal.util.ClassHelperGenericType;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class JsonEventType
extends BaseNestableEventType {
    public static final EPTypeClass EPTYPE = new EPTypeClass(JsonEventType.class);
    private final JsonEventTypeDetail detail;
    private Class delegateType;
    private JsonDelegateFactory delegateFactory;
    private EPTypeClass underlyingType;
    protected EventPropertyDescriptor[] writablePropertyDescriptors;
    protected Map<String, Pair<EventPropertyDescriptor, JsonEventBeanPropertyWriter>> propertyWriters;

    public JsonEventType(EventTypeMetadata metadata, Map<String, Object> propertyTypes, EventType[] optionalSuperTypes, Set<EventType> optionalDeepSupertypes, String startTimestampPropertyName, String endTimestampPropertyName, EventTypeNestableGetterFactory getterFactory, BeanEventTypeFactory beanEventTypeFactory, JsonEventTypeDetail detail, EPTypeClass underlyingStandInClass) {
        super(metadata, propertyTypes, optionalSuperTypes, optionalDeepSupertypes, startTimestampPropertyName, endTimestampPropertyName, getterFactory, beanEventTypeFactory, true);
        this.detail = detail;
        this.underlyingType = underlyingStandInClass;
    }

    @Override
    public JsonEventBeanPropertyWriter getWriter(String propertyName) {
        Pair<EventPropertyDescriptor, JsonEventBeanPropertyWriter> pair;
        if (this.writablePropertyDescriptors == null) {
            this.initializeWriters();
        }
        if ((pair = this.propertyWriters.get(propertyName)) != null) {
            return pair.getSecond();
        }
        Property property = PropertyParser.parseAndWalkLaxToSimple(propertyName);
        if (property instanceof MappedProperty) {
            MappedProperty mapProp = (MappedProperty)property;
            JsonUnderlyingField field = this.detail.getFieldDescriptors().get(mapProp.getPropertyNameAtomic());
            if (field == null) {
                return null;
            }
            return new JsonEventBeanPropertyWriterMapProp(this.delegateFactory, field, mapProp.getKey());
        }
        if (property instanceof IndexedProperty) {
            IndexedProperty indexedProp = (IndexedProperty)property;
            JsonUnderlyingField field = this.detail.getFieldDescriptors().get(indexedProp.getPropertyNameAtomic());
            if (field == null) {
                return null;
            }
            return new JsonEventBeanPropertyWriterIndexedProp(this.delegateFactory, field, indexedProp.getIndex());
        }
        return null;
    }

    @Override
    public EventPropertyDescriptor[] getWriteableProperties() {
        if (this.writablePropertyDescriptors == null) {
            this.initializeWriters();
        }
        return this.writablePropertyDescriptors;
    }

    @Override
    public EventPropertyDescriptor getWritableProperty(String propertyName) {
        Pair<EventPropertyDescriptor, JsonEventBeanPropertyWriter> pair;
        if (this.writablePropertyDescriptors == null) {
            this.initializeWriters();
        }
        if ((pair = this.propertyWriters.get(propertyName)) != null) {
            return pair.getFirst();
        }
        Property property = PropertyParser.parseAndWalkLaxToSimple(propertyName);
        if (property instanceof MappedProperty) {
            JsonEventBeanPropertyWriter writer = this.getWriter(propertyName);
            if (writer == null) {
                return null;
            }
            MappedProperty mapProp = (MappedProperty)property;
            return new EventPropertyDescriptor(mapProp.getPropertyNameAtomic(), EPTypePremade.OBJECT.getEPType(), false, true, false, true, false);
        }
        if (property instanceof IndexedProperty) {
            JsonEventBeanPropertyWriter writer = this.getWriter(propertyName);
            if (writer == null) {
                return null;
            }
            IndexedProperty indexedProp = (IndexedProperty)property;
            return new EventPropertyDescriptor(indexedProp.getPropertyNameAtomic(), EPTypePremade.OBJECT.getEPType(), true, false, true, false, false);
        }
        return null;
    }

    @Override
    public EventBeanCopyMethodForge getCopyMethodForge(String[] properties) {
        return new JsonEventBeanCopyMethodForge(this);
    }

    @Override
    public EventBeanWriter getWriter(String[] properties) {
        if (this.writablePropertyDescriptors == null) {
            this.initializeWriters();
        }
        JsonEventBeanPropertyWriter[] writers = new JsonEventBeanPropertyWriter[properties.length];
        for (int i = 0; i < properties.length; ++i) {
            writers[i] = this.getWriter(properties[i]);
            if (writers[i] != null) continue;
            return null;
        }
        return new JsonEventBeanWriterPerProp(writers);
    }

    @Override
    public Class getUnderlyingType() {
        if (this.underlyingType == null) {
            throw new EPException("Underlying type has not been set");
        }
        return this.underlyingType.getType();
    }

    @Override
    public EPTypeClass getUnderlyingEPType() {
        if (this.underlyingType == null) {
            throw new EPException("Underlying type has not been set");
        }
        return this.underlyingType;
    }

    public void initialize(ClassLoader classLoader) {
        Class<?> delegateFactory;
        try {
            Class<?> clazz = Class.forName(this.detail.getUnderlyingClassName(), true, classLoader);
            this.underlyingType = ClassHelperGenericType.getClassEPType(clazz);
        }
        catch (ClassNotFoundException ex) {
            throw new EPException("Failed to load Json underlying class: " + ex.getMessage(), ex);
        }
        try {
            this.delegateType = Class.forName(this.detail.getDelegateClassName(), true, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new EPException("Failed to find class: " + e.getMessage(), e);
        }
        try {
            delegateFactory = Class.forName(this.detail.getDelegateFactoryClassName(), true, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new EPException("Failed to find class: " + e.getMessage(), e);
        }
        this.delegateFactory = (JsonDelegateFactory)JavaClassHelper.instantiate(JsonDelegateFactory.class, delegateFactory);
    }

    public Object parse(String json) {
        try {
            JsonHandlerDelegator handler = new JsonHandlerDelegator();
            JsonDelegateBase delegate = this.delegateFactory.make(handler, null);
            handler.setDelegate(delegate);
            JsonParser parser = new JsonParser(handler);
            parser.parse(json);
            return delegate.getResult();
        }
        catch (EPException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw new EPException("Failed to parse Json: " + ex.getMessage(), ex);
        }
    }

    public JsonEventTypeDetail getDetail() {
        return this.detail;
    }

    public Class getDelegateType() {
        return this.delegateType;
    }

    public JsonDelegateFactory getDelegateFactory() {
        return this.delegateFactory;
    }

    public int getColumnNumber(String columnName) {
        JsonUnderlyingField field = this.detail.getFieldDescriptors().get(columnName);
        if (field != null) {
            return field.getPropertyNumber();
        }
        throw new IllegalStateException("Unrecognized json-type column name '" + columnName + "'");
    }

    public boolean isDeepEqualsConsiderOrder(JsonEventType other) {
        if (other.nestableTypes.size() != this.nestableTypes.size()) {
            return false;
        }
        for (Map.Entry propMeEntry : this.nestableTypes.entrySet()) {
            Object setTwoType;
            boolean setOneTypeFound;
            Object setOneType;
            JsonUnderlyingField fieldMe = this.detail.getFieldDescriptors().get(propMeEntry.getKey());
            JsonUnderlyingField fieldOther = other.detail.getFieldDescriptors().get(propMeEntry.getKey());
            if (fieldOther == null || fieldMe.getPropertyNumber() != fieldOther.getPropertyNumber()) {
                return false;
            }
            String propName = (String)propMeEntry.getKey();
            ExprValidationException comparedMessage = BaseNestableEventUtil.comparePropType(propName, setOneType = this.nestableTypes.get(propName), setOneTypeFound = this.nestableTypes.containsKey(propName), setTwoType = other.nestableTypes.get(propName), other.getName());
            if (comparedMessage == null) continue;
            return false;
        }
        return true;
    }

    private void initializeWriters() {
        ArrayList<EventPropertyDescriptor> writeableProps = new ArrayList<EventPropertyDescriptor>();
        HashMap<String, Pair<EventPropertyDescriptor, JsonEventBeanPropertyWriter>> propertWritersMap = new HashMap<String, Pair<EventPropertyDescriptor, JsonEventBeanPropertyWriter>>();
        for (EventPropertyDescriptor prop : this.propertyDescriptors) {
            JsonUnderlyingField field = this.detail.getFieldDescriptors().get(prop.getPropertyName());
            if (field == null) continue;
            writeableProps.add(prop);
            JsonEventBeanPropertyWriter eventPropertyWriter = new JsonEventBeanPropertyWriter(this.delegateFactory, field);
            propertWritersMap.put(prop.getPropertyName(), new Pair<EventPropertyDescriptor, JsonEventBeanPropertyWriter>(prop, eventPropertyWriter));
        }
        this.propertyWriters = propertWritersMap;
        this.writablePropertyDescriptors = writeableProps.toArray(new EventPropertyDescriptor[writeableProps.size()]);
    }
}

