/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.json.parser.delegates.endvalue;

import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.event.json.parser.delegates.endvalue.JsonEndValueForge;
import com.espertech.esper.common.internal.event.json.parser.delegates.endvalue.JsonEndValueForgeUtil;
import com.espertech.esper.common.internal.event.json.parser.delegates.endvalue.JsonEndValueRefs;
import java.time.LocalDateTime;
import java.time.format.DateTimeParseException;

public class JsonEndValueForgeLocalDateTime
implements JsonEndValueForge {
    public static final JsonEndValueForgeLocalDateTime INSTANCE = new JsonEndValueForgeLocalDateTime();

    private JsonEndValueForgeLocalDateTime() {
    }

    @Override
    public CodegenExpression captureValue(JsonEndValueRefs refs, CodegenMethod method, CodegenClassScope classScope) {
        return CodegenExpressionBuilder.staticMethod(JsonEndValueForgeLocalDateTime.class, "jsonToLocalDateTime", refs.getValueString(), refs.getName());
    }

    public static LocalDateTime jsonToLocalDateTime(String value, String name) {
        return value == null ? null : JsonEndValueForgeLocalDateTime.jsonToLocalDateTimeNonNull(value, name);
    }

    public static LocalDateTime jsonToLocalDateTimeNonNull(String stringValue, String name) {
        try {
            return LocalDateTime.parse(stringValue);
        }
        catch (DateTimeParseException ex) {
            throw JsonEndValueForgeUtil.handleParseException(name, LocalDateTime.class, stringValue, ex);
        }
    }
}

