/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.map;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.PropertyAccessException;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.event.map.MapEventPropertyGetter;
import java.util.Map;

public class MapDynamicPropertyGetter
implements MapEventPropertyGetter {
    private final String propertyName;

    public MapDynamicPropertyGetter(String propertyName) {
        this.propertyName = propertyName;
    }

    @Override
    public Object getMap(Map<String, Object> map) throws PropertyAccessException {
        return map.get(this.propertyName);
    }

    @Override
    public boolean isMapExistsProperty(Map<String, Object> map) {
        return map.containsKey(this.propertyName);
    }

    @Override
    public Object get(EventBean eventBean) throws PropertyAccessException {
        Map map = (Map)eventBean.getUnderlying();
        return map.get(this.propertyName);
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        Map map = (Map)eventBean.getUnderlying();
        return map.containsKey(this.propertyName);
    }

    @Override
    public Object getFragment(EventBean eventBean) {
        return null;
    }

    @Override
    public CodegenExpression eventBeanGetCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.castUnderlying(EPTypePremade.MAP.getEPType(), beanExpression), "get", CodegenExpressionBuilder.constant(this.propertyName));
    }

    @Override
    public CodegenExpression eventBeanExistsCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.castUnderlying(EPTypePremade.MAP.getEPType(), beanExpression), "containsKey", CodegenExpressionBuilder.constant(this.propertyName));
    }

    @Override
    public CodegenExpression eventBeanFragmentCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.constantNull();
    }

    @Override
    public CodegenExpression underlyingGetCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.exprDotMethod(underlyingExpression, "get", CodegenExpressionBuilder.constant(this.propertyName));
    }

    @Override
    public CodegenExpression underlyingExistsCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.exprDotMethod(underlyingExpression, "containsKey", CodegenExpressionBuilder.constant(this.propertyName));
    }

    @Override
    public CodegenExpression underlyingFragmentCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.constantNull();
    }
}

