/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.map;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.PropertyAccessException;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionField;
import com.espertech.esper.common.internal.context.module.EPStatementInitServices;
import com.espertech.esper.common.internal.event.bean.core.BeanEventType;
import com.espertech.esper.common.internal.event.core.BaseNestableEventUtil;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactoryCodegenField;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import com.espertech.esper.common.internal.event.map.MapEventPropertyGetter;
import java.util.Map;

public class MapEntryPropertyGetter
implements MapEventPropertyGetter {
    private final String propertyName;
    private final EventBeanTypedEventFactory eventBeanTypedEventFactory;
    private final BeanEventType eventType;
    private final boolean canFragment;

    public MapEntryPropertyGetter(String propertyName, BeanEventType eventType, EventBeanTypedEventFactory eventBeanTypedEventFactory, boolean canFragment) {
        this.propertyName = propertyName;
        this.eventBeanTypedEventFactory = eventBeanTypedEventFactory;
        this.eventType = eventType;
        this.canFragment = canFragment;
    }

    @Override
    public Object getMap(Map<String, Object> map) throws PropertyAccessException {
        Object value = map.get(this.propertyName);
        if (value instanceof EventBean) {
            return ((EventBean)value).getUnderlying();
        }
        return value;
    }

    private CodegenExpression getMapCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        if (!this.canFragment) {
            return CodegenExpressionBuilder.exprDotMethod(underlyingExpression, "get", CodegenExpressionBuilder.constant(this.propertyName));
        }
        CodegenMethod method = codegenMethodScope.makeChild(EPTypePremade.OBJECT.getEPType(), MapEntryPropertyGetter.class, (CodegenScope)codegenClassScope).addParam(EPTypePremade.MAP.getEPType(), "map").getBlock().declareVar(EPTypePremade.OBJECT.getEPType(), "value", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("map"), "get", CodegenExpressionBuilder.constant(this.propertyName))).ifInstanceOf("value", EventBean.EPTYPE).blockReturn(CodegenExpressionBuilder.exprDotUnderlying(CodegenExpressionBuilder.cast(EventBean.EPTYPE, (CodegenExpression)CodegenExpressionBuilder.ref("value")))).methodReturn(CodegenExpressionBuilder.ref("value"));
        return CodegenExpressionBuilder.localMethod(method, underlyingExpression);
    }

    @Override
    public boolean isMapExistsProperty(Map<String, Object> map) {
        return true;
    }

    @Override
    public Object get(EventBean obj) {
        return this.getMap(BaseNestableEventUtil.checkedCastUnderlyingMap(obj));
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        return true;
    }

    @Override
    public Object getFragment(EventBean eventBean) {
        if (this.eventType == null) {
            return null;
        }
        Object result = this.get(eventBean);
        return BaseNestableEventUtil.getBNFragmentPojo(result, this.eventType, this.eventBeanTypedEventFactory);
    }

    @Override
    public CodegenExpression eventBeanGetCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return this.underlyingGetCodegen(CodegenExpressionBuilder.castUnderlying(EPTypePremade.MAP.getEPType(), beanExpression), codegenMethodScope, codegenClassScope);
    }

    @Override
    public CodegenExpression eventBeanExistsCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.constantTrue();
    }

    @Override
    public CodegenExpression eventBeanFragmentCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        if (this.eventType == null) {
            return CodegenExpressionBuilder.constantNull();
        }
        return this.underlyingFragmentCodegen(CodegenExpressionBuilder.castUnderlying(EPTypePremade.MAP.getEPType(), beanExpression), codegenMethodScope, codegenClassScope);
    }

    @Override
    public CodegenExpression underlyingGetCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return this.getMapCodegen(underlyingExpression, codegenMethodScope, codegenClassScope);
    }

    @Override
    public CodegenExpression underlyingExistsCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.exprDotMethod(underlyingExpression, "containsKey", CodegenExpressionBuilder.constant(this.propertyName));
    }

    @Override
    public CodegenExpression underlyingFragmentCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        if (this.eventType == null) {
            return CodegenExpressionBuilder.constantNull();
        }
        CodegenExpressionField mSvc = codegenClassScope.addOrGetFieldSharable(EventBeanTypedEventFactoryCodegenField.INSTANCE);
        CodegenExpressionField mType = codegenClassScope.addFieldUnshared(true, BeanEventType.EPTYPE, CodegenExpressionBuilder.cast(BeanEventType.EPTYPE, EventTypeUtility.resolveTypeCodegen(this.eventType, EPStatementInitServices.REF)));
        return CodegenExpressionBuilder.staticMethod(BaseNestableEventUtil.class, "getBNFragmentPojo", this.underlyingGetCodegen(underlyingExpression, codegenMethodScope, codegenClassScope), mType, mSvc);
    }
}

