/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.map;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.PropertyAccessException;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.event.core.BaseNestableEventUtil;
import com.espertech.esper.common.internal.event.map.MapEventPropertyGetter;
import java.util.Map;

public class MapEventBeanArrayPropertyGetter
implements MapEventPropertyGetter {
    private final String propertyName;
    private final EPTypeClass underlyingType;

    public MapEventBeanArrayPropertyGetter(String propertyName, EPTypeClass underlyingType) {
        this.propertyName = propertyName;
        this.underlyingType = underlyingType;
    }

    @Override
    public Object getMap(Map<String, Object> map) throws PropertyAccessException {
        Object mapValue = map.get(this.propertyName);
        return BaseNestableEventUtil.getArrayPropertyAsUnderlyingsArray(this.underlyingType, (EventBean[])mapValue);
    }

    private CodegenMethod getMapCodegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return codegenMethodScope.makeChild(EPTypePremade.OBJECT.getEPType(), this.getClass(), (CodegenScope)codegenClassScope).addParam(EPTypePremade.MAP.getEPType(), "map").getBlock().declareVar(EPTypePremade.OBJECT.getEPType(), "mapValue", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("map"), "get", CodegenExpressionBuilder.constant(this.propertyName))).methodReturn(CodegenExpressionBuilder.localMethod(BaseNestableEventUtil.getArrayPropertyAsUnderlyingsArrayCodegen(this.underlyingType, codegenMethodScope, codegenClassScope), CodegenExpressionBuilder.cast(EventBean.EPTYPEARRAY, (CodegenExpression)CodegenExpressionBuilder.ref("mapValue"))));
    }

    @Override
    public boolean isMapExistsProperty(Map<String, Object> map) {
        return true;
    }

    @Override
    public Object get(EventBean obj) {
        return this.getMap(BaseNestableEventUtil.checkedCastUnderlyingMap(obj));
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        return true;
    }

    @Override
    public Object getFragment(EventBean obj) {
        Map<String, Object> map = BaseNestableEventUtil.checkedCastUnderlyingMap(obj);
        return map.get(this.propertyName);
    }

    @Override
    public CodegenExpression eventBeanGetCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return this.underlyingGetCodegen(CodegenExpressionBuilder.castUnderlying(EPTypePremade.MAP.getEPType(), beanExpression), codegenMethodScope, codegenClassScope);
    }

    @Override
    public CodegenExpression eventBeanExistsCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.constantTrue();
    }

    @Override
    public CodegenExpression eventBeanFragmentCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return this.underlyingFragmentCodegen(CodegenExpressionBuilder.castUnderlying(EPTypePremade.MAP.getEPType(), beanExpression), codegenMethodScope, codegenClassScope);
    }

    @Override
    public CodegenExpression underlyingGetCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.localMethod(this.getMapCodegen(codegenMethodScope, codegenClassScope), underlyingExpression);
    }

    @Override
    public CodegenExpression underlyingExistsCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.constantTrue();
    }

    @Override
    public CodegenExpression underlyingFragmentCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.exprDotMethod(underlyingExpression, "get", CodegenExpressionBuilder.constant(this.propertyName));
    }
}

