/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.path;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.util.NameAccessModifier;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.collection.PathException;
import com.espertech.esper.common.internal.collection.PathRegistry;
import com.espertech.esper.common.internal.event.bean.core.BeanEventType;
import com.espertech.esper.common.internal.event.bean.service.BeanEventTypeFactoryPrivate;
import com.espertech.esper.common.internal.event.core.EventTypeNameResolver;
import com.espertech.esper.common.internal.event.path.EventTypeResolver;
import com.espertech.esper.common.internal.serde.runtime.event.EventSerdeFactory;
import java.util.Collections;
import java.util.Map;

public class EventTypeResolverImpl
implements EventTypeResolver,
EventTypeNameResolver {
    private final Map<String, EventType> locals;
    private final PathRegistry<String, EventType> path;
    private final EventTypeNameResolver publics;
    private final BeanEventTypeFactoryPrivate beanEventTypeFactoryPrivate;
    private final EventSerdeFactory eventSerdeFactory;

    public EventTypeResolverImpl(Map<String, EventType> locals, PathRegistry<String, EventType> path, EventTypeNameResolver publics, BeanEventTypeFactoryPrivate beanEventTypeFactoryPrivate, EventSerdeFactory eventSerdeFactory) {
        this.locals = locals;
        this.path = path;
        this.publics = publics;
        this.beanEventTypeFactoryPrivate = beanEventTypeFactoryPrivate;
        this.eventSerdeFactory = eventSerdeFactory;
    }

    @Override
    public EventType getTypeByName(String typeName) {
        EventType localType = this.locals.get(typeName);
        if (localType != null) {
            return localType;
        }
        EventType publicType = this.publics.getTypeByName(typeName);
        if (publicType != null) {
            return publicType;
        }
        try {
            Pair<EventType, String> pair = this.path.getAnyModuleExpectSingle(typeName, null);
            return pair == null ? null : pair.getFirst();
        }
        catch (PathException e) {
            throw new EPException("Event type name '" + typeName + "' is ambigous: " + e.getMessage(), e);
        }
    }

    @Override
    public BeanEventType resolvePrivateBean(EPTypeClass clazz, boolean publicFields) {
        return this.beanEventTypeFactoryPrivate.getCreateBeanType(clazz, publicFields);
    }

    @Override
    public EventType resolve(String name, String moduleName, NameAccessModifier accessModifier) {
        return EventTypeResolverImpl.resolve(name, moduleName, accessModifier, this.publics, this.locals, this.path);
    }

    @Override
    public EventSerdeFactory getEventSerdeFactory() {
        return this.eventSerdeFactory;
    }

    public static EventType resolve(String name, String moduleName, NameAccessModifier accessModifier, EventTypeNameResolver publics, Map<String, EventType> locals, PathRegistry<String, EventType> path) {
        EventType type;
        if (accessModifier == NameAccessModifier.PRECONFIGURED) {
            type = publics.getTypeByName(name);
            if (type == null) {
                type = locals.get(name);
            }
        } else if (accessModifier == NameAccessModifier.PUBLIC || accessModifier == NameAccessModifier.PROTECTED) {
            EventType local = locals.get(name);
            if (local != null && (local.getMetadata().getAccessModifier() == NameAccessModifier.PUBLIC || local.getMetadata().getAccessModifier() == NameAccessModifier.PROTECTED)) {
                return local;
            }
            try {
                Pair<EventType, String> pair = path.getAnyModuleExpectSingle(name, Collections.singleton(moduleName));
                type = pair == null ? null : pair.getFirst();
            }
            catch (PathException e) {
                throw new EPException(e.getMessage(), e);
            }
        } else {
            type = locals.get(name);
        }
        if (type == null) {
            throw new EPException("Failed to find event type '" + name + "' among public types, modules-in-path or the current module itself");
        }
        return type;
    }
}

