/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.variant;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionField;
import com.espertech.esper.common.internal.context.module.EPStatementInitServices;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import com.espertech.esper.common.internal.event.variant.VariantEventType;
import java.util.Iterator;

public class VariantEventTypeUtil {
    public static CodegenExpressionField getField(VariantEventType variantEventType, CodegenClassScope codegenClassScope) {
        return codegenClassScope.addFieldUnshared(true, VariantEventType.EPTYPE, CodegenExpressionBuilder.cast(VariantEventType.EPTYPE, EventTypeUtility.resolveTypeCodegen(variantEventType, EPStatementInitServices.REF)));
    }

    public static void validateInsertedIntoEventType(EventType eventType, VariantEventType variantEventType) throws ExprValidationException {
        EventType[] variants;
        if (variantEventType.isVariantAny()) {
            return;
        }
        if (eventType == null) {
            throw new ExprValidationException(VariantEventTypeUtil.getMessage(variantEventType.getName()));
        }
        for (EventType variant : variants = variantEventType.getVariants()) {
            if (variant != eventType) continue;
            return;
        }
        for (EventType variant : variants) {
            Iterator<EventType> deepSupers = eventType.getDeepSuperTypes();
            if (deepSupers == null) continue;
            while (deepSupers.hasNext()) {
                EventType superType = deepSupers.next();
                if (superType != variant) continue;
                return;
            }
        }
        throw new ExprValidationException(VariantEventTypeUtil.getMessage(variantEventType.getName()));
    }

    private static String getMessage(String name) {
        return "Selected event type is not a valid event type of the variant stream '" + name + "'";
    }
}

