/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.variant;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypeNull;
import com.espertech.esper.common.internal.event.core.EventPropertyGetterSPI;
import com.espertech.esper.common.internal.event.variant.VariantEventPropertyGetterAny;
import com.espertech.esper.common.internal.event.variant.VariantEventPropertyGetterAnyWCast;
import com.espertech.esper.common.internal.event.variant.VariantEventType;
import com.espertech.esper.common.internal.event.variant.VariantPropResolutionStrategy;
import com.espertech.esper.common.internal.event.variant.VariantPropertyDesc;
import com.espertech.esper.common.internal.event.variant.VariantPropertyGetterCache;
import com.espertech.esper.common.internal.util.ClassHelperGenericType;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import com.espertech.esper.common.internal.util.SimpleTypeCaster;
import com.espertech.esper.common.internal.util.SimpleTypeCasterFactory;
import java.util.Iterator;
import java.util.LinkedHashSet;

public class VariantPropResolutionStrategyDefault
implements VariantPropResolutionStrategy {
    private final VariantEventType variantEventType;

    public VariantPropResolutionStrategyDefault(VariantEventType variantEventType) {
        this.variantEventType = variantEventType;
    }

    @Override
    public VariantPropertyDesc resolveProperty(String propertyName, EventType[] variants) {
        EventPropertyGetterSPI getter;
        boolean existsInAll = true;
        EPType commonType = null;
        boolean mustCoerce = false;
        for (int i = 0; i < variants.length; ++i) {
            Class superClassType2;
            EPType propertyType = JavaClassHelper.getBoxedType(variants[i].getPropertyEPType(propertyName));
            if (propertyType == null) {
                existsInAll = false;
                continue;
            }
            if (commonType == null) {
                commonType = propertyType;
                continue;
            }
            if (propertyType.equals(commonType) || commonType == EPTypeNull.INSTANCE) continue;
            EPTypeClass commonTypeClass = (EPTypeClass)commonType;
            if (!(propertyType instanceof EPTypeClass)) continue;
            EPTypeClass typeClass = (EPTypeClass)propertyType;
            if (JavaClassHelper.isNumeric(typeClass)) {
                if (JavaClassHelper.canCoerce(typeClass.getType(), commonTypeClass.getType())) {
                    mustCoerce = true;
                    continue;
                }
                if (!JavaClassHelper.canCoerce(commonTypeClass.getType(), typeClass.getType())) continue;
                mustCoerce = true;
                commonType = typeClass;
                continue;
            }
            if (commonTypeClass.getType() == Object.class || JavaClassHelper.isJavaBuiltinDataType(typeClass)) continue;
            LinkedHashSet<Class> supersForType = new LinkedHashSet<Class>();
            JavaClassHelper.getSuper(typeClass.getType(), supersForType);
            supersForType.remove(Object.class);
            if (supersForType.contains(typeClass.getType())) continue;
            if (JavaClassHelper.isSubclassOrImplementsInterface((EPType)commonTypeClass, typeClass.getType())) {
                commonType = typeClass;
                continue;
            }
            LinkedHashSet<Class> supersForCommonType = new LinkedHashSet<Class>();
            JavaClassHelper.getSuper(commonTypeClass.getType(), supersForCommonType);
            supersForCommonType.remove(Object.class);
            boolean found = false;
            for (Class superClassType2 : supersForType) {
                if (superClassType2.isInterface() || !supersForCommonType.contains(superClassType2)) continue;
                commonType = ClassHelperGenericType.getClassEPType(superClassType2);
                found = true;
                break;
            }
            if (found) continue;
            Iterator iterator = supersForType.iterator();
            while (!(!iterator.hasNext() || (superClassType2 = (Class)iterator.next()).isInterface() && supersForCommonType.contains(superClassType2))) {
            }
        }
        if (!existsInAll) {
            return null;
        }
        if (commonType == null) {
            return null;
        }
        VariantPropertyGetterCache propertyGetterCache = this.variantEventType.getVariantPropertyGetterCache();
        propertyGetterCache.addGetters(propertyName);
        if (mustCoerce) {
            SimpleTypeCaster caster = SimpleTypeCasterFactory.getCaster(EPTypeNull.INSTANCE, (EPTypeClass)commonType);
            getter = new VariantEventPropertyGetterAnyWCast(this.variantEventType, propertyName, caster);
        } else {
            getter = new VariantEventPropertyGetterAny(this.variantEventType, propertyName);
        }
        return new VariantPropertyDesc(commonType, getter, true);
    }
}

