/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.xml;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.PropertyAccessException;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionField;
import com.espertech.esper.common.internal.event.core.EventPropertyGetterSPI;
import com.espertech.esper.common.internal.event.xml.DOMPropertyGetter;
import com.espertech.esper.common.internal.util.SimpleTypeParser;
import com.espertech.esper.common.internal.util.SimpleTypeParserCodegenFieldSharable;
import com.espertech.esper.common.internal.util.SimpleTypeParserFactory;
import com.espertech.esper.common.internal.util.SimpleTypeParserSPI;
import java.lang.reflect.Array;
import org.w3c.dom.Node;

public class DOMConvertingArrayGetter
implements EventPropertyGetterSPI {
    private final DOMPropertyGetter getter;
    private final Class componentType;
    private final SimpleTypeParserSPI parser;

    public DOMConvertingArrayGetter(DOMPropertyGetter domPropertyGetter, Class returnType) {
        this.getter = domPropertyGetter;
        this.componentType = returnType;
        this.parser = SimpleTypeParserFactory.getParser(returnType);
    }

    @Override
    public Object get(EventBean obj) throws PropertyAccessException {
        if (!(obj.getUnderlying() instanceof Node)) {
            throw new PropertyAccessException("Mismatched property getter to event bean type, the underlying data object is not of type Node");
        }
        Node node = (Node)obj.getUnderlying();
        Node[] result = this.getter.getValueAsNodeArray(node);
        if (result == null) {
            return null;
        }
        return DOMConvertingArrayGetter.getDOMArrayFromNodes(result, this.componentType, this.parser);
    }

    private CodegenMethod getCodegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        CodegenExpressionField mComponentType = codegenClassScope.addFieldUnshared(true, EPTypePremade.CLASS.getEPType(), CodegenExpressionBuilder.constant(this.componentType));
        CodegenExpressionField mParser = codegenClassScope.addOrGetFieldSharable(new SimpleTypeParserCodegenFieldSharable(this.parser, codegenClassScope));
        return codegenMethodScope.makeChild(EPTypePremade.OBJECT.getEPType(), this.getClass(), (CodegenScope)codegenClassScope).addParam(EPTypePremade.NODE.getEPType(), "node").getBlock().declareVar(EPTypePremade.NODEARRAY.getEPType(), "result", this.getter.getValueAsNodeArrayCodegen(CodegenExpressionBuilder.ref("node"), codegenMethodScope, codegenClassScope)).ifRefNullReturnNull("result").methodReturn(CodegenExpressionBuilder.staticMethod(this.getClass(), "getDOMArrayFromNodes", CodegenExpressionBuilder.ref("result"), mComponentType, mParser));
    }

    public static Object getDOMArrayFromNodes(Node[] result, Class componentType, SimpleTypeParser parser) {
        Object array = Array.newInstance(componentType, result.length);
        for (int i = 0; i < result.length; ++i) {
            String text = result[i].getTextContent();
            if (text == null || text.length() == 0) continue;
            Object parseResult = parser.parse(text);
            Array.set(array, i, parseResult);
        }
        return array;
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        return true;
    }

    @Override
    public Object getFragment(EventBean eventBean) throws PropertyAccessException {
        return null;
    }

    @Override
    public CodegenExpression eventBeanGetCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return this.underlyingGetCodegen(CodegenExpressionBuilder.castUnderlying(EPTypePremade.NODE.getEPType(), beanExpression), codegenMethodScope, codegenClassScope);
    }

    @Override
    public CodegenExpression eventBeanExistsCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.constantTrue();
    }

    @Override
    public CodegenExpression eventBeanFragmentCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.constantNull();
    }

    @Override
    public CodegenExpression underlyingGetCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.localMethod(this.getCodegen(codegenMethodScope, codegenClassScope), underlyingExpression);
    }

    @Override
    public CodegenExpression underlyingExistsCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.constantTrue();
    }

    @Override
    public CodegenExpression underlyingFragmentCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.constantNull();
    }
}

