/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.xml;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.configuration.common.ConfigurationCommonEventTypeXMLDOM;
import com.espertech.esper.common.client.meta.EventTypeApplicationType;
import com.espertech.esper.common.client.meta.EventTypeIdPair;
import com.espertech.esper.common.client.meta.EventTypeMetadata;
import com.espertech.esper.common.client.meta.EventTypeTypeClass;
import com.espertech.esper.common.client.util.EventTypeBusModifier;
import com.espertech.esper.common.client.util.NameAccessModifier;
import com.espertech.esper.common.internal.context.module.EventTypeCompileTimeRegistry;
import com.espertech.esper.common.internal.event.bean.service.BeanEventTypeFactory;
import com.espertech.esper.common.internal.event.core.EventTypeNameResolver;
import com.espertech.esper.common.internal.event.xml.EventTypeXMLXSDHandler;
import com.espertech.esper.common.internal.event.xml.SchemaElementComplex;
import com.espertech.esper.common.internal.event.xml.SchemaXMLEventType;
import com.espertech.esper.common.internal.util.CRC32Util;
import java.util.HashMap;
import java.util.Map;

public class XMLFragmentEventTypeFactory {
    private final BeanEventTypeFactory eventTypeFactory;
    private final EventTypeCompileTimeRegistry optionalCompileTimeRegistry;
    private final EventTypeNameResolver eventTypeNameResolver;
    private final EventTypeXMLXSDHandler eventTypeXMLXSDHandler;
    private Map<String, SchemaXMLEventType> rootTypes;
    private Map<String, SchemaXMLEventType> derivedTypes;

    public XMLFragmentEventTypeFactory(BeanEventTypeFactory eventTypeFactory, EventTypeCompileTimeRegistry optionalCompileTimeRegistry, EventTypeNameResolver eventTypeNameResolver, EventTypeXMLXSDHandler eventTypeXMLXSDHandler) {
        this.eventTypeFactory = eventTypeFactory;
        this.optionalCompileTimeRegistry = optionalCompileTimeRegistry;
        this.eventTypeNameResolver = eventTypeNameResolver;
        this.eventTypeXMLXSDHandler = eventTypeXMLXSDHandler;
    }

    public void addRootType(SchemaXMLEventType type) {
        if (this.rootTypes == null) {
            this.rootTypes = new HashMap<String, SchemaXMLEventType>();
        }
        if (this.rootTypes.containsKey(type.getName())) {
            throw new IllegalStateException("Type '" + type.getName() + "' already exists");
        }
        this.rootTypes.put(type.getName(), type);
    }

    public EventType getTypeByName(String derivedEventTypeName) {
        if (this.derivedTypes == null) {
            this.derivedTypes = new HashMap<String, SchemaXMLEventType>();
        }
        return this.derivedTypes.get(derivedEventTypeName);
    }

    public EventType getCreateXMLDOMType(String rootTypeName, String derivedEventTypeName, String moduleName, SchemaElementComplex complex, String representsFragmentOfProperty) {
        SchemaXMLEventType type;
        if (this.rootTypes == null) {
            this.rootTypes = new HashMap<String, SchemaXMLEventType>();
        }
        if (this.derivedTypes == null) {
            this.derivedTypes = new HashMap<String, SchemaXMLEventType>();
        }
        if ((type = this.rootTypes.get(rootTypeName)) == null) {
            throw new IllegalStateException("Failed to find XML root event type '" + rootTypeName + "'");
        }
        ConfigurationCommonEventTypeXMLDOM config = type.getConfigurationEventTypeXMLDOM();
        ConfigurationCommonEventTypeXMLDOM xmlDom = new ConfigurationCommonEventTypeXMLDOM();
        xmlDom.setRootElementName("//" + complex.getName());
        xmlDom.setRootElementNamespace(complex.getNamespace());
        xmlDom.setAutoFragment(config.isAutoFragment());
        xmlDom.setEventSenderValidatesRoot(config.isEventSenderValidatesRoot());
        xmlDom.setXPathPropertyExpr(config.isXPathPropertyExpr());
        xmlDom.setXPathResolvePropertiesAbsolute(config.isXPathResolvePropertiesAbsolute());
        xmlDom.setSchemaResource(config.getSchemaResource());
        xmlDom.setSchemaText(config.getSchemaText());
        xmlDom.setXPathFunctionResolver(config.getXPathFunctionResolver());
        xmlDom.setXPathVariableResolver(config.getXPathVariableResolver());
        xmlDom.setDefaultNamespace(config.getDefaultNamespace());
        xmlDom.addNamespacePrefixes(config.getNamespacePrefixes());
        EventTypeMetadata metadata = new EventTypeMetadata(derivedEventTypeName, moduleName, EventTypeTypeClass.STREAM, EventTypeApplicationType.XML, NameAccessModifier.PRECONFIGURED, EventTypeBusModifier.BUS, false, new EventTypeIdPair(CRC32Util.computeCRC32(derivedEventTypeName), -1L));
        SchemaXMLEventType eventType = (SchemaXMLEventType)this.eventTypeFactory.getEventTypeFactory().createXMLType(metadata, xmlDom, type.getSchemaModel(), representsFragmentOfProperty, rootTypeName, this.eventTypeFactory, this, this.eventTypeNameResolver, this.eventTypeXMLXSDHandler);
        this.derivedTypes.put(derivedEventTypeName, eventType);
        if (this.optionalCompileTimeRegistry != null) {
            this.optionalCompileTimeRegistry.newType(eventType);
        }
        return eventType;
    }

    public SchemaXMLEventType getRootTypeByName(String representsOriginalTypeName) {
        return this.rootTypes == null ? null : this.rootTypes.get(representsOriginalTypeName);
    }
}

